/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.canonicalizer;

import com.datasqrl.canonicalizer.NameCanonicalizer;
import com.datasqrl.canonicalizer.NamePath;
import com.datasqrl.canonicalizer.StandardName;
import java.io.Serializable;
import java.util.function.Function;
import lombok.NonNull;

public interface Name
extends Serializable,
Comparable<Name> {
    public static final String HIDDEN_PREFIX = "_";
    public static final String SYSTEM_HIDDEN_PREFIX = "__";
    public static final char NAME_DELIMITER = '$';

    public String getCanonical();

    default public boolean matches(String canonicalName) {
        String canonical = this.getCanonical();
        return canonicalName.startsWith(canonical) && (canonical.length() == canonicalName.length() || canonicalName.length() > canonical.length() && canonicalName.charAt(canonical.length()) == '$');
    }

    default public int length() {
        return this.getCanonical().length();
    }

    public String getDisplay();

    default public boolean isHidden() {
        return Name.isHiddenString(this.getCanonical());
    }

    default public boolean isSsytemHidden() {
        return this.getCanonical().startsWith(SYSTEM_HIDDEN_PREFIX);
    }

    default public NamePath toNamePath() {
        return NamePath.of(this);
    }

    default public Name append(Name name) {
        return new StandardName(this.getCanonical() + name.getCanonical(), this.getDisplay() + name.getCanonical());
    }

    default public Name suffix(String suffix) {
        return this.append(Name.system("$" + suffix));
    }

    public static String addSuffix(String str, String suffix) {
        return str + "$" + suffix;
    }

    public static boolean validName(String name) {
        return name != null && !name.trim().isEmpty();
    }

    public static <T> T getIfValidName(@NonNull String name, @NonNull NameCanonicalizer canonicalizer, @NonNull Function<Name, T> getter) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (canonicalizer == null) {
            throw new NullPointerException("canonicalizer is marked non-null but is null");
        }
        if (getter == null) {
            throw new NullPointerException("getter is marked non-null but is null");
        }
        if (!Name.validName(name)) {
            return null;
        }
        return getter.apply(canonicalizer.name(name));
    }

    public static <T> T getIfValidSystemName(String name, Function<Name, T> getter) {
        return Name.getIfValidName(name, NameCanonicalizer.SYSTEM, getter);
    }

    public static Name of(String name, NameCanonicalizer canonicalizer) {
        name = name.trim();
        return new StandardName(canonicalizer.getCanonical(name), name);
    }

    public static Name changeDisplayName(Name name, String displayName) {
        return new StandardName(name.getCanonical(), displayName.trim());
    }

    public static Name system(String name) {
        return Name.of(name, NameCanonicalizer.SYSTEM);
    }

    public static String hiddenString(String name) {
        if (Name.isHiddenString(name)) {
            return name;
        }
        return HIDDEN_PREFIX + name;
    }

    public static boolean isHiddenString(String name) {
        return name.startsWith(HIDDEN_PREFIX);
    }

    public static boolean isSystemHidden(String name) {
        return name.startsWith(SYSTEM_HIDDEN_PREFIX);
    }

    public boolean hasPrefix(Name var1);
}

