/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.canonicalizer;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public abstract class AbstractPath<E extends Comparable, P extends AbstractPath<E, P>>
implements Serializable,
Comparable<P> {
    protected final E[] elements;

    protected AbstractPath(E ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        this.elements = elements;
    }

    protected abstract Constructor<E, P> constructor();

    public P concat(@NonNull E element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        Comparable[] newelements = (Comparable[])Arrays.copyOf(this.elements, this.elements.length + 1);
        newelements[this.elements.length] = element;
        return (P)this.constructor().create(newelements);
    }

    public P concat(@NonNull P sub) {
        if (sub == null) {
            throw new NullPointerException("sub is marked non-null but is null");
        }
        Comparable[] newelements = (Comparable[])Arrays.copyOf(this.elements, this.elements.length + ((AbstractPath)sub).elements.length);
        System.arraycopy(((AbstractPath)sub).elements, 0, newelements, this.elements.length, ((AbstractPath)sub).elements.length);
        return (P)this.constructor().create(newelements);
    }

    public P prefix(int depth) {
        if (depth == 0) {
            return this.constructor().root();
        }
        Comparable[] newelements = (Comparable[])Arrays.copyOf(this.elements, depth);
        return (P)this.constructor().create(newelements);
    }

    public int size() {
        return this.elements.length;
    }

    public E get(int index) {
        return this.elements[index];
    }

    public Optional<E> getOptional(int index) {
        if (index >= 0 && index < this.size()) {
            return Optional.of(this.elements[index]);
        }
        return Optional.empty();
    }

    public E getLast() {
        return this.elements[this.elements.length - 1];
    }

    public String toString() {
        return this.toString(".");
    }

    public String toString(String separator) {
        if (this.elements.length == 0) {
            return "/";
        }
        return Arrays.stream(this.elements).map(obj -> Objects.toString(obj, "")).collect(Collectors.joining(separator));
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof AbstractPath)) {
            return false;
        }
        AbstractPath o = (AbstractPath)other;
        return Arrays.equals(this.elements, o.elements);
    }

    @Override
    public int compareTo(P o) {
        return Arrays.compare(this.elements, ((AbstractPath)o).elements);
    }

    public Optional<P> getPrefix() {
        if (this.elements.length <= 1) {
            return Optional.empty();
        }
        Comparable[] newNames = (Comparable[])Arrays.copyOfRange(this.elements, 0, this.elements.length - 1);
        return Optional.of(this.constructor().create(newNames));
    }

    public P popFirst() {
        Comparable[] newNames = (Comparable[])Arrays.copyOfRange(this.elements, 1, this.elements.length);
        return (P)this.constructor().create(newNames);
    }

    public P popLast() {
        Comparable[] newNames = (Comparable[])Arrays.copyOfRange(this.elements, 0, this.elements.length - 1);
        return (P)this.constructor().create(newNames);
    }

    public P parent() {
        return this.popLast();
    }

    public E getFirst() {
        return this.elements[0];
    }

    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    public P subList(int from, int to) {
        if (from < 0 || to < from || to > this.elements.length) {
            throw new IllegalArgumentException("Invalid offsets");
        }
        if (from == to) {
            return this.constructor().root();
        }
        Comparable[] newNames = (Comparable[])Arrays.copyOfRange(this.elements, from, to);
        return (P)this.constructor().create(newNames);
    }

    public Stream<E> stream() {
        return Arrays.stream(this.elements);
    }

    protected static abstract class Constructor<E extends Comparable, P extends AbstractPath<E, P>> {
        protected Constructor() {
        }

        protected abstract P create(E ... var1);

        protected abstract E[] createArray(int var1);

        protected abstract P root();

        public P of(@NonNull List<E> elements) {
            if (elements == null) {
                throw new NullPointerException("elements is marked non-null but is null");
            }
            return (P)this.create(elements.toArray(this.createArray(elements.size())));
        }

        public P parse(String path, Function<String, E> parser) {
            String[] arr = path.split("\\.");
            Comparable[] elements = this.createArray(arr.length);
            int i = 0;
            for (String e : arr) {
                elements[i++] = (Comparable)parser.apply(e);
            }
            return (P)this.create(elements);
        }

        public <E2> P of(Function<E2, E> converter, @NonNull E2[] elements) {
            if (elements == null) {
                throw new NullPointerException("elements is marked non-null but is null");
            }
            Comparable[] arr = (Comparable[])Arrays.stream(elements).map(converter).toArray((IntFunction<Comparable[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Ljava/lang/Comparable;)((Constructor)this));
            return (P)this.create(arr);
        }
    }
}

