/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.json;

import com.datasqrl.json.ArrayAgg;
import com.datasqrl.json.FlinkJsonType;
import java.util.ArrayList;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.functions.AggregateFunction;

public class JsonArrayAgg
extends AggregateFunction<FlinkJsonType, ArrayAgg> {
    private final ObjectMapper mapper = new ObjectMapper();

    public ArrayAgg createAccumulator() {
        return new ArrayAgg(new ArrayList<Object>());
    }

    public void accumulate(ArrayAgg accumulator, String value) {
        accumulator.add(value);
    }

    public void accumulate(ArrayAgg accumulator, FlinkJsonType value) {
        if (value != null) {
            accumulator.add(this.mapper.readTree(value.json));
        } else {
            accumulator.add(null);
        }
    }

    public void accumulate(ArrayAgg accumulator, Double value) {
        accumulator.add(value);
    }

    public void accumulate(ArrayAgg accumulator, Long value) {
        accumulator.add(value);
    }

    public void accumulate(ArrayAgg accumulator, Integer value) {
        accumulator.add(value);
    }

    public void retract(ArrayAgg accumulator, String value) {
        accumulator.remove(value);
    }

    public void retract(ArrayAgg accumulator, FlinkJsonType value) {
        if (value != null) {
            JsonNode jsonNode = this.mapper.readTree(value.json);
            accumulator.remove(jsonNode);
        } else {
            accumulator.remove(null);
        }
    }

    public void retract(ArrayAgg accumulator, Double value) {
        accumulator.remove(value);
    }

    public void retract(ArrayAgg accumulator, Long value) {
        accumulator.remove(value);
    }

    public void retract(ArrayAgg accumulator, Integer value) {
        accumulator.remove(value);
    }

    public FlinkJsonType getValue(ArrayAgg accumulator) {
        ArrayNode arrayNode = this.mapper.createArrayNode();
        for (Object o : accumulator.getObjects()) {
            if (o instanceof FlinkJsonType) {
                try {
                    arrayNode.add(this.mapper.readTree(((FlinkJsonType)o).json));
                    continue;
                }
                catch (JsonProcessingException e) {
                    return null;
                }
            }
            arrayNode.addPOJO(o);
        }
        return new FlinkJsonType(arrayNode.toString());
    }
}

