/*
 * Decompiled with CFR 0.152.
 */
package application.versioning.commands;

import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;
import run.qontract.core.Results;
import run.qontract.core.versioning.ContractIdentifier;
import run.qontract.core.versioning.RepoProvider;
import run.qontract.core.versioning.RepoUtils;

@CommandLine.Command(name="update", description={"Check the new contract for backward compatibility with the specified version, then overwrite the old one with it."}, mixinStandardHelpOptions=true)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lapplication/versioning/commands/UpdateCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "contractPath", "", "getContractPath", "()Ljava/lang/String;", "setContractPath", "(Ljava/lang/String;)V", "version", "", "getVersion", "()I", "setVersion", "(I)V", "call", "application"})
public final class UpdateCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", descriptionKey="contractPath")
    @NotNull
    private String contractPath = "";
    @CommandLine.Parameters(index="1", descriptionKey="version")
    private int version;

    @NotNull
    public final String getContractPath() {
        return this.contractPath;
    }

    public final void setContractPath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.contractPath = string;
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int n) {
        this.version = n;
    }

    @Override
    public void call() {
        String string = new File(this.contractPath).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(contractPath).name");
        ContractIdentifier identifier = new ContractIdentifier(StringsKt.removeSuffix((String)string, (CharSequence)".qontract"), this.version);
        File contractFile = new File(this.contractPath);
        if (!identifier.getCacheDescriptorFile().exists()) {
            String string2 = "Can't find " + identifier.getDisplayableString();
            boolean bl = false;
            System.out.println((Object)string2);
            return;
        }
        RepoProvider repoProvider = RepoUtils.getRepoProvider((ContractIdentifier)identifier);
        Results results = repoProvider.testBackwardCompatibility(identifier, contractFile);
        if (!results.success()) {
            String string3 = "The new contract is not backward compatible with the older one.";
            boolean bl = false;
            System.out.println((Object)string3);
            return;
        }
        repoProvider.updateContract(identifier, contractFile);
    }
}

