/*
 * Decompiled with CFR 0.152.
 */
package application.versioning.commands;

import application.versioning.commands.SuggestCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;
import run.qontract.core.Comparison;
import run.qontract.core.CompatibilityResult;
import run.qontract.core.Feature;
import run.qontract.core.FeatureKt;
import run.qontract.core.JustOne;
import run.qontract.core.NoContractsFound;
import run.qontract.core.Results;
import run.qontract.core.TestBackwardCompatibilityKt;
import run.qontract.core.TestResults;
import run.qontract.core.Version;
import run.qontract.core.VersionKt;
import run.qontract.core.pattern.ContractException;

@CommandLine.Command(name="suggest", mixinStandardHelpOptions=true, description={"Suggest the version of a contract"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u000e"}, d2={"Lapplication/versioning/commands/SuggestCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "contractDirPath", "", "getContractDirPath", "()Ljava/lang/String;", "setContractDirPath", "(Ljava/lang/String;)V", "contractFilePath", "getContractFilePath", "setContractFilePath", "call", "application"})
public final class SuggestCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"Path of the contract file"})
    @NotNull
    private String contractFilePath = "";
    @CommandLine.Parameters(index="1", description={"Directory containing versioned contracts"})
    @NotNull
    private String contractDirPath = "";

    @NotNull
    public final String getContractFilePath() {
        return this.contractFilePath;
    }

    public final void setContractFilePath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.contractFilePath = string;
    }

    @NotNull
    public final String getContractDirPath() {
        return this.contractDirPath;
    }

    public final void setContractDirPath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.contractDirPath = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void call() {
        void $this$mapNotNullTo$iv$iv;
        Object majorVersionNumbers;
        Iterable<Integer> destination$iv$iv;
        boolean $i$f$map;
        Object $this$map$iv;
        File contractDir;
        Feature newer;
        block27: {
            Object object;
            block26: {
                void $this$mapTo$iv$iv;
                newer = FeatureKt.Feature((String)FilesKt.readText$default((File)new File(this.contractFilePath), null, (int)1, null));
                contractDir = new File(this.contractDirPath);
                object = contractDir.listFiles();
                if (object == null) break block26;
                $this$map$iv = object;
                $i$f$map = false;
                File[] fileArray = $this$map$iv;
                destination$iv$iv = new ArrayList(((File[])$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var9_13 = $this$mapTo$iv$iv;
                int n = ((void)var9_13).length;
                for (int i = 0; i < n; ++i) {
                    int n2;
                    void it;
                    void item$iv$iv;
                    void var13_20 = item$iv$iv = var9_13[i];
                    Iterable<Integer> iterable = destination$iv$iv;
                    boolean bl = false;
                    try {
                        void v1 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                        String string = v1.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                        String string2 = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)string, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null));
                        boolean bl2 = false;
                        n2 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("The first part of the file name ");
                        void v4 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                        throw (Throwable)new Exception(stringBuilder.append(v4.getName()).append(" should be the major version number of the contract.").toString());
                    }
                    Integer n3 = n2;
                    iterable.add(n3);
                }
                object = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                if (object != null && (object = CollectionsKt.sorted((Iterable)((Iterable)object))) != null) break block27;
            }
            object = majorVersionNumbers = CollectionsKt.emptyList();
        }
        if (majorVersionNumbers.isEmpty()) {
            $this$map$iv = "No contracts were found in " + this.contractDirPath + '.';
            $i$f$map = false;
            System.out.println($this$map$iv);
            return;
        }
        Object $this$mapNotNull$iv = (Iterable)majorVersionNumbers;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Version version;
            String olderFilePath;
            String string;
            CompatibilityResult compatibilityResult;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            int majorVersionNumber = ((Number)element$iv$iv).intValue();
            boolean bl3 = false;
            try {
                compatibilityResult = TestBackwardCompatibilityKt.testBackwardCompatibilityInDirectory((File)contractDir, (int)majorVersionNumber, null);
            }
            catch (ContractException e) {
                compatibilityResult = null;
            }
            CompatibilityResult compatibilityResult2 = compatibilityResult;
            if (compatibilityResult2 instanceof TestResults) {
                boolean bl4;
                block25: {
                    Sequence $this$all$iv = ((TestResults)compatibilityResult2).getList();
                    boolean $i$f$all = false;
                    for (Object element$iv : $this$all$iv) {
                        Comparison it = (Comparison)element$iv;
                        boolean bl5 = false;
                        if (it.getResults().success()) continue;
                        bl4 = false;
                        break block25;
                    }
                    bl4 = true;
                }
                string = bl4 ? ((Comparison)SequencesKt.last((Sequence)((TestResults)compatibilityResult2).getList())).getNewer() : null;
            } else if (compatibilityResult2 instanceof JustOne) {
                string = ((JustOne)compatibilityResult2).getFilePath();
            } else {
                if (Intrinsics.areEqual((Object)compatibilityResult2, (Object)NoContractsFound.INSTANCE)) {
                    throw (Throwable)new Exception("There should have been a contract. Something is wrong.");
                }
                string = null;
            }
            String string3 = olderFilePath = string;
            if (string3 == null) {
                version = null;
            } else {
                Version version2;
                Feature older = FeatureKt.Feature((String)FilesKt.readText$default((File)new File(olderFilePath), null, (int)1, null));
                try {
                    Results results = TestBackwardCompatibilityKt.testBackwardCompatibility2((Feature)older, (Feature)newer);
                    version2 = results.success() ? VersionKt.toVersion((String)FilesKt.getNameWithoutExtension((File)new File(olderFilePath))).incrementedMinorVersion() : null;
                }
                catch (ContractException e) {
                    version2 = null;
                }
                version = version2;
            }
            if (version == null) continue;
            Version version3 = version;
            boolean bl6 = false;
            boolean bl7 = false;
            Version it$iv$iv = version3;
            boolean bl8 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List possibleVersions = (List)destination$iv$iv2;
        $this$mapNotNull$iv = possibleVersions;
        boolean bl = false;
        if (!$this$mapNotNull$iv.isEmpty()) {
            $this$mapNotNull$iv = "Recommended version: " + ((Version)CollectionsKt.last((List)possibleVersions)).toDisplayableString();
            bl = false;
            System.out.println($this$mapNotNull$iv);
            if (possibleVersions.size() > 1) {
                $this$mapNotNull$iv = "Available versions: " + CollectionsKt.joinToString$default((Iterable)possibleVersions, (CharSequence)", ", null, null, (int)0, null, (Function1)call.1.INSTANCE, (int)30, null);
                bl = false;
                System.out.println($this$mapNotNull$iv);
            }
        } else {
            String version = ((Number)CollectionsKt.last((List)majorVersionNumbers)).intValue() + ".0";
            String string = "Recommended version: " + version;
            boolean bl9 = false;
            System.out.println((Object)string);
            string = "Not compatible with any of the major versions (" + CollectionsKt.joinToString$default((Iterable)((Iterable)majorVersionNumbers), (CharSequence)", ", null, null, (int)0, null, (Function1)call.2.INSTANCE, (int)30, null) + ')';
            bl9 = false;
            System.out.println((Object)string);
        }
    }
}

