/*
 * Decompiled with CFR 0.152.
 */
package application.versioning.commands;

import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;
import run.qontract.core.versioning.ContractIdentifier;
import run.qontract.core.versioning.RepoProvider;
import run.qontract.core.versioning.RepoUtils;

@CommandLine.Command(name="show", description={"Display the specified contract on the console"}, mixinStandardHelpOptions=true)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lapplication/versioning/commands/ShowCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "contractName", "", "getContractName", "()Ljava/lang/String;", "setContractName", "(Ljava/lang/String;)V", "version", "", "getVersion", "()I", "setVersion", "(I)V", "call", "application"})
public final class ShowCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"Name of the contract"})
    @NotNull
    private String contractName = "";
    @CommandLine.Parameters(index="1", description={"Version of the contract"})
    private int version;

    @NotNull
    public final String getContractName() {
        return this.contractName;
    }

    public final void setContractName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.contractName = string;
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int n) {
        this.version = n;
    }

    @Override
    public void call() {
        ContractIdentifier identifier = new ContractIdentifier(this.contractName, this.version);
        RepoProvider repoProvider = RepoUtils.getRepoProvider((ContractIdentifier)identifier);
        String string = repoProvider.getContractData(identifier);
        boolean bl = false;
        System.out.println((Object)string);
    }
}

