/*
 * Decompiled with CFR 0.152.
 */
package application.versioning.commands;

import application.versioning.commands.GitRepo;
import application.versioning.commands.RepoCommandKt;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="repo", description={"Create a qontract repository that tracks an external repository containing contracts. Currently only external git repositories are supported."}, mixinStandardHelpOptions=true)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016J\u001c\u0010\u0005\u001a\u00020\u00022\b\b\u0003\u0010\u0006\u001a\u00020\u00072\b\b\u0003\u0010\b\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lapplication/versioning/commands/RepoCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "call", "git", "repoName", "", "repoURI", "application"})
public final class RepoCommand
implements Callable<Unit> {
    @CommandLine.Command
    public final void git(@CommandLine.Parameters(index="0", paramLabel="<repoName>", description={"The name of the git repository"}) @NotNull String repoName, @CommandLine.Parameters(index="1", paramLabel="<repoURI>", description={"The URL of the git repository"}) @NotNull String repoURI) {
        Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
        Intrinsics.checkParameterIsNotNull((Object)repoURI, (String)"repoURI");
        GitRepo gitRepo = new GitRepo(repoName, repoURI);
        RepoCommandKt.checkoutGitRepo(gitRepo);
        RepoCommandKt.createRepoDescriptor(gitRepo);
        RepoCommandKt.linkContracts(gitRepo);
    }

    public static /* synthetic */ void git$default(RepoCommand repoCommand, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        repoCommand.git(string, string2);
    }

    @Override
    public void call() {
        new CommandLine((Object)new RepoCommand()).usage(System.out);
    }
}

