/*
 * Decompiled with CFR 0.152.
 */
package application.versioning.commands;

import application.versioning.commands.IncrementCommandKt;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;
import run.qontract.core.versioning.ContractIdentifier;
import run.qontract.core.versioning.ContractIdentifierKt;
import run.qontract.core.versioning.PointerInfo;
import run.qontract.core.versioning.RepoProvider;
import run.qontract.core.versioning.RepoUtils;

@CommandLine.Command(name="increment", description={"Store the contract as a new version, which is one greater than the highest available version."}, mixinStandardHelpOptions=true)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lapplication/versioning/commands/IncrementCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "contractPath", "", "getContractPath", "()Ljava/lang/String;", "setContractPath", "(Ljava/lang/String;)V", "call", "application"})
public final class IncrementCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"path to the contract"})
    @NotNull
    private String contractPath = "";

    @NotNull
    public final String getContractPath() {
        return this.contractPath;
    }

    public final void setContractPath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.contractPath = string;
    }

    @Override
    public void call() {
        String string = new File(this.contractPath).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(contractPath).name");
        String name = StringsKt.removeSuffix((String)string, (CharSequence)".qontract");
        Integer version = ContractIdentifierKt.findLatestVersion((String)name);
        if (version == null) {
            String string2 = "There are no prior versions. This contract is completely new";
            boolean bl = false;
            System.out.println((Object)string2);
            return;
        }
        ContractIdentifier latestInCache = new ContractIdentifier(name, version.intValue());
        ContractIdentifier next = latestInCache.incrementedVersion();
        File contractFile = new File(this.contractPath);
        RepoProvider repoProvider = RepoUtils.getRepoProvider((ContractIdentifier)latestInCache);
        PointerInfo pointerInfo = repoProvider.addContract(next, contractFile);
        IncrementCommandKt.createPointerFile(next, pointerInfo);
    }
}

