/*
 * Decompiled with CFR 0.152.
 */
package application.versioning.commands;

import application.versioning.commands.CheckGitFileCommandKt;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;
import run.qontract.core.Feature;
import run.qontract.core.FeatureKt;
import run.qontract.core.Results;
import run.qontract.core.TestBackwardCompatibilityKt;

@CommandLine.Command(name="checkGitFile", mixinStandardHelpOptions=true, description={"Check backward compatibility of the current file with the version in the last commit in git"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lapplication/versioning/commands/CheckGitFileCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "filePath", "", "getFilePath", "()Ljava/lang/String;", "setFilePath", "(Ljava/lang/String;)V", "call", "application"})
public final class CheckGitFileCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"Git file to check"})
    @NotNull
    private String filePath = "";

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public final void setFilePath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.filePath = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void call() {
        try {
            void commitId;
            File gitFile = new File(this.filePath);
            Pair pair = CheckGitFileCommandKt.access$getOlder(gitFile);
            String string = (String)pair.component1();
            Feature older = (Feature)pair.component2();
            Feature newer = FeatureKt.Feature((String)FilesKt.readText$default((File)gitFile, null, (int)1, null));
            Results results = TestBackwardCompatibilityKt.testBackwardCompatibility2((Feature)older, (Feature)newer);
            if (!results.success()) {
                String string2 = "This contract is not backward compatible with the previous one in commit " + (String)commitId + '.';
                boolean bl = false;
                System.out.println((Object)string2);
                boolean bl2 = false;
                System.out.println();
                String string3 = Results.report$default((Results)results, null, (int)1, null);
                bl = false;
                System.out.println((Object)string3);
                int n = 1;
                bl = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            String string4 = "This contract is backward compatible with the previous one in commit " + (String)commitId + '.';
            boolean bl = false;
            System.out.println((Object)string4);
        }
        catch (Throwable e) {
            String string = e.getLocalizedMessage();
            boolean bl = false;
            System.out.println((Object)string);
        }
    }
}

