/*
 * Decompiled with CFR 0.152.
 */
package application.versioning.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;
import run.qontract.core.Comparison;
import run.qontract.core.CompatibilityResult;
import run.qontract.core.JustOne;
import run.qontract.core.NoContractsFound;
import run.qontract.core.Results;
import run.qontract.core.TestBackwardCompatibilityKt;
import run.qontract.core.TestResults;

@CommandLine.Command(name="checkAncestors", mixinStandardHelpOptions=true, description={"Check backward compatibility of all versions in a directory"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u000e"}, d2={"Lapplication/versioning/commands/CheckAncestorsCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "directory", "", "getDirectory", "()Ljava/lang/String;", "setDirectory", "(Ljava/lang/String;)V", "version", "getVersion", "setVersion", "call", "application"})
public final class CheckAncestorsCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"Name of the directory"})
    @NotNull
    private String directory = "";
    @CommandLine.Parameters(index="1", description={"Version"})
    @NotNull
    private String version = "";

    @NotNull
    public final String getDirectory() {
        return this.directory;
    }

    public final void setDirectory(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.directory = string;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.version = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void call() {
        void exitValue;
        Pair pair;
        Integer minorVersion;
        void $this$mapTo$iv$iv;
        Object $this$map$iv2 = StringsKt.split$default((CharSequence)this.version, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv22;
            boolean bl = false;
            void var11_17 = it;
            boolean bl2 = false;
            Integer n = Integer.parseInt((String)var11_17);
            collection.add(n);
        }
        List versionTokens = (List)destination$iv$iv22;
        if (versionTokens.isEmpty() || versionTokens.size() > 2) {
            $this$map$iv2 = "Versions must be of the format <majorVersion>.<minorVersion>";
            $i$f$map = false;
            System.out.println($this$map$iv2);
            int $this$map$iv2 = 1;
            $i$f$map = false;
            System.exit($this$map$iv2);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        int majorVersion = ((Number)versionTokens.get(0)).intValue();
        CompatibilityResult result = TestBackwardCompatibilityKt.testBackwardCompatibilityInDirectory((File)new File(this.directory), (int)majorVersion, (Integer)(minorVersion = (Integer)CollectionsKt.getOrNull((List)versionTokens, (int)1)));
        CompatibilityResult compatibilityResult = result;
        if (compatibilityResult instanceof JustOne) {
            pair = new Pair((Object)0, (Object)("There was just one contract: " + ((JustOne)result).getFilePath()));
        } else if (compatibilityResult instanceof TestResults) {
            Object v1;
            block9: {
                Sequence $this$firstOrNull$iv = ((TestResults)result).getList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Comparison it = (Comparison)element$iv;
                    boolean bl = false;
                    if (!(!it.getResults().success())) continue;
                    v1 = element$iv;
                    break block9;
                }
                v1 = null;
            }
            Comparison failure = v1;
            pair = failure == null ? new Pair((Object)0, (Object)"Contracts are all backward compatible.") : new Pair((Object)1, (Object)StringsKt.trimIndent((String)(failure.getOlder() + " => " + failure.getNewer() + '\n' + Results.report$default((Results)failure.getResults(), null, (int)1, null) + "\n\nBackward compatibility breakdown detected between " + failure.getOlder() + " and " + failure.getNewer() + "\n                    ")));
        } else if (Intrinsics.areEqual((Object)compatibilityResult, (Object)NoContractsFound.INSTANCE)) {
            pair = new Pair((Object)0, (Object)"There were no files with this version number");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        int destination$iv$iv22 = ((Number)pair2.component1()).intValue();
        String message = (String)pair2.component2();
        boolean bl = false;
        System.out.println((Object)message);
        bl = false;
        System.exit((int)exitValue);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

