/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.test.ContractExecutionListener;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import picocli.CommandLine;
import run.qontract.core.utilities.Utilities;
import run.qontract.test.QontractJUnitSupport;

@CommandLine.Command(name="test", mixinStandardHelpOptions=true, description={"Run contract as tests"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u001b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u00104\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001e\u0010\u0016\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001e\u0010\u0019\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020\u000e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\u0012R\u001e\u0010\"\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001e\u0010%\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0010\"\u0004\b'\u0010\u0012R\u001e\u0010(\u001a\u00020\u000e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0010\"\u0004\b*\u0010\u0012R\u001e\u0010+\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001c\"\u0004\b-\u0010\u001eR\u001e\u0010.\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0007\"\u0004\b0\u0010\tR \u00101\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0010\"\u0004\b3\u0010\u0012\u00a8\u00065"}, d2={"Lapplication/TestCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "checkBackwardCompatibility", "", "getCheckBackwardCompatibility", "()Z", "setCheckBackwardCompatibility", "(Z)V", "commit", "getCommit", "setCommit", "host", "", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "kafkaBootstrapServers", "getKafkaBootstrapServers", "setKafkaBootstrapServers", "kafkaHost", "getKafkaHost", "setKafkaHost", "kafkaPort", "", "getKafkaPort", "()I", "setKafkaPort", "(I)V", "path", "getPath", "setPath", "port", "getPort", "setPort", "suggestions", "getSuggestions", "setSuggestions", "suggestionsPath", "getSuggestionsPath", "setSuggestionsPath", "timeout", "getTimeout", "setTimeout", "useHttps", "getUseHttps", "setUseHttps", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "call", "application"})
public final class TestCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"Contract or manifest file path"})
    @NotNull
    public String path;
    @CommandLine.Option(names={"--host"}, description={"The host to bind to, e.g. localhost or some locally bound IP"}, defaultValue="localhost")
    @NotNull
    public String host;
    @CommandLine.Option(names={"--port"}, description={"The port to bind to"})
    private int port;
    @CommandLine.Option(names={"--suggestionsPath"}, description={"Location of the suggestions file"}, defaultValue="")
    @NotNull
    public String suggestionsPath;
    @CommandLine.Option(names={"--suggestions"}, description={"A json value with scenario name and multiple suggestions"}, defaultValue="")
    @NotNull
    private String suggestions = "";
    @CommandLine.Option(names={"--https"}, description={"Use https instead of the default http"}, required=false)
    private boolean useHttps;
    @CommandLine.Option(names={"--checkBackwardCompatibility", "--check", "-c"}, description={"Identify versions of the contract prior to the one specified, and verify backward compatibility from the earliest to the latest"})
    private boolean checkBackwardCompatibility;
    @CommandLine.Option(names={"--timeout"}, description={"Specify a timeout for the test requests"}, required=false, defaultValue="60")
    private int timeout = 60;
    @CommandLine.Option(names={"--kafkaBootstrapServers"}, description={"Kafka's Bootstrap servers"}, required=false)
    @NotNull
    private String kafkaBootstrapServers = "";
    @CommandLine.Option(names={"--kafkaHost"}, description={"The host on which to connect to Kafka"}, required=false)
    @NotNull
    private String kafkaHost = "localhost";
    @CommandLine.Option(names={"--kafkaPort"}, description={"The port on which to connect to Kafka"}, required=false)
    private int kafkaPort = 9093;
    @CommandLine.Option(names={"--commit"}, description={"Commit kafka messages that have been read"}, required=false)
    private boolean commit;
    @CommandLine.Option(names={"--workingDirectory"}, description={"The working directory in which contacts will be checked out"})
    @Nullable
    private String workingDirectory;

    @NotNull
    public final String getPath() {
        String string = this.path;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"path");
        }
        return string;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @NotNull
    public final String getHost() {
        String string = this.host;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        }
        return string;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getSuggestionsPath() {
        String string = this.suggestionsPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"suggestionsPath");
        }
        return string;
    }

    public final void setSuggestionsPath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.suggestionsPath = string;
    }

    @NotNull
    public final String getSuggestions() {
        return this.suggestions;
    }

    public final void setSuggestions(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.suggestions = string;
    }

    public final boolean getUseHttps() {
        return this.useHttps;
    }

    public final void setUseHttps(boolean bl) {
        this.useHttps = bl;
    }

    public final boolean getCheckBackwardCompatibility() {
        return this.checkBackwardCompatibility;
    }

    public final void setCheckBackwardCompatibility(boolean bl) {
        this.checkBackwardCompatibility = bl;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(int n) {
        this.timeout = n;
    }

    @NotNull
    public final String getKafkaBootstrapServers() {
        return this.kafkaBootstrapServers;
    }

    public final void setKafkaBootstrapServers(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.kafkaBootstrapServers = string;
    }

    @NotNull
    public final String getKafkaHost() {
        return this.kafkaHost;
    }

    public final void setKafkaHost(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.kafkaHost = string;
    }

    public final int getKafkaPort() {
        return this.kafkaPort;
    }

    public final void setKafkaPort(int n) {
        this.kafkaPort = n;
    }

    public final boolean getCommit() {
        return this.commit;
    }

    public final void setCommit(boolean bl) {
        this.commit = bl;
    }

    @Nullable
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@Nullable String string) {
        this.workingDirectory = string;
    }

    @Override
    public void call() {
        try {
            String protocol;
            if (this.port == 0) {
                this.port = this.useHttps ? 443 : 9000;
            }
            String string = this.port == 443 ? "https" : (protocol = this.useHttps ? "https" : "http");
            if (this.workingDirectory != null) {
                String string2 = this.path;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"path");
                }
                File file = new File(string2);
                String string3 = this.workingDirectory;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                Utilities.ensureThatManifestAndWorkingDirectoryExist((File)file, (File)new File(string3));
                String string4 = this.workingDirectory;
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                Utilities.ensureEmptyOrNotExists((File)new File(string4));
                String string5 = this.path;
                if (string5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"path");
                }
                System.setProperty("manifestFile", string5);
                String string6 = this.workingDirectory;
                if (string6 == null) {
                    Intrinsics.throwNpe();
                }
                System.setProperty("workingDirectory", string6);
            } else {
                String string7 = this.path;
                if (string7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"path");
                }
                System.setProperty("path", string7);
            }
            String string8 = this.host;
            if (string8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"host");
            }
            System.setProperty("host", string8);
            System.setProperty("port", String.valueOf(this.port));
            System.setProperty("timeout", String.valueOf(this.timeout));
            String string9 = this.suggestionsPath;
            if (string9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"suggestionsPath");
            }
            System.setProperty("suggestionsPath", string9);
            System.setProperty("suggestions", this.suggestions);
            System.setProperty("checkBackwardCompatibility", String.valueOf(this.checkBackwardCompatibility));
            System.setProperty("protocol", protocol);
            System.setProperty("kafkaBootstrapServers", this.kafkaBootstrapServers);
            System.setProperty("kafkaHost", this.kafkaHost);
            System.setProperty("kafkaPort", String.valueOf(this.kafkaPort));
            System.setProperty("commit", String.valueOf(this.commit));
            if (this.kafkaPort != 0) {
                System.setProperty("kafkaPort", String.valueOf(this.kafkaPort));
            }
            Launcher launcher = LauncherFactory.create();
            LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{(DiscoverySelector)DiscoverySelectors.selectClass(QontractJUnitSupport.class)}).configurationParameter("key", "value").build();
            Intrinsics.checkExpressionValueIsNotNull((Object)launcherDiscoveryRequest, (String)"LauncherDiscoveryRequest\u2026\n                .build()");
            LauncherDiscoveryRequest request = launcherDiscoveryRequest;
            launcher.discover(request);
            ContractExecutionListener contractExecutionListener = new ContractExecutionListener();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{contractExecutionListener});
            launcher.execute(request, new TestExecutionListener[0]);
            contractExecutionListener.exitProcess();
        }
        catch (Throwable e) {
            String string = Utilities.exceptionCauseMessage((Throwable)e);
            boolean bl = false;
            System.out.println((Object)string);
        }
    }
}

