/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.ProxyCommandKt;
import application.StubCommand;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import run.qontract.LogTail;
import run.qontract.LogUtilsKt;
import run.qontract.core.Feature;
import run.qontract.core.KeyStoreData;
import run.qontract.core.QontractKafka;
import run.qontract.core.Result;
import run.qontract.core.Results;
import run.qontract.core.Scenario;
import run.qontract.core.pattern.ContractException;
import run.qontract.core.utilities.Utilities;
import run.qontract.mock.NoMatchingScenario;
import run.qontract.stub.API;
import run.qontract.stub.ContractStub;
import run.qontract.stub.HttpStub;
import run.qontract.stub.HttpStubKt;
import run.qontract.stub.KafkaStubData;
import run.qontract.stub.KafkaStubKt;

@CommandLine.Command(name="stub", mixinStandardHelpOptions=true, description={"Start a stub server with contract"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010C\u001a\u00020\u0002H\u0002J\b\u0010D\u001a\u00020\u0002H\u0016J\u0016\u0010E\u001a\u00020;2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u000bH\u0002J\u0016\u0010H\u001a\u00020;2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u000bH\u0002J\u001c\u0010I\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\f0J2\u0006\u0010K\u001a\u00020LH\u0002J\b\u0010M\u001a\u00020\u0002H\u0002J\b\u0010N\u001a\u00020\u0002H\u0002J\b\u0010O\u001a\u00020\u0002H\u0002J\u0016\u0010P\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020Q0\u000bH\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001e\u0010\u0014\u001a\u00020\f8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001e\u0010\u001c\u001a\u00020\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u001e\u0010%\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0016\"\u0004\b'\u0010\u0018R\u001e\u0010(\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0016\"\u0004\b*\u0010\u0018R\u001e\u0010+\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0016\"\u0004\b-\u0010\u0018R\u001e\u0010.\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0016\"\u0004\b0\u0010\u0018R\u001e\u00101\u001a\u00020\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001f\"\u0004\b3\u0010!R\u001c\u00104\u001a\u0004\u0018\u000105X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001e\u0010:\u001a\u00020;8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001e\u0010@\u001a\u00020;8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010=\"\u0004\bB\u0010?\u00a8\u0006R"}, d2={"Lapplication/StubCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "contractFake", "Lrun/qontract/stub/ContractStub;", "getContractFake", "()Lrun/qontract/stub/ContractStub;", "setContractFake", "(Lrun/qontract/stub/ContractStub;)V", "contractPaths", "", "", "getContractPaths", "()Ljava/util/List;", "setContractPaths", "(Ljava/util/List;)V", "dataDirs", "getDataDirs", "setDataDirs", "host", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "kafkaHost", "getKafkaHost", "setKafkaHost", "kafkaPort", "", "getKafkaPort", "()I", "setKafkaPort", "(I)V", "keyPassword", "getKeyPassword", "setKeyPassword", "keyStoreAlias", "getKeyStoreAlias", "setKeyStoreAlias", "keyStoreDir", "getKeyStoreDir", "setKeyStoreDir", "keyStoreFile", "getKeyStoreFile", "setKeyStoreFile", "keyStorePassword", "getKeyStorePassword", "setKeyStorePassword", "port", "getPort", "setPort", "qontractKafka", "Lrun/qontract/core/QontractKafka;", "getQontractKafka", "()Lrun/qontract/core/QontractKafka;", "setQontractKafka", "(Lrun/qontract/core/QontractKafka;)V", "startKafka", "", "getStartKafka", "()Z", "setStartKafka", "(Z)V", "strictMode", "getStrictMode", "setStrictMode", "addShutdownHook", "call", "hasHttpScenarios", "behaviours", "Lrun/qontract/core/Feature;", "hasKafkaScenarios", "isRestartNeeded", "Lkotlin/Pair;", "key", "Ljava/nio/file/WatchKey;", "restartServer", "startServer", "stopServer", "watchForChanges", "Ljava/nio/file/Path;", "application"})
public final class StubCommand
implements Callable<Unit> {
    @Nullable
    private ContractStub contractFake;
    @Nullable
    private QontractKafka qontractKafka;
    @CommandLine.Parameters(arity="1..*", description={"Contract file paths"})
    @NotNull
    public List<String> contractPaths;
    @CommandLine.Option(names={"--data"}, description={"Directory in which contract data may be found"}, required=false)
    @NotNull
    private List<String> dataDirs;
    @CommandLine.Option(names={"--host"}, description={"Host for the http stub"}, defaultValue="localhost")
    @NotNull
    public String host;
    @CommandLine.Option(names={"--port"}, description={"Port for the http stub"}, defaultValue="9000")
    private int port;
    @CommandLine.Option(names={"--startKafka"}, description={"Host on which to dump the stubbed kafka message"}, defaultValue="false")
    private boolean startKafka;
    @CommandLine.Option(names={"--kafkaHost"}, description={"Host on which to dump the stubbed kafka message"}, defaultValue="localhost", required=false)
    @NotNull
    private String kafkaHost;
    @CommandLine.Option(names={"--kafkaPort"}, description={"Port for the Kafka stub"}, defaultValue="9093", required=false)
    private int kafkaPort;
    @CommandLine.Option(names={"--strict"}, description={"Start HTTP stub in strict mode"}, required=false)
    private boolean strictMode;
    @CommandLine.Option(names={"--httpsKeyStore"}, description={"EXPERIMENTAL: Run the proxy on https using a key in this store"})
    @NotNull
    private String keyStoreFile;
    @CommandLine.Option(names={"--httpsKeyStoreDir"}, description={"EXPERIMENTAL: Run the proxy on https, create a store named qontract.jks in this directory"})
    @NotNull
    private String keyStoreDir;
    @CommandLine.Option(names={"--httpsKeyStorePassword"}, description={"EXPERIMENTAL: Run the proxy on https, password for pre-existing key store"})
    @NotNull
    private String keyStorePassword;
    @CommandLine.Option(names={"--httpsKeyAlias"}, description={"EXPERIMENTAL: Run the proxy on https using a key by this name"})
    @NotNull
    private String keyStoreAlias;
    @CommandLine.Option(names={"--httpsPassword"}, description={"EXPERIMENTAL: Key password if any"})
    @NotNull
    private String keyPassword;

    @Nullable
    public final ContractStub getContractFake() {
        return this.contractFake;
    }

    public final void setContractFake(@Nullable ContractStub contractStub) {
        this.contractFake = contractStub;
    }

    @Nullable
    public final QontractKafka getQontractKafka() {
        return this.qontractKafka;
    }

    public final void setQontractKafka(@Nullable QontractKafka qontractKafka) {
        this.qontractKafka = qontractKafka;
    }

    @NotNull
    public final List<String> getContractPaths() {
        List<String> list = this.contractPaths;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contractPaths");
        }
        return list;
    }

    public final void setContractPaths(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.contractPaths = list;
    }

    @NotNull
    public final List<String> getDataDirs() {
        return this.dataDirs;
    }

    public final void setDataDirs(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.dataDirs = list;
    }

    @NotNull
    public final String getHost() {
        String string = this.host;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        }
        return string;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    public final boolean getStartKafka() {
        return this.startKafka;
    }

    public final void setStartKafka(boolean bl) {
        this.startKafka = bl;
    }

    @NotNull
    public final String getKafkaHost() {
        return this.kafkaHost;
    }

    public final void setKafkaHost(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.kafkaHost = string;
    }

    public final int getKafkaPort() {
        return this.kafkaPort;
    }

    public final void setKafkaPort(int n) {
        this.kafkaPort = n;
    }

    public final boolean getStrictMode() {
        return this.strictMode;
    }

    public final void setStrictMode(boolean bl) {
        this.strictMode = bl;
    }

    @NotNull
    public final String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public final void setKeyStoreFile(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keyStoreFile = string;
    }

    @NotNull
    public final String getKeyStoreDir() {
        return this.keyStoreDir;
    }

    public final void setKeyStoreDir(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keyStoreDir = string;
    }

    @NotNull
    public final String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public final void setKeyStorePassword(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keyStorePassword = string;
    }

    @NotNull
    public final String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public final void setKeyStoreAlias(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keyStoreAlias = string;
    }

    @NotNull
    public final String getKeyPassword() {
        return this.keyPassword;
    }

    public final void setKeyPassword(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keyPassword = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void call() {
        try {
            void $this$flatMapTo$iv$iv;
            Object object;
            Iterable<Path> destination$iv$iv;
            void $this$flatMapTo$iv$iv2;
            void $this$mapTo$iv$iv;
            this.startServer();
            this.addShutdownHook();
            List<String> list = this.contractPaths;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contractPaths");
            }
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                File file = new File((String)it).getAbsoluteFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File(it).absoluteFile");
                Path path = file.getParentFile().toPath();
                collection.add(path);
            }
            List contractPathParentPaths = (List)destination$iv$iv2;
            List<String> list2 = this.contractPaths;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contractPaths");
            }
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            destination$iv$iv2 = $this$flatMap$iv;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                void $this$mapTo$iv$iv2;
                String contractFilePath = (String)element$iv$iv;
                boolean bl = false;
                String string = API.implicitContractDataDir((String)contractFilePath).getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"implicitContractDataDir(\u2026actFilePath).absolutePath");
                Iterable $this$map$iv2 = API.allDirsInTree((String)string);
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    File file = (File)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl2 = false;
                    Path path = it.toPath();
                    object.add(path);
                }
                Iterable list$iv$iv = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List contractPathDataDirPaths = (List)destination$iv$iv3;
            Iterable $this$flatMap$iv2 = this.dataDirs;
            boolean $i$f$flatMap2 = false;
            destination$iv$iv3 = $this$flatMap$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv3;
                String it = (String)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv3 = API.allDirsInTree((String)it);
                boolean $i$f$map3 = false;
                destination$iv$iv = $this$map$iv3;
                Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it2;
                    object = (File)item$iv$iv;
                    Collection collection = destination$iv$iv5;
                    boolean bl3 = false;
                    Path path = it2.getAbsoluteFile().toPath();
                    collection.add(path);
                }
                Iterable list$iv$iv = (List)destination$iv$iv5;
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            List dataDirPaths = (List)destination$iv$iv4;
            Collection collection = this.dataDirs;
            boolean bl = false;
            List pathsToWatch = !collection.isEmpty() ? CollectionsKt.plus((Collection)contractPathParentPaths, (Iterable)dataDirPaths) : CollectionsKt.plus((Collection)contractPathParentPaths, (Iterable)contractPathDataDirPaths);
            while (true) {
                this.watchForChanges(pathsToWatch);
            }
        }
        catch (NoMatchingScenario e) {
            String string = e.getLocalizedMessage();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.localizedMessage");
            LogUtilsKt.consoleLog((String)string);
        }
        catch (ContractException e) {
            LogUtilsKt.consoleLog((String)e.report());
        }
        catch (Throwable e) {
            LogUtilsKt.consoleLog((String)Utilities.exceptionCauseMessage((Throwable)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void watchForChanges(List<? extends Path> contractPaths) {
        WatchService watchService = FileSystems.getDefault().newWatchService();
        Iterable $this$forEach$iv = contractPaths;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Path contractPath = (Path)element$iv;
            boolean bl = false;
            contractPath.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        Ref.ObjectRef key = new Ref.ObjectRef();
        while (true) {
            void restartNeeded;
            WatchKey $i$f$forEach22 = watchService.take();
            boolean bl = false;
            boolean bl2 = false;
            WatchKey it = $i$f$forEach22;
            boolean bl3 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            key.element = key.element;
            if ($i$f$forEach22 == null) break;
            ((WatchKey)key.element).reset();
            Pair<Boolean, String> pair = this.isRestartNeeded((WatchKey)key.element);
            $i$f$forEach22 = (Boolean)pair.component1();
            String changedFile = (String)pair.component2();
            if (restartNeeded == false) continue;
            LogUtilsKt.consoleLog((String)("Restarting stub server. Change in " + changedFile));
            this.restartServer();
        }
    }

    private final Pair<Boolean, String> isRestartNeeded(WatchKey key) {
        List<WatchEvent<?>> list = key.pollEvents();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"key.pollEvents()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WatchEvent event = (WatchEvent)element$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)event.context().toString(), (String)".json", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)event.context().toString(), (String)".qontract", (boolean)false, (int)2, null)) continue;
            return new Pair((Object)true, (Object)event.context().toString());
        }
        return new Pair((Object)false, (Object)"");
    }

    /*
     * WARNING - void declaration
     */
    private final void startServer() {
        boolean bl;
        List validationResults2;
        List kafkaExpectations;
        List behaviours;
        block23: {
            ContractStub contractStub;
            Iterable iterable;
            KafkaStubData it;
            Iterable $this$map$iv;
            Object object;
            Object object2;
            Iterable $this$mapTo$iv$iv;
            List list;
            Collection collection = this.dataDirs;
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                List<String> list2 = this.contractPaths;
                if (list2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"contractPaths");
                }
                list = API.loadContractStubsFromFiles(list2, this.dataDirs);
            } else {
                List<String> list3 = this.contractPaths;
                if (list3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"contractPaths");
                }
                list = API.loadContractStubsFromImplicitPaths(list3);
            }
            List stubs = list;
            Iterable $this$map$iv2 = stubs;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterator it2;
                Pair pair = (Pair)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl3 = false;
                object = (Feature)it2.getFirst();
                object2.add(object);
            }
            behaviours = (List)destination$iv$iv;
            Object object3 = this;
            if (this.hasHttpScenarios(behaviours)) {
                void $this$mapTo$iv$iv22;
                List httpExpectations = HttpStubKt.contractInfoToHttpExpectations((List)stubs);
                $this$mapTo$iv$iv = behaviours;
                object2 = object3;
                boolean $i$f$map22 = false;
                Iterable $i$f$mapTo2 = $this$map$iv;
                Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv22) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Feature feature = (Feature)item$iv$iv;
                    object = destination$iv$iv22;
                    boolean bl4 = false;
                    iterable = it.getScenarios();
                    KafkaStubData kafkaStubData = it;
                    boolean $i$f$filter = false;
                    void var17_39 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Scenario scenario = (Scenario)element$iv$iv;
                        boolean bl5 = false;
                        if (!(scenario.getKafkaMessagePattern() == null)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    List list4 = (List)destination$iv$iv3;
                    Feature feature2 = Feature.copy$default((Feature)kafkaStubData, (List)list4, null, null, (int)6, null);
                    object.add(feature2);
                }
                object = (List)destination$iv$iv22;
                Object httpBehaviours = object;
                KeyStoreData keyStoreData = ProxyCommandKt.getHttpsCert(this.keyStoreFile, this.keyStoreDir, this.keyStorePassword, this.keyStoreAlias, this.keyPassword);
                String string = this.host;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                }
                HttpStub $i$f$map22 = new HttpStub((List)httpBehaviours, httpExpectations, string, this.port, (Function1)startServer.1.INSTANCE, this.strictMode, keyStoreData);
                boolean $this$mapTo$iv$iv22 = false;
                boolean destination$iv$iv22 = false;
                HttpStub it3 = $i$f$map22;
                boolean bl6 = false;
                String protocol = keyStoreData != null ? "https" : "http";
                StringBuilder stringBuilder = new StringBuilder().append("Stub server is running on ").append(protocol).append("://");
                String string2 = this.host;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                }
                LogUtilsKt.consoleLog((String)stringBuilder.append(string2).append(':').append(this.port).append(". Ctrl + C to stop.").toString());
                object = $i$f$map22;
                object3 = object2;
                contractStub = (ContractStub)object;
            } else {
                contractStub = null;
            }
            ((StubCommand)object3).contractFake = contractStub;
            kafkaExpectations = KafkaStubKt.contractInfoToKafkaExpectations((List)stubs);
            $this$map$iv = kafkaExpectations;
            boolean $i$f$map2 = false;
            Iterable $this$mapTo$iv$iv22 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv22) {
                Result result;
                Object v8;
                block22: {
                    void stubData;
                    it = (KafkaStubData)item$iv$iv;
                    object2 = destination$iv$iv4;
                    boolean bl7 = false;
                    iterable = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)behaviours), (Function1)((Function1)new Function1<Feature, Result>((KafkaStubData)stubData){
                        final /* synthetic */ KafkaStubData $stubData;

                        @NotNull
                        public final Result invoke(@NotNull Feature it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return it.matchesMockKafkaMessage(this.$stubData.getKafkaMessage());
                        }
                        {
                            this.$stubData = kafkaStubData;
                            super(1);
                        }
                    }));
                    boolean bl8 = false;
                    Iterable iterable3 = iterable;
                    boolean bl9 = false;
                    for (Object e : iterable3) {
                        Result it4 = (Result)e;
                        boolean bl10 = false;
                        if (!(it4 instanceof Result.Failure)) continue;
                        v8 = e;
                        break block22;
                    }
                    v8 = null;
                }
                if ((result = (Result)v8) == null) {
                    result = (Result)new Result.Success();
                }
                object = result;
                object2.add(object);
            }
            validationResults2 = (List)destination$iv$iv4;
            Iterable $this$any$iv = validationResults2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Result it5 = (Result)element$iv;
                    boolean bl11 = false;
                    if (!(it5 instanceof Result.Failure)) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        if (bl) {
            Results results = new Results(CollectionsKt.toMutableList((Collection)validationResults2));
            LogUtilsKt.consoleLog((String)("Can't load Kafka mocks:\n" + Results.report$default((Results)results, null, (int)1, null)));
        } else if (this.hasKafkaScenarios(behaviours)) {
            Object object;
            if (this.startKafka) {
                this.qontractKafka = new QontractKafka(this.kafkaPort);
                QontractKafka qontractKafka = this.qontractKafka;
                LogUtilsKt.consoleLog((String)("Started local Kafka server: " + (qontractKafka != null ? qontractKafka.getBootstrapServers() : null)));
            }
            if ((object = this.qontractKafka) == null || (object = object.getBootstrapServers()) == null) {
                object = "PLAINTEXT://" + this.kafkaHost + ':' + this.kafkaPort;
            }
            KafkaStubKt.stubKafkaContracts((List)kafkaExpectations, (String)object, (Function2)startServer.4.INSTANCE, (Function1)startServer.5.INSTANCE);
        }
        LogTail.INSTANCE.storeSnapshot();
    }

    private final boolean hasKafkaScenarios(List<Feature> behaviours) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = behaviours;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        Feature it = (Feature)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = it.getScenarios();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                Scenario scenario = (Scenario)element$iv2;
                                boolean bl4 = false;
                                if (!(scenario.getKafkaMessagePattern() != null)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasHttpScenarios(List<Feature> behaviours) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = behaviours;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        Feature it = (Feature)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = it.getScenarios();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                Scenario scenario = (Scenario)element$iv2;
                                boolean bl4 = false;
                                if (!(scenario.getKafkaMessagePattern() == null)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void restartServer() {
        LogUtilsKt.consoleLog((String)"Stopping servers...");
        try {
            this.stopServer();
            LogUtilsKt.consoleLog((String)"Stopped.");
        }
        catch (Throwable e) {
            LogUtilsKt.consoleLog((String)("Error stopping server: " + e.getLocalizedMessage()));
        }
        try {
            this.startServer();
        }
        catch (Throwable e) {
            LogUtilsKt.consoleLog((String)("Error starting server: " + e.getLocalizedMessage()));
        }
    }

    private final void stopServer() {
        ContractStub contractStub = this.contractFake;
        if (contractStub != null) {
            contractStub.close();
        }
        this.contractFake = null;
        QontractKafka qontractKafka = this.qontractKafka;
        if (qontractKafka != null) {
            qontractKafka.close();
        }
        this.qontractKafka = null;
    }

    private final void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            final /* synthetic */ StubCommand this$0;

            public void run() {
                try {
                    LogUtilsKt.consoleLog((String)"Shutting down stub servers");
                    ContractStub contractStub = this.this$0.getContractFake();
                    if (contractStub != null) {
                        contractStub.close();
                    }
                    QontractKafka qontractKafka = this.this$0.getQontractKafka();
                    if (qontractKafka != null) {
                        qontractKafka.close();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public StubCommand() {
        List list;
        StubCommand stubCommand = this;
        boolean bl = false;
        stubCommand.dataDirs = list = (List)new ArrayList();
        this.kafkaHost = "127.0.0.1";
        this.kafkaPort = 9093;
        this.keyStoreFile = "";
        this.keyStoreDir = "";
        this.keyStorePassword = "forgotten";
        this.keyStoreAlias = "qontractproxy";
        this.keyPassword = "forgotten";
    }
}

