/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.SamplesCommandKt;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;
import run.qontract.core.pattern.ContractException;

@CommandLine.Command(name="samples", mixinStandardHelpOptions=true, description={"Generate samples of the API requests and responses for all scenarios"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lapplication/SamplesCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "host", "", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "port", "", "getPort", "()I", "setPort", "(I)V", "qontractFile", "Ljava/io/File;", "getQontractFile", "()Ljava/io/File;", "setQontractFile", "(Ljava/io/File;)V", "call", "application"})
public final class SamplesCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"Contract file path"})
    @NotNull
    public File qontractFile;
    @CommandLine.Option(names={"--host"}, description={"The host to bind to, e.g. localhost or some locally bound IP"}, defaultValue="localhost")
    @NotNull
    private String host = "127.0.0.1";
    @CommandLine.Option(names={"--port"}, description={"The port to bind to"}, defaultValue="9000")
    private int port = 9000;

    @NotNull
    public final File getQontractFile() {
        File file = this.qontractFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"qontractFile");
        }
        return file;
    }

    public final void setQontractFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.qontractFile = file;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @Override
    public void call() {
        try {
            File file = this.qontractFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"qontractFile");
            }
            SamplesCommandKt.samples(file, this.host, this.port);
        }
        catch (ContractException e) {
            String string = e.report();
            boolean bl = false;
            System.out.println((Object)string);
        }
        catch (Throwable exception) {
            String indent = "  ";
            Object[] objectArray = new String[3];
            objectArray[0] = "Exception";
            objectArray[1] = StringsKt.prependIndent((String)("Class=" + exception.getClass().getName()), (String)indent);
            String string = exception.getMessage();
            objectArray[2] = string != null ? StringsKt.prependIndent((String)string, (String)indent) : null;
            String message = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            boolean bl = false;
            System.out.println((Object)message);
        }
    }
}

