/*
 * Decompiled with CFR 0.152.
 */
package application;

import io.ktor.network.tls.certificates.CertificatesKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import run.qontract.core.KeyStoreData;
import run.qontract.core.utilities.Utilities;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a0\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a8\u0006\f"}, d2={"createKeyStore", "Lrun/qontract/core/KeyStoreData;", "keyStoreDirPath", "", "keyStorePassword", "keyAlias", "keyPassword", "getHttpsCert", "keyStoreFile", "keyStoreDir", "loadKeyStoreFromFile", "Ljava/security/KeyStore;", "application"})
public final class ProxyCommandKt {
    @Nullable
    public static final KeyStoreData getHttpsCert(@NotNull String keyStoreFile, @NotNull String keyStoreDir, @NotNull String keyStorePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)keyStoreFile, (String)"keyStoreFile");
        Intrinsics.checkParameterIsNotNull((Object)keyStoreDir, (String)"keyStoreDir");
        Intrinsics.checkParameterIsNotNull((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkParameterIsNotNull((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkParameterIsNotNull((Object)keyPassword, (String)"keyPassword");
        CharSequence charSequence = keyStoreFile;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            object = new KeyStoreData(ProxyCommandKt.loadKeyStoreFromFile(keyStoreFile, keyStorePassword), keyStorePassword, keyAlias, keyPassword);
        } else {
            charSequence = keyStoreDir;
            bl = false;
            object = !StringsKt.isBlank((CharSequence)charSequence) ? ProxyCommandKt.createKeyStore(keyStoreDir, keyStorePassword, keyAlias, keyPassword) : null;
        }
        return object;
    }

    private static final KeyStoreData createKeyStore(String keyStoreDirPath, String keyStorePassword, String keyAlias, String keyPassword) {
        String filename;
        File keyStoreFile;
        File keyStoreDir = new File(keyStoreDirPath);
        if (!keyStoreDir.exists()) {
            keyStoreDir.mkdirs();
        }
        if ((keyStoreFile = FilesKt.resolve((File)keyStoreDir, (String)(filename = "qontract.jks"))).exists()) {
            keyStoreFile.delete();
        }
        int n = 0;
        String string = keyPassword;
        String string2 = keyAlias;
        String string3 = keyStorePassword;
        KeyStore keyStore = CertificatesKt.generateCertificate$default((File)keyStoreFile, null, (String)string2, (String)string, (String)string3, (int)n, (int)34, null);
        return new KeyStoreData(keyStore, keyStorePassword, keyAlias, keyPassword);
    }

    private static final KeyStore loadKeyStoreFromFile(String keyStoreFile, String keyStorePassword) {
        String string;
        File certFilePath = new File(keyStoreFile);
        Object object = FilesKt.getExtension((File)certFilePath);
        boolean bl = false;
        String string2 = object;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "jks": {
                string = "JKS";
                break;
            }
            case "pfx": {
                string = "PKCS12";
                break;
            }
            default: {
                Void void_ = Utilities.exitWithMessage((String)"The certificate file must be either in Java Key Store or PKCS12 format");
                throw null;
            }
        }
        String keyStoreType = string;
        object = KeyStore.getInstance(keyStoreType);
        bl = false;
        boolean bl2 = false;
        Object $this$apply = object;
        boolean bl3 = false;
        Object object2 = certFilePath;
        Object object3 = $this$apply;
        boolean bl4 = false;
        InputStream inputStream = new FileInputStream((File)object2);
        object2 = keyStorePassword;
        inputStream = inputStream;
        bl4 = false;
        Object object4 = object2;
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = ((String)object4).toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        ((KeyStore)object3).load(inputStream, cArray2);
        Object object5 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"KeyStore.getInstance(key\u2026word.toCharArray())\n    }");
        return object5;
    }
}

