/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.ProxyCommandKt;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import run.qontract.LogUtilsKt;
import run.qontract.core.KeyStoreData;
import run.qontract.core.utilities.Utilities;
import run.qontract.proxy.Proxy;

@CommandLine.Command(name="proxy", mixinStandardHelpOptions=true, description={"Proxies requests to the specified target and converts the result into contracts and stubs"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010+\u001a\u00020\u0002H\u0002J\b\u0010,\u001a\u00020\u0002H\u0016J\u001c\u0010-\u001a\u00020\u00022\b\u0010.\u001a\u0004\u0018\u00010\u00052\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001e\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001e\u0010\u0010\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001e\u0010\u0013\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001e\u0010\u0016\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001e\u0010\u0019\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0007\"\u0004\b'\u0010\tR\u001e\u0010(\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0007\"\u0004\b*\u0010\t\u00a8\u0006/"}, d2={"Lapplication/ProxyCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "host", "", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "keyPassword", "getKeyPassword", "setKeyPassword", "keyStoreAlias", "getKeyStoreAlias", "setKeyStoreAlias", "keyStoreDir", "getKeyStoreDir", "setKeyStoreDir", "keyStoreFile", "getKeyStoreFile", "setKeyStoreFile", "keyStorePassword", "getKeyStorePassword", "setKeyStorePassword", "port", "", "getPort", "()I", "setPort", "(I)V", "proxy", "Lrun/qontract/proxy/Proxy;", "getProxy", "()Lrun/qontract/proxy/Proxy;", "setProxy", "(Lrun/qontract/proxy/Proxy;)V", "proxyQontractDataDir", "getProxyQontractDataDir", "setProxyQontractDataDir", "targetBaseURL", "getTargetBaseURL", "setTargetBaseURL", "addShutdownHook", "call", "validatedProxySettings", "unknownProxyTarget", "application"})
public final class ProxyCommand
implements Callable<Unit> {
    @CommandLine.Option(names={"--target"}, description={"Base URL of the target to be proxied to"})
    @NotNull
    private String targetBaseURL = "";
    @CommandLine.Option(names={"--host"}, description={"Host for the proxy"}, defaultValue="localhost")
    @NotNull
    public String host;
    @CommandLine.Option(names={"--port"}, description={"Port for the proxy"}, defaultValue="9000")
    private int port = 9000;
    @CommandLine.Option(names={"--httpsKeyStore"}, description={"EXPERIMENTAL: Run the proxy on https using a key in this store"})
    @NotNull
    private String keyStoreFile = "";
    @CommandLine.Option(names={"--httpsKeyStoreDir"}, description={"EXPERIMENTAL: Run the proxy on https, create a store named qontract.jks in this directory"})
    @NotNull
    private String keyStoreDir = "";
    @CommandLine.Option(names={"--httpsKeyStorePassword"}, description={"EXPERIMENTAL: Run the proxy on https, password for pre-existing key store"})
    @NotNull
    private String keyStorePassword = "forgotten";
    @CommandLine.Option(names={"--httpsKeyAlias"}, description={"EXPERIMENTAL: Run the proxy on https using a key by this name"})
    @NotNull
    private String keyStoreAlias = "qontractproxy";
    @CommandLine.Option(names={"--httpsPassword"}, description={"EXPERIMENTAL: Key password if any"})
    @NotNull
    private String keyPassword = "forgotten";
    @CommandLine.Parameters(description={"Store data from the proxy interactions into this dir"}, index="0")
    @NotNull
    public String proxyQontractDataDir;
    @Nullable
    private Proxy proxy;

    @NotNull
    public final String getTargetBaseURL() {
        return this.targetBaseURL;
    }

    public final void setTargetBaseURL(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.targetBaseURL = string;
    }

    @NotNull
    public final String getHost() {
        String string = this.host;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        }
        return string;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public final void setKeyStoreFile(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keyStoreFile = string;
    }

    @NotNull
    public final String getKeyStoreDir() {
        return this.keyStoreDir;
    }

    public final void setKeyStoreDir(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keyStoreDir = string;
    }

    @NotNull
    public final String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public final void setKeyStorePassword(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keyStorePassword = string;
    }

    @NotNull
    public final String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public final void setKeyStoreAlias(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keyStoreAlias = string;
    }

    @NotNull
    public final String getKeyPassword() {
        return this.keyPassword;
    }

    public final void setKeyPassword(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keyPassword = string;
    }

    @NotNull
    public final String getProxyQontractDataDir() {
        String string = this.proxyQontractDataDir;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"proxyQontractDataDir");
        }
        return string;
    }

    public final void setProxyQontractDataDir(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.proxyQontractDataDir = string;
    }

    @Nullable
    public final Proxy getProxy() {
        return this.proxy;
    }

    public final void setProxy(@Nullable Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void call() {
        String string = this.proxyQontractDataDir;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"proxyQontractDataDir");
        }
        this.validatedProxySettings(this.targetBaseURL, string);
        KeyStoreData keyStoreData = ProxyCommandKt.getHttpsCert(this.keyStoreFile, this.keyStoreDir, this.keyStorePassword, this.keyStoreAlias, this.keyPassword);
        String string2 = this.host;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        }
        String string3 = this.proxyQontractDataDir;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"proxyQontractDataDir");
        }
        this.proxy = new Proxy(string2, this.port, this.targetBaseURL, string3, keyStoreData);
        this.addShutdownHook();
        String protocol = keyStoreData != null ? "https" : "http";
        StringBuilder stringBuilder = new StringBuilder().append("Proxy server is running on ").append(protocol).append("://");
        String string4 = this.host;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        }
        LogUtilsKt.consoleLog((String)stringBuilder.append(string4).append(':').append(this.port).append(". Ctrl + C to stop.").toString());
        while (true) {
            Thread.sleep(10000L);
        }
    }

    private final void validatedProxySettings(String unknownProxyTarget, String proxyQontractDataDir) {
        if (unknownProxyTarget == null && proxyQontractDataDir == null) {
            return;
        }
        if (unknownProxyTarget != null && proxyQontractDataDir != null) {
            File dataDirFile = new File(proxyQontractDataDir);
            if (!dataDirFile.exists()) {
                try {
                    dataDirFile.mkdirs();
                }
                catch (Throwable e) {
                    Void void_ = Utilities.exitWithMessage((String)Utilities.exceptionCauseMessage((Throwable)e));
                    throw null;
                }
            }
            File[] fileArray = dataDirFile.listFiles();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                boolean bl = false;
                File[] fileArray3 = fileArray2;
                boolean bl2 = false;
                if (!(fileArray3.length == 0)) {
                    Void void_ = Utilities.exitWithMessage((String)("This data directory " + proxyQontractDataDir + " must be empty if it exists"));
                    throw null;
                }
            }
        }
    }

    private final void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            final /* synthetic */ ProxyCommand this$0;

            public void run() {
                try {
                    String string = "Shutting down stub servers";
                    boolean bl = false;
                    System.out.println((Object)string);
                    Proxy proxy = this.this$0.getProxy();
                    if (proxy != null) {
                        proxy.close();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }
}

