/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.ImportCommandKt;
import application.versioning.commands.RepoCommand;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import run.qontract.conversions.BaseURLInfo;
import run.qontract.conversions.ImportedPostmanContracts;
import run.qontract.conversions.PostmanKt;
import run.qontract.core.FeatureKt;
import run.qontract.core.NamedStub;
import run.qontract.core.utilities.JSONSerialisationKt;
import run.qontract.mock.ScenarioStub;
import run.qontract.mock.ScenarioStubKt;

@CommandLine.Command(name="import", mixinStandardHelpOptions=true, description={"Converts a files of various formats into their respective Qontract equivalents"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016J\u001e\u0010\u0005\u001a\u00020\u00022\b\b\u0001\u0010\u0006\u001a\u00020\u00072\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007J\u001e\u0010\t\u001a\u00020\u00022\b\b\u0001\u0010\u0006\u001a\u00020\u00072\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007J*\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lapplication/ImportCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "call", "postman", "path", "", "outputFile", "stub", "writeOut", "gherkin", "inputFile", "Ljava/io/File;", "hostAndPort", "application"})
public final class ImportCommand
implements Callable<Unit> {
    @CommandLine.Command(name="stub")
    public final void stub(@CommandLine.Parameters(description={"Converts a stub json file to a Qontract file"}, index="0") @NotNull String path, @CommandLine.Option(names={"-o", "--output"}, description={"Write the contract into this file"}, required=false) @Nullable String outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File inputFile = new File(path);
        ScenarioStub stub = ScenarioStubKt.mockFromJSON((Map)JSONSerialisationKt.jsonStringToValueMap((String)FilesKt.readText$default((File)inputFile, null, (int)1, null)));
        String gherkin = FeatureKt.toGherkinFeature((NamedStub)new NamedStub("New scenario", stub));
        this.writeOut(gherkin, outputFile, inputFile, "");
    }

    /*
     * WARNING - void declaration
     */
    @CommandLine.Command(name="postman")
    public final void postman(@CommandLine.Parameters(description={"Converts a postman collection to a Qontract file"}, index="0") @NotNull String path, @CommandLine.Option(names={"-o", "--output"}, description={"Write the contract into this file"}, required=false) @Nullable String outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File inputFile = new File(path);
        List contracts = PostmanKt.postmanCollectionToGherkin((String)FilesKt.readText$default((File)inputFile, null, (int)1, null));
        for (ImportedPostmanContracts contract : contracts) {
            PostmanKt.runTests((ImportedPostmanContracts)contract);
        }
        switch (contracts.size()) {
            case 1: {
                this.writeOut(((ImportedPostmanContracts)CollectionsKt.first((List)contracts)).getGherkin(), outputFile, inputFile, PostmanKt.toFragment((BaseURLInfo)((ImportedPostmanContracts)CollectionsKt.first((List)contracts)).getBaseURLInfo()));
                break;
            }
            default: {
                Iterator iterator = contracts.iterator();
                while (iterator.hasNext()) {
                    void gherkin;
                    ImportedPostmanContracts contract;
                    ImportedPostmanContracts importedPostmanContracts = contract = (ImportedPostmanContracts)iterator.next();
                    String string = importedPostmanContracts.component2();
                    BaseURLInfo baseURLInfo = importedPostmanContracts.component3();
                    this.writeOut((String)gherkin, outputFile, inputFile, PostmanKt.toFragment((BaseURLInfo)baseURLInfo));
                }
                break block0;
            }
        }
    }

    private final void writeOut(String gherkin, String outputFile, File inputFile, String hostAndPort) {
        String string = outputFile;
        if (string == null) {
            boolean bl = false;
            System.out.println((Object)gherkin);
        } else {
            File file = new File(outputFile);
            boolean bl = false;
            boolean bl2 = false;
            File it = file;
            boolean bl3 = false;
            CharSequence charSequence = hostAndPort;
            boolean bl4 = false;
            String tag = charSequence.length() > 0 ? '-' + StringsKt.replace$default((String)hostAndPort, (String)":", (String)"-", (boolean)false, (int)4, null) : "";
            if (it.isDirectory()) {
                File file2 = it.getAbsoluteFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.absoluteFile");
                File file3 = file2.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"it.absoluteFile.parentFile");
                String string2 = file3.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.absoluteFile.parentFile.path");
                String string3 = File.separator;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.separator");
                String dir = StringsKt.removeSuffix((String)string2, (CharSequence)string3);
                String name = FilesKt.getNameWithoutExtension((File)inputFile);
                String extension = "qontract";
                String outputPath = dir + File.separator + name + '.' + extension;
                File withTag = ImportCommandKt.access$fileWithTag(new File(outputPath), tag);
                FilesKt.writeText$default((File)withTag, (String)gherkin, null, (int)2, null);
                String string4 = "Written to file " + withTag.getPath();
                boolean bl5 = false;
                System.out.println((Object)string4);
            } else {
                FilesKt.writeText$default((File)ImportCommandKt.access$fileWithTag(it, tag), (String)gherkin, null, (int)2, null);
                charSequence = "Written to file " + ImportCommandKt.access$fileWithTag(it, tag).getPath();
                bl4 = false;
                System.out.println(charSequence);
            }
        }
    }

    @Override
    public void call() {
        new CommandLine((Object)new RepoCommand()).usage(System.out);
    }
}

