/*
 * Decompiled with CFR 0.152.
 */
package application;

import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;
import run.qontract.core.Feature;
import run.qontract.core.FeatureKt;
import run.qontract.core.Results;
import run.qontract.core.TestBackwardCompatibilityKt;

@CommandLine.Command(name="backwardCompatible", mixinStandardHelpOptions=true, description={"Checks if the newer contract is backward compatible with the older one"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u000e"}, d2={"Lapplication/BackwardCompatibleCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "newerContractPath", "", "getNewerContractPath", "()Ljava/lang/String;", "setNewerContractPath", "(Ljava/lang/String;)V", "olderContractPath", "getOlderContractPath", "setOlderContractPath", "call", "application"})
public final class BackwardCompatibleCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"Older contract path"})
    @NotNull
    public String olderContractPath;
    @CommandLine.Parameters(index="1", description={"Newer contract path"})
    @NotNull
    public String newerContractPath;

    @NotNull
    public final String getOlderContractPath() {
        String string = this.olderContractPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"olderContractPath");
        }
        return string;
    }

    public final void setOlderContractPath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.olderContractPath = string;
    }

    @NotNull
    public final String getNewerContractPath() {
        String string = this.newerContractPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"newerContractPath");
        }
        return string;
    }

    public final void setNewerContractPath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.newerContractPath = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void call() {
        void resultExitCode;
        String string = this.olderContractPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"olderContractPath");
        }
        Feature olderFeature = FeatureKt.Feature((String)FilesKt.readText$default((File)new File(string), null, (int)1, null));
        String string2 = this.newerContractPath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"newerContractPath");
        }
        Feature newerFeature = FeatureKt.Feature((String)FilesKt.readText$default((File)new File(string2), null, (int)1, null));
        Results results = TestBackwardCompatibilityKt.testBackwardCompatibility2((Feature)olderFeature, (Feature)newerFeature);
        Pair pair = results.success() ? new Pair((Object)0, (Object)"The newer is backward compatible with the older.") : new Pair((Object)1, (Object)"The newer is NOT backward compatible with the older.");
        int n = ((Number)pair.component1()).intValue();
        String resultMessage = (String)pair.component2();
        String countsMessage = "Tests run: " + (results.getSuccessCount() + results.getFailureCount()) + ", Passed: " + results.getSuccessCount() + ", Failed: " + results.getFailureCount() + "\n\n";
        String string3 = Results.report$default((Results)results, null, (int)1, null);
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string3 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        bl = false;
        boolean bl2 = false;
        String it = string3;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String resultReport = charSequence.length() > 0 ? it + "\n\n" : it;
        string3 = countsMessage + resultReport + resultMessage;
        bl = false;
        String string5 = string3;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string3 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
        bl = false;
        System.out.println((Object)string3);
        boolean bl5 = false;
        System.exit((int)resultExitCode);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

