/*
 * Decompiled with CFR 0.152.
 */
package run.mydata.manager;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.mydata.annotation.TransactionalOption;
import run.mydata.manager.IConnectionManager;

@Aspect
public class TransManagerDefault {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private IConnectionManager connectionManager;

    @Around(value="@annotation(org.springframework.transaction.annotation.Transactional)")
    public Object transactional(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        TransactionalOption option = method.getAnnotation(TransactionalOption.class);
        if (option != null && option.connectionManagerNames().length != 0) {
            boolean contains = Arrays.asList(option.connectionManagerNames()).contains(this.connectionManager.getConnectionManagerName());
            try {
                if (contains) {
                    log.debug("begin transaction  {}", (Object)Thread.currentThread().getName());
                    Boolean b = this.connectionManager.beginTransaction(false);
                    Object rz = pjp.proceed();
                    if (b.booleanValue()) {
                        log.debug("commit transaction  {}", (Object)Thread.currentThread().getName());
                        this.connectionManager.commitTransaction();
                    }
                    return rz;
                }
                return pjp.proceed();
            }
            catch (Throwable e) {
                if (contains) {
                    log.debug("rollback transaction  {}", (Object)Thread.currentThread().getName());
                    this.connectionManager.rollbackTransaction();
                }
                throw e;
            }
        }
        try {
            log.debug("begin transaction  {}", (Object)Thread.currentThread().getName());
            Boolean b = this.connectionManager.beginTransaction(false);
            Object rz = pjp.proceed();
            if (b.booleanValue()) {
                log.debug("commit transaction  {}", (Object)Thread.currentThread().getName());
                this.connectionManager.commitTransaction();
            }
            return rz;
        }
        catch (Throwable e) {
            log.debug("rollback transaction  {}", (Object)Thread.currentThread().getName());
            this.connectionManager.rollbackTransaction();
            throw e;
        }
    }

    public void setConnectionManager(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }
}

