/*
 * Decompiled with CFR 0.152.
 */
package run.mydata.manager;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.mydata.annotation.ColumnComment;
import run.mydata.annotation.ColumnRule;
import run.mydata.annotation.MyIndex;
import run.mydata.helper.PropInfo;
import run.mydata.manager.IConnectionManager;
import run.mydata.manager.TransactionLocal;

public final class ConnectionManager
implements IConnectionManager {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean showSql = false;
    private boolean ddl = true;
    private String connectStr = "set  names  utf8";
    private String db;
    private DataSource dataSource;
    private List<DataSource> readDataSources;
    private String connectionManagerName;
    private static volatile ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, LinkedHashSet<PropInfo>>> ENTITY_CACHED = new ConcurrentHashMap();
    private static ThreadLocal<Map<ConnectionManager, TransactionLocal>> transactions = new ThreadLocal(){};
    private static ThreadLocal<Map<ConnectionManager, Map<DataSource, Connection>>> connections = new ThreadLocal(){};
    private static final ThreadLocal<Map<DataSource, Connection>> readOnlyConnections = new ThreadLocal<Map<DataSource, Connection>>(){

        @Override
        protected Map<DataSource, Connection> initialValue() {
            return new HashMap<DataSource, Connection>(3);
        }
    };

    private ThreadLocal<Map<ConnectionManager, TransactionLocal>> getTransactions() {
        Map<ConnectionManager, TransactionLocal> ctMap = transactions.get();
        if (ctMap == null) {
            ctMap = new HashMap<ConnectionManager, TransactionLocal>();
            ctMap.put(this, new TransactionLocal(false, false, this));
            transactions.set(ctMap);
        } else {
            TransactionLocal tl = ctMap.get(this);
            if (tl == null) {
                ctMap.put(this, new TransactionLocal(false, false, this));
                transactions.set(ctMap);
            }
        }
        return transactions;
    }

    private ThreadLocal<Map<ConnectionManager, Map<DataSource, Connection>>> getConnections() {
        Map<ConnectionManager, Map<DataSource, Connection>> cdcMap = connections.get();
        if (cdcMap == null) {
            cdcMap = new HashMap<ConnectionManager, Map<DataSource, Connection>>();
            HashMap dcMap = new HashMap();
            cdcMap.put(this, dcMap);
            connections.set(cdcMap);
        } else {
            Map<DataSource, Connection> dcMap = cdcMap.get(this);
            if (dcMap == null) {
                dcMap = new HashMap<DataSource, Connection>();
                cdcMap.put(this, dcMap);
                connections.set(cdcMap);
            }
        }
        return connections;
    }

    public ConnectionManager() {
    }

    public ConnectionManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setReadDataSources(List<DataSource> readDataSources) {
        this.readDataSources = readDataSources;
    }

    public String getConnectStr() {
        return this.connectStr;
    }

    public void setConnectStr(String connectStr) {
        this.connectStr = connectStr;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public void setDdl(boolean ddl) {
        this.ddl = ddl;
    }

    private void setReadOnlyConnection(Connection conn) {
        try {
            log.debug("slave connection open  {}", (Object)Thread.currentThread().getName());
            readOnlyConnections.get().put(this.dataSource, conn);
            this.initConnect(readOnlyConnections.get().get(this.dataSource));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    private void initConnect(Connection conn) throws SQLException {
        if (this.connectStr != null && this.connectStr.length() > 0) {
            conn.prepareStatement(this.connectStr).execute();
        }
    }

    private void closeReadconnection() {
        Connection connection = readOnlyConnections.get().get(this.dataSource);
        if (connection != null) {
            try {
                log.debug("slave connection close  {}", (Object)Thread.currentThread().getName());
                readOnlyConnections.remove();
                connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, LinkedHashSet<PropInfo>> getTbinfo(Class<?> domainClass) {
        ConcurrentHashMap<String, LinkedHashSet<PropInfo>> tableNamePropsMap = ENTITY_CACHED.get(domainClass);
        if (tableNamePropsMap == null) {
            Table tableAnnotation = domainClass.getAnnotation(Table.class);
            LinkedHashSet<PropInfo> tableColumnInfos = new LinkedHashSet<PropInfo>();
            String tableName = null;
            if (tableAnnotation != null && "".equals(tableName = tableAnnotation.name().trim())) {
                tableName = domainClass.getSimpleName();
            }
            Field[] fields = domainClass.getDeclaredFields();
            int versionNum = 0;
            for (Field field : fields) {
                ColumnComment fieldColumnCommentAnnotation;
                if (field.isAnnotationPresent(Transient.class) || Modifier.isTransient(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                PropInfo info = new PropInfo();
                info.setPname(field.getName());
                info.setType(field.getType());
                if (field.isAnnotationPresent(ColumnComment.class) && (fieldColumnCommentAnnotation = field.getAnnotation(ColumnComment.class)).value() != null && !"".equals(fieldColumnCommentAnnotation.value())) {
                    info.setComment(fieldColumnCommentAnnotation.value());
                }
                if (field.isAnnotationPresent(Column.class)) {
                    Column fieldColumnAnnotation = field.getAnnotation(Column.class);
                    String columnName = fieldColumnAnnotation.name();
                    if (columnName != null && !columnName.equals("")) {
                        info.setCname(columnName);
                    } else {
                        info.setCname(field.getName());
                    }
                    if (field.getType() == String.class || field.getType().isEnum()) {
                        info.setLength(fieldColumnAnnotation.length());
                    }
                    if (!fieldColumnAnnotation.nullable()) {
                        info.setIsNotNull(true);
                    }
                    if (fieldColumnAnnotation.unique()) {
                        info.setIsUnique(true);
                    }
                    if (info.getComment() == null && fieldColumnAnnotation.columnDefinition() != null && !"".equals(fieldColumnAnnotation.columnDefinition())) {
                        info.setComment(fieldColumnAnnotation.columnDefinition());
                    }
                } else {
                    info.setCname(field.getName());
                }
                if (field.isAnnotationPresent(Id.class)) {
                    info.setIsPrimarykey(true);
                    if (field.isAnnotationPresent(GeneratedValue.class)) {
                        GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                        info.setGeneratorValueAnnoStrategyVal(generatedValue.strategy());
                        info.setGeneratorValueAnnoGeneratorVal(generatedValue.generator());
                    }
                }
                if (field.isAnnotationPresent(ColumnRule.class)) {
                    info.setColumnRule(field.getAnnotation(ColumnRule.class));
                }
                if (field.isAnnotationPresent(MyIndex.class) && !info.getIsUnique().booleanValue()) {
                    info.setIndex(field.getAnnotation(MyIndex.class));
                }
                if (field.isAnnotationPresent(Lob.class)) {
                    info.setIsLob(true);
                }
                if (field.getType().isEnum()) {
                    if (field.isAnnotationPresent(Enumerated.class)) {
                        info.setEnumType(field.getAnnotation(Enumerated.class).value());
                    } else {
                        info.setEnumType(EnumType.ORDINAL);
                    }
                }
                if (field.isAnnotationPresent(Version.class)) {
                    info.setVersion(true);
                    ++versionNum;
                    if (!field.getType().equals(Long.class)) {
                        String error = domainClass.getName() + " @Version Type Must Be Long ";
                        throw new IllegalArgumentException(error);
                    }
                }
                tableColumnInfos.add(info);
            }
            if (versionNum > 1) {
                String error = domainClass.getName() + " @Version Type Has To Be Only 1 But Current Has " + versionNum;
                throw new IllegalArgumentException(error);
            }
            tableNamePropsMap = new ConcurrentHashMap();
            tableNamePropsMap.put(tableName, tableColumnInfos);
            ENTITY_CACHED.put(domainClass, tableNamePropsMap);
        }
        return tableNamePropsMap;
    }

    @Override
    public Connection getConnection() {
        return this.getWriteConnection();
    }

    @Override
    public Connection getConnection(boolean readOnly) {
        if (readOnly) {
            return this.getReadConnection();
        }
        return this.getWriteConnection();
    }

    @Override
    public Connection getWriteConnection() {
        try {
            Map<DataSource, Connection> dcMap = this.getConnections().get().get(this);
            if (dcMap == null) {
                log.debug("master connection open  {}", (Object)Thread.currentThread().getName());
                this.getConnections().get().get(this).put(this.dataSource, this.dataSource.getConnection());
                this.initConnect(this.getConnections().get().get(this).get(this.dataSource));
                return this.getConnections().get().get(this).get(this.dataSource);
            }
            Connection conn = dcMap.get(this.dataSource);
            if (conn == null) {
                log.debug("master connection open  {}", (Object)Thread.currentThread().getName());
                this.getConnections().get().get(this).put(this.dataSource, this.dataSource.getConnection());
                this.initConnect(this.getConnections().get().get(this).get(this.dataSource));
                return this.getConnections().get().get(this).get(this.dataSource);
            }
            return conn;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Connection getReadConnection() {
        try {
            Connection conn = readOnlyConnections.get().get(this.dataSource);
            if (conn == null) {
                if (this.readDataSources != null && this.readDataSources.size() > 0) {
                    this.setReadOnlyConnection(this.readDataSources.get(ThreadLocalRandom.current().nextInt(this.readDataSources.size())).getConnection());
                    return readOnlyConnections.get().get(this.dataSource);
                }
                if (this.isTransReadOnly()) {
                    this.setReadOnlyConnection(this.dataSource.getConnection());
                    return readOnlyConnections.get().get(this.dataSource);
                }
                return this.getWriteConnection();
            }
            return conn;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void closeConnection() {
        if (!this.isTransactioning()) {
            Map<ConnectionManager, Map<DataSource, Connection>> mdcMap = connections.get();
            if (mdcMap != null && mdcMap.size() > 0) {
                Map<DataSource, Connection> dcMap = mdcMap.get(this);
                if (dcMap != null && dcMap.size() > 0) {
                    Connection connection = dcMap.get(this.dataSource);
                    if (connection != null) {
                        try {
                            log.debug("master connection close  {}", (Object)Thread.currentThread().getName());
                            connection.close();
                            dcMap.remove(this.dataSource);
                            mdcMap.remove(this);
                            if (mdcMap.size() == 0) {
                                connections.remove();
                            }
                        }
                        catch (Exception e) {
                            connections.remove();
                            e.printStackTrace();
                        }
                    } else {
                        connections.remove();
                    }
                } else {
                    connections.remove();
                }
            } else {
                connections.remove();
            }
        }
        this.closeReadconnection();
    }

    @Override
    public Boolean beginTransaction(boolean readOnly) {
        if (!this.isTransactioning()) {
            try {
                this.getWriteConnection().setAutoCommit(false);
                TransactionLocal transactionLocal = this.getTransactions().get().get(this);
                transactionLocal.setBegin(true);
                transactionLocal.setReadOnly(readOnly);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
        return false;
    }

    @Override
    public boolean isTransactioning() {
        TransactionLocal transactionLocal = this.getTransactions().get().get(this);
        return transactionLocal != null && transactionLocal.getBegin() != false && this.equals(transactionLocal.getConnectionManager());
    }

    @Override
    public boolean isTransReadOnly() {
        TransactionLocal transactionLocal = this.getTransactions().get().get(this);
        return transactionLocal != null && transactionLocal.getReadOnly() != false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commitTransaction() {
        Map<ConnectionManager, Map<DataSource, Connection>> mdcMap = this.getConnections().get();
        Connection connection = mdcMap.get(this).get(this.dataSource);
        if (connection == null) return;
        if (this.isTransactioning()) {
            try {
                log.debug("master connection close  {}", (Object)Thread.currentThread().getName());
                connection.commit();
                connection.setAutoCommit(true);
                connection.close();
                mdcMap.remove(this);
                if (mdcMap.size() == 0) {
                    connections.remove();
                }
                Map<ConnectionManager, TransactionLocal> ctMap = this.getTransactions().get();
                ctMap.remove(this);
                if (ctMap.size() != 0) return;
                transactions.remove();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        } else {
            this.closeConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rollbackTransaction() {
        Connection connection;
        Map<ConnectionManager, Map<DataSource, Connection>> mdcMap = this.getConnections().get();
        Map<DataSource, Connection> dcMap = mdcMap.get(this);
        if (dcMap == null || (connection = dcMap.get(this.dataSource)) == null) return;
        if (this.isTransactioning()) {
            try {
                log.debug("master connection close  {}", (Object)Thread.currentThread().getName());
                connection.rollback();
                connection.setAutoCommit(true);
                connection.close();
                mdcMap.remove(this);
                if (mdcMap.size() == 0) {
                    connections.remove();
                }
                Map<ConnectionManager, TransactionLocal> ctMap = this.getTransactions().get();
                ctMap.remove(this);
                if (ctMap.size() != 0) return;
                transactions.remove();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        } else {
            this.closeConnection();
        }
    }

    @Override
    public boolean isDdl() {
        return this.ddl;
    }

    @Override
    public boolean isShowSql() {
        return this.showSql;
    }

    @Override
    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    @Override
    public String getConnectionManagerName() {
        return this.connectionManagerName;
    }

    public void setConnectionManagerName(String connectionManagerName) {
        this.connectionManagerName = connectionManagerName;
    }
}

