/*
 * Decompiled with CFR 0.152.
 */
package run.mydata.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import run.mydata.helper.PgIdx;

public final class PageData<T>
implements Serializable {
    private static final long serialVersionUID = 909167901620112956L;
    private Integer curPage = 1;
    private Integer pageSize = 20;
    private Long totalPage = 1L;
    private Long totalCount = 0L;
    private List<T> dataList = new ArrayList<T>();
    private PgIdx pageIndex;
    private Boolean isNext = false;
    private Boolean isPrev = false;

    public void setIsNext(Boolean isNext) {
        this.isNext = isNext;
    }

    public void setIsPrev(Boolean isPrev) {
        this.isPrev = isPrev;
    }

    public PageData(Integer curPage, Integer pageSize, long totalCount, List<T> dataList) {
        this.curPage = curPage;
        this.pageSize = pageSize;
        this.dataList = dataList;
        this.totalCount = totalCount;
        this.totalPage = (totalCount + (long)pageSize.intValue() - 1L) / (long)pageSize.intValue();
        this.pageIndex = PgIdx.getPageIndex(10L, curPage, this.totalPage);
        this.isNext = (long)this.curPage.intValue() < this.totalPage;
        this.isPrev = this.curPage > 1;
    }

    public Boolean getIsNext() {
        return this.isNext;
    }

    public PageData() {
    }

    public Boolean getIsPrev() {
        return this.isPrev;
    }

    public Integer getCurPage() {
        return this.curPage;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public PgIdx getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(PgIdx pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setCurPage(Integer curPage) {
        this.curPage = curPage;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

    public String toString() {
        return "PageData{curPage=" + this.curPage + ", pageSize=" + this.pageSize + ", totalPage=" + this.totalPage + ", totalCount=" + this.totalCount + ", dataList=" + this.dataList + ", pageIndex=" + this.pageIndex + ", isNext=" + this.isNext + ", isPrev=" + this.isPrev + '}';
    }
}

