/*
 * Decompiled with CFR 0.152.
 */
package run.mydata.helper;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public interface MyObjectUtils {
    public static <T> List<T> encapsulation(List<Object[]> os, String[] propertys, Class<T> clazz) {
        ArrayList<T> ts = new ArrayList<T>();
        if (os != null && os.size() > 0 && propertys != null && propertys.length > 0 && clazz != null && clazz != Object.class && os.get(0).length == propertys.length) {
            try {
                Field[] fds = clazz.getDeclaredFields();
                for (Object[] objs : os) {
                    T t = clazz.newInstance();
                    block3: for (int i = 0; i < propertys.length; ++i) {
                        for (Field fd : fds) {
                            if (!fd.getName().equals(propertys[i])) continue;
                            MyObjectUtils.setObjectValue(fd, objs[i], t);
                            continue block3;
                        }
                    }
                    ts.add(t);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
        }
        return ts;
    }

    public static <T> void setObjectValue(String property, Object ov, T obj) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        MyObjectUtils.setObjectValue(obj.getClass().getDeclaredField(property), ov, obj);
    }

    public static <T> void setObjectValue(Field fd, Object ov, T obj) throws IllegalArgumentException, IllegalAccessException {
        block49: {
            if (obj != null && fd != null) {
                fd.setAccessible(true);
                if (ov == null) {
                    fd.set(obj, ov);
                } else if (fd.getType().isEnum()) {
                    Class<?> cls = fd.getType();
                    if (ov instanceof Number) {
                        Enum[] ccs = (Enum[])fd.getType().getEnumConstants();
                        fd.set(obj, Enum.valueOf(cls, ccs[((Number)Number.class.cast(ov)).intValue()].name()));
                    } else if (ov instanceof String) {
                        fd.set(obj, Enum.valueOf(cls, ov.toString()));
                    } else {
                        fd.set(obj, ov);
                    }
                } else if (ov.getClass() == BigDecimal.class && fd.getType() != BigDecimal.class) {
                    BigDecimal bdov = (BigDecimal)ov;
                    if (fd.getType() == Boolean.class) {
                        if (bdov.byteValue() == 1) {
                            fd.set(obj, true);
                        } else {
                            fd.set(obj, false);
                        }
                    } else {
                        MyObjectUtils.setNumberValue(fd, obj, bdov);
                    }
                } else if (ov.getClass() == BigInteger.class && fd.getType() != BigInteger.class) {
                    BigInteger bdov = (BigInteger)ov;
                    MyObjectUtils.setNumberValue(fd, obj, bdov);
                } else if (fd.getType() == Time.class && ov.getClass() == Timestamp.class) {
                    Timestamp tmst = (Timestamp)ov;
                    fd.set(obj, new Time(tmst.getTime()));
                } else {
                    if (ov instanceof Clob) {
                        Clob clob = (Clob)ov;
                        try (Reader crd = clob.getCharacterStream();){
                            char[] cbuf = new char[(int)clob.length()];
                            crd.read(cbuf);
                            fd.set(obj, new String(cbuf));
                            break block49;
                        }
                        catch (IOException | SQLException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    if (ov instanceof Blob) {
                        Blob blob = (Blob)ov;
                        try (InputStream bstream = blob.getBinaryStream();){
                            byte[] bts = new byte[(int)blob.length()];
                            bstream.read(bts);
                            fd.set(obj, bts);
                            break block49;
                        }
                        catch (IOException | SQLException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    fd.set(obj, ov);
                }
            }
        }
    }

    public static <T> void setNumberValue(Field fd, T obj, Number bdov) {
        if (bdov != null) {
            fd.setAccessible(true);
            try {
                if (fd.getType() == Long.class) {
                    fd.set(obj, bdov.longValue());
                } else if (fd.getType() == Integer.class) {
                    fd.set(obj, bdov.intValue());
                } else if (fd.getType() == Float.class) {
                    fd.set(obj, Float.valueOf(bdov.floatValue()));
                } else if (fd.getType() == Double.class) {
                    fd.set(obj, bdov.doubleValue());
                } else if (fd.getType() == Short.class) {
                    fd.set(obj, bdov.shortValue());
                } else if (fd.getType() == BigInteger.class && bdov instanceof BigDecimal) {
                    fd.set(obj, ((BigDecimal)bdov).toBigInteger());
                } else {
                    fd.set(obj, bdov);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
    }
}

