/*
 * Decompiled with CFR 0.152.
 */
package run.mydata.helper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import javax.persistence.Table;
import run.mydata.annotation.TableCharset;
import run.mydata.annotation.TableComment;
import run.mydata.annotation.TableEngine;
import run.mydata.manager.IConnectionManager;

public class MyDataHelper<Pojo> {
    public static Class getDomainClassByDaoClass(Class<?> daoClass) {
        Type type = daoClass.getGenericSuperclass();
        String typeName = type.getTypeName();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] ts = parameterizedType.getActualTypeArguments();
            Class cls = (Class)ts[0];
            return cls;
        }
        String errorMsg = String.format("[MyData find one error] , DAO \u51fa\u73b0\u9519\u8bef,\u7f3a\u5c11\u5fc5\u8981\u7684\u6cdb\u578b! \u8bf7\u68c0\u67e5\u76ee\u6807\u7c7b%s", typeName);
        throw new IllegalStateException(errorMsg);
    }

    public static String getDataBaseTypeName(IConnectionManager connectionManager) throws SQLException {
        String dbTypeName = null;
        dbTypeName = connectionManager.getDb();
        if (dbTypeName != null && !"".equals(dbTypeName.trim())) {
            return dbTypeName;
        }
        dbTypeName = connectionManager.getConnection().getMetaData().getDatabaseProductName();
        return dbTypeName;
    }

    public static String getFirstTableName(Class<?> domainClazz) {
        String tbn;
        String tableName = domainClazz.getSimpleName();
        if (domainClazz.isAnnotationPresent(Table.class) && (tbn = domainClazz.getAnnotation(Table.class).name().trim()).length() > 0) {
            tableName = tbn;
        }
        return tableName;
    }

    public static String getTableColumn(Class<?> domainClazz) {
        TableComment tableComment = domainClazz.getAnnotation(TableComment.class);
        return tableComment == null ? null : tableComment.value();
    }

    public static String getTableEngine(Class<?> domainClazz) {
        TableEngine tableEngine = domainClazz.getAnnotation(TableEngine.class);
        return tableEngine == null ? null : tableEngine.value();
    }

    public static String getTableCharset(Class<?> domainClazz) {
        TableCharset tableCharset = domainClazz.getAnnotation(TableCharset.class);
        return tableCharset == null ? null : tableCharset.value();
    }
}

