/*
 * Decompiled with CFR 0.152.
 */
package run.mydata.dao.base.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.mydata.annotation.ColumnRule;
import run.mydata.dao.base.IMyData;
import run.mydata.em.KSentences;
import run.mydata.em.Operate;
import run.mydata.em.PmType;
import run.mydata.em.RuleType;
import run.mydata.em.StatisticsType;
import run.mydata.exception.ObjectOptimisticLockingFailureException;
import run.mydata.helper.MyDataHelper;
import run.mydata.helper.MyObjectUtils;
import run.mydata.helper.OrderBy;
import run.mydata.helper.PageData;
import run.mydata.helper.Param;
import run.mydata.helper.PropInfo;
import run.mydata.helper.QueryCallable;
import run.mydata.helper.QueryVo;
import run.mydata.helper.SortComparator;
import run.mydata.helper.SortInfo;
import run.mydata.manager.ConnectionManager;
import run.mydata.manager.IConnectionManager;

public abstract class MyDataSupport<POJO>
implements IMyData<POJO> {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Class<POJO> domainClazz;
    private String firstTableName;
    private String dataBaseTypeName;
    private boolean isShowSql;
    private boolean isGenerateDdl;
    private boolean hasTableComment;
    private String tableComment;
    private boolean hasTableEngine;
    private String tableEngine;
    private boolean hasTableCharset;
    private String tableCharset;
    private volatile int maxTableCount = 1024;
    private static final String ALTER_TABLE_MODIFY_COLUMN = "ALTER TABLE %s MODIFY %s %s";
    private static final String INDEX_SUBFIX = "_idx";
    private static final String ALTER_TABLE_S_ADD_S = "ALTER TABLE %s ADD (%s)";
    private static final String CREATE_INDEX_S = "CREATE %s INDEX %s ON %s(%s)";
    private static final String SEQUENCE_QUERY = "SELECT sequence_name FROM user_sequences WHERE sequence_name=?";
    private static final int MAX_IDLE_TABLE_COUNT = 8;
    private static final ForkJoinPool NEW_FIXED_THREAD_POOL = new ForkJoinPool(Integer.min(Runtime.getRuntime().availableProcessors() * 4, 32));
    private static volatile ConcurrentHashMap<Class<?>, ConcurrentSkipListSet<String>> DOMAINCLASS_TABLES_MAP = new ConcurrentHashMap();
    private static final Object FIRST_TABLECREATE = new Object();

    public abstract IConnectionManager getConnectionManager();

    @PostConstruct
    public void init() {
        try {
            this.domainClazz = MyDataHelper.getDomainClassByDaoClass(this.getClass());
            this.firstTableName = MyDataHelper.getFirstTableName(this.domainClazz);
            this.dataBaseTypeName = MyDataHelper.getDataBaseTypeName(this.getConnectionManager());
            this.tableComment = MyDataHelper.getTableColumn(this.domainClazz);
            this.hasTableComment = this.tableComment != null;
            this.tableEngine = MyDataHelper.getTableEngine(this.domainClazz);
            this.hasTableEngine = this.tableEngine != null;
            this.tableCharset = MyDataHelper.getTableCharset(this.domainClazz);
            this.hasTableCharset = this.tableCharset != null;
            this.isShowSql = this.getConnectionManager().isShowSql();
            this.isGenerateDdl = this.getConnectionManager().isDdl();
            Set<PropInfo> pps = this.getPropInfos();
            if (this.isGenerateDdl) {
                this.createFirstTable(pps);
            }
            this.setSqlType(pps);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("[ MyData init error]");
        }
    }

    protected Set<PropInfo> getPropInfos() {
        Map<String, LinkedHashSet<PropInfo>> tbinfo = ConnectionManager.getTbinfo(this.domainClazz);
        LinkedHashSet<PropInfo> propInfos = tbinfo.entrySet().iterator().next().getValue();
        return propInfos;
    }

    private void createFirstTable(Set<PropInfo> propInfos) {
        try {
            String idTableName;
            boolean isUseGlobalTableId;
            PreparedStatement preparedStatement;
            String tableName = this.firstTableName;
            Connection connection = this.getConnectionManager().getConnection();
            if ("Oracle".equalsIgnoreCase(this.dataBaseTypeName)) {
                String seqName;
                boolean isSeqExists;
                if (propInfos.stream().anyMatch(p -> this.autoNextVal((PropInfo)p)) && !(isSeqExists = this.sequenceExists(connection, seqName = this.getSequenceName(tableName)))) {
                    String createseqsql = String.format("%s %s", new Object[]{KSentences.CREATE_SEQUENCE, seqName});
                    preparedStatement = connection.prepareStatement(createseqsql);
                    if (this.isShowSql) {
                        log.error(preparedStatement.toString());
                    }
                    preparedStatement.executeUpdate();
                }
            } else if ("MySQL".equalsIgnoreCase(this.dataBaseTypeName) && (isUseGlobalTableId = propInfos.stream().anyMatch(p -> GenerationType.TABLE.equals((Object)p.getGeneratorValueAnnoStrategyVal()))) && !this.isTableExists(connection, idTableName = this.getIdTableName(tableName))) {
                String createIdTableSql = String.format("%s %s(SID BIGINT PRIMARY  KEY AUTO_INCREMENT)", new Object[]{KSentences.CREATE_TABLE, idTableName});
                preparedStatement = connection.prepareStatement(createIdTableSql);
                if (this.isShowSql) {
                    log.error(preparedStatement.toString());
                }
                preparedStatement.executeUpdate();
                Optional<PropInfo> opst = propInfos.stream().filter(id -> id.getGeneratorValueAnnoGeneratorVal() != null && id.getGeneratorValueAnnoGeneratorVal().length() < 10 && Pattern.matches("\\d+", id.getGeneratorValueAnnoGeneratorVal().trim())).findFirst();
                if (opst.isPresent()) {
                    String insertIdTableSql = this.genInsertIdTableSql(idTableName, ((PropInfo)opst.get()).getGeneratorValueAnnoGeneratorVal().trim());
                    PreparedStatement preparedStatement1 = connection.prepareStatement(insertIdTableSql);
                    if (this.isShowSql) {
                        log.error(preparedStatement1.toString());
                    }
                    preparedStatement1.executeUpdate();
                }
            }
            if (!this.isTableExists(connection, tableName)) {
                this.createTableBySql(tableName);
                ColumnRule columnRule = this.getColumnRule();
                if (columnRule != null && columnRule.ruleType().equals((Object)RuleType.MOD)) {
                    int maxIdleTablecount = this.getMaxIdleTablecount(columnRule);
                    for (int i = 1; i < maxIdleTablecount; ++i) {
                        String ctbname = MyDataSupport.getTableName(Long.valueOf(i), tableName);
                        this.executeCreate(tableName, ctbname);
                    }
                }
            } else {
                PreparedStatement preparedStatement2;
                List<PropInfo> cnames = this.getDbProps(tableName, connection);
                if (cnames.size() < 1) {
                    cnames = this.getDbProps(tableName.toUpperCase(), connection);
                }
                ArrayList<PropInfo> ncns = new ArrayList<PropInfo>();
                block8: for (PropInfo pi : propInfos) {
                    for (PropInfo cn : cnames) {
                        Field fd;
                        Temporal tp;
                        if (!cn.getCname().equalsIgnoreCase(pi.getCname())) continue;
                        if (cn.getSqlTypes() == 12 && cn.getLength() < pi.getLength()) {
                            this.changeToString(pi);
                            continue block8;
                        }
                        if (!(cn.getSqlTypes() != 4 && cn.getSqlTypes() != -5 || pi.getType() != Double.class && pi.getType() != Float.class)) {
                            for (String t : this.getCurrentTables()) {
                                String altertablesql = String.format(ALTER_TABLE_MODIFY_COLUMN, t, cn.getCname(), this.getPrecisionDatatype(pi.getType().getSimpleName()));
                                preparedStatement2 = connection.prepareStatement(altertablesql);
                                if (this.isShowSql) {
                                    log.error(preparedStatement2.toString());
                                }
                                preparedStatement2.executeUpdate();
                            }
                            continue block8;
                        }
                        if (!(cn.getSqlTypes() != 4 && cn.getSqlTypes() != -5 || pi.getType() != String.class || pi.getIsLob().booleanValue())) {
                            this.changeToString(pi);
                            continue block8;
                        }
                        if (cn.getSqlTypes() != 91 || pi.getType() != Date.class || (tp = (fd = this.domainClazz.getDeclaredField(pi.getPname())).getAnnotation(Temporal.class)) == null || !tp.value().equals((Object)TemporalType.TIMESTAMP)) continue block8;
                        for (String t : this.getCurrentTables()) {
                            String altertablesql = String.format(ALTER_TABLE_MODIFY_COLUMN, t, cn.getCname(), this.getTimestampType());
                            PreparedStatement preparedStatement3 = connection.prepareStatement(altertablesql);
                            if (this.isShowSql) {
                                log.error(preparedStatement3.toString());
                            }
                            preparedStatement3.executeUpdate();
                        }
                        continue block8;
                    }
                    ncns.add(pi);
                }
                if (ncns.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    Iterator ite = ncns.iterator();
                    while (ite.hasNext()) {
                        PropInfo nextcn = (PropInfo)ite.next();
                        sb.append(this.getColumnLine(nextcn));
                        if (!ite.hasNext()) continue;
                        sb.append(KSentences.COMMA.getValue());
                    }
                    if (sb.length() > 0) {
                        String avl = sb.toString();
                        Set<String> currentTables = this.getCurrentTables();
                        connection = this.getConnectionManager().getConnection();
                        for (String t : currentTables) {
                            try {
                                String sql = String.format(ALTER_TABLE_S_ADD_S, t, avl);
                                preparedStatement2 = connection.prepareStatement(sql);
                                if (this.isShowSql) {
                                    log.error(preparedStatement2.toString());
                                }
                                preparedStatement2.executeUpdate();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            this.createIndex(tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private void closeConnection() {
        this.getConnectionManager().closeConnection();
    }

    private boolean isTableExists(Connection connection, String tableName) throws SQLException {
        ResultSet rs = MyDataSupport.getTableMeta(connection);
        while (rs.next()) {
            String rzn = rs.getString("TABLE_NAME");
            if (!rzn.equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    private void setSqlType(Set<PropInfo> pps) {
        try {
            Connection connection = this.getConnectionManager().getConnection();
            ResultSet crs = connection.getMetaData().getColumns(connection.getCatalog(), null, this.firstTableName, null);
            block5: while (crs.next()) {
                for (PropInfo o : pps) {
                    if (!crs.getString("COLUMN_NAME").equals(o.getCname())) continue;
                    o.setSqlTypes(crs.getInt("DATA_TYPE"));
                    continue block5;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private String getIdTableName(String tableName) {
        return String.format("%s_%s_%s", tableName, "SEQ", "ID").toUpperCase();
    }

    private String genInsertIdTableSql(String idTableName, String valueOfInsert) {
        String insertIdtable = String.format("%s %s %s", new Object[]{KSentences.INSERT, idTableName, String.format(" VALUES(%s)", valueOfInsert)});
        return insertIdtable;
    }

    private boolean createTableBySql(String tableName) throws SQLException {
        String csql = this.createTable(tableName);
        if (csql != null && csql.trim().length() > 0) {
            PreparedStatement preparedStatement = this.getConnectionManager().getConnection().prepareStatement(csql);
            if (this.isShowSql) {
                log.error(preparedStatement.toString());
            }
            preparedStatement.executeUpdate();
            this.createIndex(tableName);
            return true;
        }
        return false;
    }

    protected String createTable(String tableName) {
        Set<PropInfo> props = this.getPropInfos();
        if (props.size() > 0) {
            StringBuilder ctbsb = new StringBuilder(KSentences.CREATE_TABLE.getValue());
            ctbsb.append(tableName).append("(");
            Iterator<PropInfo> psItrat = props.iterator();
            while (psItrat.hasNext()) {
                PropInfo p = psItrat.next();
                ctbsb.append(this.getColumnLine(p));
                if (!psItrat.hasNext()) continue;
                ctbsb.append(KSentences.COMMA.getValue());
            }
            ctbsb.append(") ");
            if (this.hasTableEngine) {
                ctbsb.append(KSentences.ENGINE.getValue()).append(KSentences.EQ.getValue()).append(this.tableEngine).append(KSentences.SPACING.getValue());
            }
            if (this.hasTableCharset) {
                ctbsb.append(KSentences.CHARSET.getValue()).append(KSentences.EQ.getValue()).append(this.tableCharset).append(KSentences.SPACING.getValue());
            }
            if (this.hasTableComment) {
                ctbsb.append(KSentences.COMMENT.getValue()).append(" '").append(this.tableComment).append("' ");
            }
            return ctbsb.toString();
        }
        return "";
    }

    protected String getColumnLine(PropInfo p) {
        if ("MySQL".equalsIgnoreCase(this.dataBaseTypeName)) {
            return this.getMysqlColumnLine(p);
        }
        if ("Oracle".equalsIgnoreCase(this.dataBaseTypeName)) {
            return this.getOracleColumnLine(p);
        }
        throw new IllegalArgumentException("not support database");
    }

    private String getMysqlColumnLine(PropInfo p) {
        Field fd;
        StringBuilder ctsb = new StringBuilder();
        ctsb.append("`").append(p.getCname()).append("` ");
        if (p.getType() == Integer.class) {
            ctsb.append("INT");
        } else if (p.getType() == Float.class) {
            ctsb.append("FLOAT");
        } else if (p.getType() == Long.class) {
            ctsb.append("BIGINT");
        } else if (p.getType() == Double.class) {
            ctsb.append("Double");
        } else if (p.getType() == Boolean.class) {
            ctsb.append("BIT");
        } else if (p.getType() == Date.class) {
            try {
                fd = this.domainClazz.getDeclaredField(p.getPname());
                Temporal tp = fd.getAnnotation(Temporal.class);
                if (tp != null && tp.value().equals((Object)TemporalType.TIMESTAMP)) {
                    ctsb.append(this.getTimestampType());
                }
                if (tp != null && tp.value().equals((Object)TemporalType.TIME)) {
                    ctsb.append("TIME");
                }
                ctsb.append("DATE");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        } else if (p.getType() == Time.class) {
            ctsb.append("TIME");
        } else if (p.getType() == Timestamp.class) {
            ctsb.append(this.getTimestampType());
        } else if (p.getType() == String.class) {
            if (p.getIsLob().booleanValue()) {
                ctsb.append("LONGTEXT");
            } else {
                ctsb.append("VARCHAR(").append(p.getLength()).append(")");
            }
        } else if (p.getType() == byte[].class) {
            ctsb.append("LONGBLOB");
        } else if (p.getType().isEnum()) {
            try {
                fd = this.domainClazz.getDeclaredField(p.getPname());
                Enumerated enm = fd.getAnnotation(Enumerated.class);
                if (enm != null && enm.value() == EnumType.STRING) {
                    ctsb.append("VARCHAR(").append(p.getLength()).append(")");
                }
                ctsb.append("INT");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        } else {
            String type = p.getType().toString();
            String err = String.format("POJO field type not support mapping to column , %2 ; POJO\u5b57\u6bb5\u5c5e\u6027\u7c7b\u578b\u5e76\u4e0d\u652f\u6301, %s ;", type, type);
            log.error(err);
            throw new IllegalStateException(err);
        }
        if (p.getIsPrimarykey().booleanValue()) {
            ctsb.append(" PRIMARY KEY ");
            String autoincrement = " AUTO_INCREMENT ";
            if (GenerationType.IDENTITY.equals((Object)p.getGeneratorValueAnnoStrategyVal())) {
                ctsb.append(autoincrement);
            } else if (GenerationType.AUTO.equals((Object)p.getGeneratorValueAnnoStrategyVal())) {
                ctsb.append(autoincrement);
            }
        } else {
            if (p.getIsNotNull().booleanValue()) {
                ctsb.append(" NOT NULL ");
            }
            if (p.getIsUnique().booleanValue()) {
                ctsb.append(" UNIQUE ");
            }
        }
        if (p.getComment() != null && !"".equals(p.getComment())) {
            ctsb.append(" ").append(KSentences.COMMENT.getValue()).append(" '").append(p.getComment()).append("' ");
        }
        return ctsb.toString();
    }

    private String getTimestampType() {
        if ("MySQL".equalsIgnoreCase(this.dataBaseTypeName)) {
            return "DATETIME";
        }
        if ("Oracle".equalsIgnoreCase(this.dataBaseTypeName)) {
            return "timestamp";
        }
        throw new IllegalArgumentException("not support database");
    }

    protected String getOracleColumnLine(PropInfo p) {
        StringBuilder sb = new StringBuilder();
        sb.append(p.getCname()).append("   ");
        if (p.getType() == Integer.class) {
            sb.append("number(10,0)");
        } else if (p.getType() == Float.class) {
            sb.append("float");
        } else if (p.getType() == Long.class) {
            sb.append("number(19,0)");
        } else if (p.getType() == Double.class) {
            sb.append("float");
        } else if (p.getType() == Boolean.class) {
            sb.append("number(1,0)");
        } else if (p.getType() == Date.class) {
            try {
                Field fd = this.domainClazz.getDeclaredField(p.getPname());
                Temporal tp = fd.getAnnotation(Temporal.class);
                if (tp != null && tp.value().equals((Object)TemporalType.TIMESTAMP)) {
                    sb.append("timestamp");
                }
                sb.append("DATE");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        } else if (p.getType() == Time.class) {
            sb.append("date");
        } else if (p.getType() == Timestamp.class) {
            sb.append("timestamp");
        } else if (p.getType() == String.class) {
            if (p.getIsLob().booleanValue()) {
                sb.append("clob");
            } else {
                sb.append("varchar2(").append(p.getLength()).append(" char)");
            }
        } else if (p.getType() == byte[].class) {
            sb.append("blob");
        } else if (p.getType().isEnum()) {
            try {
                Field fd = this.domainClazz.getDeclaredField(p.getPname());
                Enumerated enm = fd.getAnnotation(Enumerated.class);
                if (enm != null && enm.value() == EnumType.STRING) {
                    sb.append("varchar2(").append(p.getLength()).append(" char)");
                }
                sb.append("number(10,0)");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        } else {
            String type = p.getType().toString();
            String err = String.format("POJO field type not support mapping to column , %2 ; POJO\u5b57\u6bb5\u5c5e\u6027\u7c7b\u578b\u5e76\u4e0d\u652f\u6301, %s ;", type, type);
            log.error(err);
            throw new IllegalStateException(err);
        }
        if (p.getIsPrimarykey().booleanValue()) {
            sb.append(" PRIMARY KEY ");
        } else {
            if (p.getIsNotNull().booleanValue()) {
                sb.append(" NOT NULL ");
            }
            if (p.getIsUnique().booleanValue()) {
                sb.append(" UNIQUE ");
            }
        }
        return sb.toString();
    }

    private int getMaxIdleTablecount(ColumnRule crn) {
        if (crn.ruleType().equals((Object)RuleType.MOD)) {
            return Long.valueOf(Math.min((long)this.maxTableCount, crn.value())).intValue();
        }
        return 8;
    }

    private void createIndex(String tableName) throws SQLException {
        for (PropInfo prop : this.getPropInfos()) {
            if (!this.indexIsExist(tableName, prop)) continue;
            for (String tableNameOfTables : this.getCurrentTables()) {
                if (!this.indexIsExist(tableNameOfTables, prop)) continue;
                try {
                    String sql = String.format(CREATE_INDEX_S, prop.getIndex().unique() ? KSentences.UNIQUE : "", this.getIndexName(prop), tableNameOfTables, this.getIndexColumns(prop));
                    PreparedStatement preparedStatement = this.getConnectionManager().getConnection().prepareStatement(sql);
                    if (this.isShowSql) {
                        log.error(preparedStatement.toString());
                    }
                    preparedStatement.executeUpdate();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    log.error("create index error ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getCurrentTables() {
        ConcurrentSkipListSet<String> tbns = DOMAINCLASS_TABLES_MAP.get(this.domainClazz);
        if (tbns == null) {
            ConcurrentHashMap<Class<?>, ConcurrentSkipListSet<String>> concurrentHashMap = DOMAINCLASS_TABLES_MAP;
            synchronized (concurrentHashMap) {
                tbns = DOMAINCLASS_TABLES_MAP.get(this.domainClazz);
                if (tbns == null) {
                    tbns = this.reFreshTables();
                }
            }
        }
        return tbns;
    }

    private boolean indexIsExist(String tableName, PropInfo prop) throws SQLException {
        return this.indexIsExistByTableName(tableName, prop) && this.indexIsExistByTableName(tableName.toUpperCase(), prop);
    }

    private boolean indexIsExistByTableName(String tbn, PropInfo prop) throws SQLException {
        if (prop.getIndex() != null) {
            String idxName = this.getIndexName(prop);
            HashMap<String, String> grps = new HashMap<String, String>(5);
            ResultSet saa = this.getConnectionManager().getConnection().getMetaData().getIndexInfo(null, null, tbn, prop.getIndex().unique(), false);
            while (saa.next()) {
                String idn = saa.getString("INDEX_NAME");
                if (idn == null) continue;
                if (idxName.equalsIgnoreCase(idn)) {
                    return false;
                }
                String cn = saa.getString("COLUMN_NAME");
                if (grps.get(idn) != null) {
                    grps.put(idn, (String)grps.get(idn) + cn);
                } else {
                    grps.put(idn, cn);
                }
                if (!this.dataBaseTypeName.equalsIgnoreCase("Oracle") || !idn.startsWith("SYS_") || !cn.equalsIgnoreCase(prop.getCname())) continue;
                return false;
            }
            PropInfo propInfo = this.getPropInfoByPName(prop.getIndex().otherPropName());
            if (!grps.containsKey(idxName) && !grps.containsValue(prop.getCname() + (propInfo == null ? "" : propInfo.getCname()))) {
                return true;
            }
        }
        return false;
    }

    private String getIndexName(PropInfo p) {
        String string;
        if (p.getIndex().name().equals("")) {
            Object[] objectArray = new Object[2];
            objectArray[0] = p.getCname() + (p.getIndex().otherPropName() != null && p.getIndex().otherPropName().length() > 0 ? "_" + p.getIndex().otherPropName().replace(",", "_") : "");
            objectArray[1] = INDEX_SUBFIX;
            string = String.format("%s%s", objectArray);
        } else {
            string = p.getIndex().name();
        }
        String idxName = string;
        return idxName;
    }

    private static String getTableName(Long max, String name) {
        if (max < 1L) {
            return name;
        }
        return name + KSentences.SHARDING_SPLT.getValue() + max;
    }

    private ConcurrentSkipListSet<String> reFreshTables() {
        try {
            ResultSet rs = MyDataSupport.getTableMeta(this.getConnectionManager().getConnection());
            ConcurrentSkipListSet<String> tbns = new ConcurrentSkipListSet<String>();
            String srctb = ConnectionManager.getTbinfo(this.domainClazz).entrySet().iterator().next().getKey();
            while (rs.next()) {
                String dbtbn = rs.getString("TABLE_NAME");
                String schem = rs.getString("TABLE_SCHEM");
                String[] tbsps = dbtbn.toUpperCase().split("^" + srctb.toUpperCase());
                int z = 110;
                if (tbsps.length == 2) {
                    String ts = tbsps[1].replaceAll("_", "");
                    z = ts.length() == 0 ? 0 : (int)ts.charAt(0);
                }
                if (tbsps.length != 0 && (z < 48 || z > 57) && (z < 0 || z > 9) || !dbtbn.toLowerCase().startsWith(srctb.toLowerCase())) continue;
                if (schem != null && schem.length() > 0) {
                    dbtbn = schem + "." + dbtbn;
                }
                tbns.add(dbtbn);
            }
            DOMAINCLASS_TABLES_MAP.put(this.domainClazz, tbns);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
        return DOMAINCLASS_TABLES_MAP.get(this.domainClazz);
    }

    @Override
    public Integer deleteById(Serializable ... id) {
        if (id != null && id.length > 0) {
            Set<Param> pms = Param.getParams(new Param(this.getPrimaryKeyPname(), Arrays.asList(id)));
            return this.deleteByCondition(pms);
        }
        return 0;
    }

    @Override
    public Integer update(Set<Param> pms, Map<String, Object> newValues) {
        if (this.getCurrentTables().size() < 1) {
            return 0;
        }
        try {
            Set<String> tbns = this.getTableNamesByParams(pms);
            if (newValues != null && newValues.size() > 0) {
                Set<PropInfo> pps = this.getPropInfos();
                int ttc = 0;
                for (String tn : tbns) {
                    StringBuilder buf = new StringBuilder(KSentences.UPDATE.getValue());
                    buf.append(tn).append(KSentences.SET.getValue());
                    Iterator<Map.Entry<String, Object>> ite = newValues.entrySet().iterator();
                    while (ite.hasNext()) {
                        Map.Entry<String, Object> en = ite.next();
                        for (PropInfo p : pps) {
                            if (!p.getPname().equals(en.getKey())) continue;
                            buf.append("`").append(p.getCname()).append("`").append(KSentences.EQ.getValue()).append(KSentences.POSITION_PLACEHOLDER.getValue());
                            if (!ite.hasNext()) continue;
                            buf.append(KSentences.COMMA.getValue());
                        }
                    }
                    buf.append(this.getWhereSqlByParam(pms));
                    String sql = buf.toString();
                    PreparedStatement statement = this.getStatementBySql(false, sql);
                    this.setWhereSqlParamValue(pms, statement, this.setUpdateNewValues(newValues, statement));
                    if (this.isShowSql) {
                        log.error(statement.toString());
                    }
                    ttc += statement.executeUpdate();
                }
                Integer n = ttc;
                return n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
        return 0;
    }

    @Override
    public Integer delete(Set<Param> pms) {
        if (this.getCurrentTables().size() < 1) {
            return 0;
        }
        return this.deleteByCondition(pms);
    }

    private boolean isDate(String property) {
        for (PropInfo p : this.getPropInfos()) {
            if (!p.getPname().equals(property)) continue;
            return p.getSqlTypes() == 91 || p.getSqlTypes() == 92 || p.getSqlTypes() == 93;
        }
        return false;
    }

    @Override
    public Date getMinDate(Set<Param> pms, String property) {
        return this.getDateFuncValue(pms, property, StatisticsType.MIN);
    }

    @Override
    public Date getMaxDate(Set<Param> pms, String property) {
        return this.getDateFuncValue(pms, property, StatisticsType.MAX);
    }

    @Override
    public <T> T nativeQuery(String sql, Object[] pms, Class<T> resultClass) {
        try {
            Object t = this.getT(resultClass);
            PreparedStatement st = this.getPreparedStatement(sql, pms);
            if (this.isShowSql) {
                log.error(st.toString());
            }
            ResultSet rs = st.executeQuery();
            if (t instanceof String || t instanceof Number || t instanceof Boolean || t instanceof Date) {
                t = rs.next() ? this.getRT(resultClass, t, rs) : null;
                T t2 = t;
                return t2;
            }
            Field[] declaredFields = resultClass.getDeclaredFields();
            if (rs.next()) {
                T t3 = this.getRTObj(declaredFields, resultClass, t, rs);
                return t3;
            }
            T t4 = null;
            return t4;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public <T> List<T> nativeQueryList(String sql, Object[] pms, Class<T> resultClass) {
        try {
            T t = this.getT(resultClass);
            PreparedStatement st = this.getPreparedStatement(sql, pms);
            if (this.isShowSql) {
                log.error(st.toString());
            }
            ResultSet rs = st.executeQuery();
            ArrayList<T> tList = new ArrayList<T>();
            if (t instanceof String || t instanceof Number || t instanceof Boolean || t instanceof Date) {
                while (rs.next()) {
                    tList.add(this.getRT(resultClass, this.getT(resultClass), rs));
                }
                ArrayList<T> arrayList = tList;
                return arrayList;
            }
            Field[] declaredFields = resultClass.getDeclaredFields();
            while (rs.next()) {
                tList.add(this.getRTObj(declaredFields, resultClass, this.getT(resultClass), rs));
            }
            ArrayList<T> arrayList = tList;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public <T> PageData<T> nativeQueryPage(int curPage, int pageSize, String sql, Object[] pms, Class<T> result) {
        String countSql = "SELECT COUNT(1) FROM (" + sql + ") t";
        Long totalCount = this.nativeQuery(countSql, pms, Long.class);
        if (totalCount == 0L) {
            return new PageData(curPage, pageSize, totalCount, new ArrayList(0));
        }
        int startIndex = (curPage - 1) * pageSize;
        String limitSql = sql + (Object)((Object)KSentences.LIMIT) + startIndex + (Object)((Object)KSentences.COMMA) + pageSize;
        List<T> dataList = this.nativeQueryList(limitSql, pms, result);
        return new PageData<T>(curPage, pageSize, totalCount, dataList);
    }

    private <T> T getT(Class<T> resultClass) throws InstantiationException, IllegalAccessException {
        Comparable<Byte> t = null;
        Integer izreo = 0;
        String zreo = "0";
        t = resultClass.equals(Byte.class) ? new Byte(zreo) : (resultClass.equals(Short.class) ? new Short(zreo) : (resultClass.equals(Integer.class) ? new Integer(zreo) : (resultClass.equals(Long.class) ? new Long(zreo) : (resultClass.equals(Float.class) ? new Float(zreo) : (resultClass.equals(Double.class) ? new Double(zreo) : (resultClass.equals(BigDecimal.class) ? new BigDecimal(zreo) : (resultClass.equals(Boolean.class) ? new Boolean(false) : (resultClass.equals(java.sql.Date.class) ? new java.sql.Date(izreo.intValue()) : (resultClass.equals(Timestamp.class) ? new Timestamp(izreo.intValue()) : (resultClass.equals(Time.class) ? new Time(izreo.intValue()) : resultClass.newInstance()))))))))));
        if (t instanceof Collection || t instanceof Map) {
            String error = "NOT SUPPORT resultClass  OF " + resultClass;
            log.error(error);
            throw new IllegalStateException(error);
        }
        return (T)t;
    }

    private PreparedStatement getPreparedStatement(String sql, Object[] pms) throws SQLException {
        if (pms == null) {
            pms = new String[]{};
        }
        PreparedStatement st = this.getConnectionManager().getConnection().prepareStatement(sql);
        if (pms != null) {
            for (int i = 1; i < pms.length + 1; ++i) {
                Object o = pms[i - 1];
                if (o instanceof String) {
                    st.setString(i, (String)o);
                    continue;
                }
                if (o instanceof Long) {
                    st.setLong(i, (Long)o);
                    continue;
                }
                if (o instanceof Integer) {
                    st.setInt(i, (Integer)o);
                    continue;
                }
                if (o instanceof Boolean) {
                    st.setBoolean(i, (Boolean)o);
                    continue;
                }
                if (o instanceof Double) {
                    st.setDouble(i, (Double)o);
                    continue;
                }
                if (o instanceof Date) {
                    st.setDate(i, (java.sql.Date)o);
                    continue;
                }
                if (o instanceof BigDecimal) {
                    st.setBigDecimal(i, (BigDecimal)o);
                    continue;
                }
                if (o instanceof Float) {
                    st.setFloat(i, ((Float)o).floatValue());
                    continue;
                }
                if (o instanceof Time) {
                    st.setTime(i, (Time)o);
                    continue;
                }
                if (o instanceof Timestamp) {
                    st.setTimestamp(i, (Timestamp)o);
                    continue;
                }
                if (o instanceof Blob) {
                    st.setBlob(i, (Blob)o);
                    continue;
                }
                if (o instanceof Byte) {
                    st.setByte(i, (Byte)o);
                    continue;
                }
                if (o instanceof Short) {
                    st.setShort(i, (Short)o);
                    continue;
                }
                String error = "NOT SUPPORT TYPE IN pms OF " + o.getClass();
                log.error(error);
                throw new IllegalStateException(error);
            }
        }
        return st;
    }

    private <T> T getRT(Class<T> resultClass, T t, ResultSet rs) throws SQLException {
        if (resultClass.equals(String.class)) {
            t = rs.getString(1);
        } else if (resultClass.equals(Long.class)) {
            t = new Long(rs.getString(1));
        } else if (resultClass.equals(Double.class)) {
            t = new Double(rs.getString(1));
        } else if (resultClass.equals(Integer.class)) {
            t = new Integer(rs.getString(1));
        } else if (resultClass.equals(Short.class)) {
            t = new Short(rs.getString(1));
        } else if (resultClass.equals(Byte.class)) {
            t = new Byte(rs.getString(1));
        } else if (resultClass.equals(Float.class)) {
            t = new Float(rs.getString(1));
        } else if (resultClass.equals(Boolean.class)) {
            String str = rs.getString(1);
            t = str.equals("1") || str.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false);
        } else if (resultClass.equals(BigDecimal.class)) {
            t = rs.getBigDecimal(1);
        } else if (resultClass.equals(Date.class) || resultClass.equals(java.sql.Date.class)) {
            t = rs.getDate(1);
        } else if (resultClass.equals(Timestamp.class)) {
            t = rs.getTimestamp(1);
        } else if (resultClass.equals(Time.class)) {
            t = rs.getTime(1);
        }
        return t;
    }

    private <T> T getRTObj(Field[] declaredFields, Class<T> resultClass, T t, ResultSet rs) throws SQLException {
        for (int i = 0; i < declaredFields.length; ++i) {
            Column column;
            Field field = declaredFields[i];
            if (field.isAnnotationPresent(Transient.class)) continue;
            String name = field.getName();
            if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).name() != null && !column.name().trim().equals("")) {
                name = column.name();
            }
            int columnIndex = rs.findColumn(name);
            Class<?> type = field.getType();
            Object value = null;
            if (type.equals(Byte.class)) {
                value = rs.getByte(columnIndex);
            } else if (type.equals(Short.class)) {
                value = rs.getShort(columnIndex);
            } else if (type.equals(Integer.class)) {
                value = rs.getInt(columnIndex);
            } else if (type.equals(Long.class)) {
                value = rs.getLong(columnIndex);
            } else if (type.equals(String.class)) {
                value = rs.getString(columnIndex);
            } else if (type.equals(Boolean.class)) {
                value = rs.getBoolean(columnIndex);
            } else if (type.equals(BigDecimal.class)) {
                value = rs.getBigDecimal(columnIndex);
            } else if (type.equals(Double.class)) {
                value = rs.getDouble(columnIndex);
            } else if (type.equals(Float.class)) {
                value = Float.valueOf(rs.getFloat(columnIndex));
            } else if (type.equals(Date.class)) {
                value = rs.getDate(columnIndex);
            } else if (type.equals(Timestamp.class)) {
                value = rs.getTimestamp(columnIndex);
            } else {
                if (!type.equals(Time.class)) continue;
                value = rs.getTime(columnIndex);
            }
            field.setAccessible(true);
            try {
                field.set(t, value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return t;
    }

    @Override
    public int nativeExecute(String sql, Object[] pms) {
        try {
            if (pms == null) {
                pms = new String[]{};
            }
            PreparedStatement st = this.getConnectionManager().getConnection().prepareStatement(sql);
            for (int i = 1; i < pms.length + 1; ++i) {
                Object o = pms[i - 1];
                if (o instanceof String) {
                    st.setString(i, (String)o);
                    continue;
                }
                if (o instanceof Long) {
                    st.setLong(i, (Long)o);
                    continue;
                }
                if (o instanceof Integer) {
                    st.setInt(i, (Integer)o);
                    continue;
                }
                if (o instanceof Boolean) {
                    st.setBoolean(i, (Boolean)o);
                    continue;
                }
                if (o instanceof Double) {
                    st.setDouble(i, (Double)o);
                    continue;
                }
                if (o instanceof BigDecimal) {
                    st.setBigDecimal(i, (BigDecimal)o);
                    continue;
                }
                if (o instanceof Float) {
                    st.setFloat(i, ((Float)o).floatValue());
                    continue;
                }
                if (o instanceof Date) {
                    st.setDate(i, (java.sql.Date)o);
                    continue;
                }
                if (o instanceof Timestamp) {
                    st.setTimestamp(i, (Timestamp)o);
                    continue;
                }
                if (o instanceof Time) {
                    st.setTime(i, (Time)o);
                    continue;
                }
                if (o instanceof Blob) {
                    st.setBlob(i, (Blob)o);
                    continue;
                }
                if (o instanceof Byte) {
                    st.setByte(i, (Byte)o);
                    continue;
                }
                if (o instanceof Short) {
                    st.setShort(i, (Short)o);
                    continue;
                }
                String error = "NOT SUPPORT TYPE OF " + o.getClass();
                log.error(error);
                throw new IllegalStateException(error);
            }
            if (this.isShowSql) {
                log.error(st.toString());
            }
            int n = st.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private Date getDateFuncValue(Set<Param> pms, String property, StatisticsType st) {
        try {
            if (this.isDate(property)) {
                Object object;
                List<Future<QueryVo<ResultSet>>> rzts = this.getFunctionValues(pms, property, st);
                ArrayList<Timestamp> rzslist = new ArrayList<Timestamp>();
                for (Future<QueryVo<ResultSet>> f : rzts) {
                    ResultSet rs = f.get().getOv();
                    while (rs.next()) {
                        Timestamp o = rs.getTimestamp(1);
                        if (o == null) continue;
                        rzslist.add(new Timestamp(o.getTime()));
                    }
                }
                if (rzslist.size() > 0) {
                    if (rzslist.size() == 1) {
                        object = (Date)rzslist.get(0);
                        return object;
                    }
                    if (StatisticsType.MIN.equals((Object)st)) {
                        object = rzslist.parallelStream().min(Comparator.comparing(d -> d)).get();
                        return object;
                    }
                    if (StatisticsType.MAX.equals((Object)st)) {
                        object = rzslist.parallelStream().max(Comparator.comparing(d -> d)).get();
                        return object;
                    }
                    throw new IllegalArgumentException(String.format("Date type not supprot %s ; Date\u7c7b\u578b\u4e0d\u652f\u6301 %s ;", new Object[]{st}));
                }
                object = null;
                return object;
            }
            try {
                throw new IllegalArgumentException("column must Data type ; \u5b57\u6bb5\u5fc5\u987b\u662fDate\u7c7b\u578b ;");
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public Double getStatisticsValue(StatisticsType functionName, String property, Set<Param> pms) {
        if (property != null && functionName != null) {
            if (this.getCurrentTables().size() < 1) {
                return 0.0;
            }
            try {
                List<Future<QueryVo<ResultSet>>> rzts = this.getFunctionValues(pms, property, functionName);
                ArrayList<Double> rzslist = new ArrayList<Double>();
                for (Future<QueryVo<ResultSet>> f : rzts) {
                    ResultSet rs = f.get().getOv();
                    while (rs.next()) {
                        Double o = rs.getDouble(1);
                        if (o == null) continue;
                        rzslist.add(o);
                    }
                }
                if (rzslist.size() > 0) {
                    Object object;
                    if (rzslist.size() == 1) {
                        object = (Double)rzslist.get(0);
                        return object;
                    }
                    if (StatisticsType.MAX.equals((Object)functionName)) {
                        object = rzslist.parallelStream().max(Comparator.comparing(d -> d)).get();
                        return object;
                    }
                    if (StatisticsType.MIN.equals((Object)functionName)) {
                        object = rzslist.parallelStream().min(Comparator.comparing(d -> d)).get();
                        return object;
                    }
                    if (StatisticsType.SUM.equals((Object)functionName)) {
                        object = rzslist.parallelStream().mapToDouble(i -> i).sum();
                        return object;
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.closeConnection();
            }
        }
        return 0.0;
    }

    private List<Future<QueryVo<ResultSet>>> getFunctionValues(Set<Param> pms, String property, StatisticsType functionName) throws SQLException {
        StringBuffer sb = new StringBuffer(KSentences.SELECT.getValue());
        sb.append((Object)functionName);
        for (PropInfo p : this.getPropInfos()) {
            if (!p.getPname().equals(property.trim())) continue;
            sb.append(KSentences.LEFT_BRACKETS.getValue()).append(p.getCname()).append(KSentences.RIGHT_BRACKETS.getValue()).append((Object)KSentences.FROM);
            break;
        }
        Set<String> tbs = this.getTableNamesByParams(pms);
        List<Future<QueryVo<ResultSet>>> rzts = this.invokeall(true, pms, sb.toString(), tbs);
        return rzts;
    }

    @Override
    public Long getCount(Set<Param> pms, String ... distincts) {
        return this.getCountPerTable(true, pms, distincts);
    }

    @Override
    public Long getCountFromMaster(Set<Param> pms, String ... distincts) {
        return this.getCountPerTable(false, pms, distincts);
    }

    private Long getQvcSum(List<QueryVo<Long>> qvs) {
        if (qvs != null && qvs.size() > 0) {
            if (qvs.size() > 1) {
                return qvs.stream().filter(o -> o.getOv() != null).mapToLong(QueryVo::getOv).sum();
            }
            return qvs.get(0).getOv();
        }
        return 0L;
    }

    private List<Future<QueryVo<ResultSet>>> invokeall(boolean isRead, Set<Param> pms, String sqlselect, Set<String> tbs) throws SQLException {
        Iterator<String> tbnsite = tbs.iterator();
        ArrayList<QueryVo<PreparedStatement>> pss = new ArrayList<QueryVo<PreparedStatement>>();
        String whereSqlByParam = this.getWhereSqlByParam(pms);
        while (tbnsite.hasNext()) {
            String tn = tbnsite.next();
            String sql = sqlselect + tn + whereSqlByParam;
            PreparedStatement statement = this.getPreParedStatement(isRead, pms, sql);
            pss.add(new QueryVo<PreparedStatement>(tn, statement));
        }
        return this.invokeQueryAll(pss);
    }

    private PreparedStatement getPreParedStatement(boolean isRead, Set<Param> pms, String sql) throws SQLException {
        PreparedStatement statement = this.getStatementBySql(isRead, sql);
        this.setWhereSqlParamValue(pms, statement);
        return statement;
    }

    @Override
    public List<POJO> getList(Set<Param> pms, String ... cls) {
        return this.getRztPos(false, true, pms, cls);
    }

    @Override
    public List<POJO> getAll(String ... cls) {
        return this.getRztPos(false, true, null, cls);
    }

    @Override
    public List<POJO> getListFromMater(Set<Param> pms, String ... cls) {
        return this.getRztPos(false, false, pms, cls);
    }

    @Override
    public List<POJO> getList(Set<Param> pms, boolean isDistinct, String ... cls) {
        return this.getRztPos(isDistinct, true, pms, cls);
    }

    @Override
    public List<POJO> getListFromMater(Set<Param> pms, boolean isDistinct, String ... cls) {
        return this.getRztPos(isDistinct, false, pms, cls);
    }

    @Override
    public List<POJO> getListOrderBy(Set<Param> pms, LinkedHashSet<OrderBy> orderbys, String ... cls) {
        if (this.getCurrentTables().size() < 1) {
            return new ArrayList(0);
        }
        return this.getRztPos((Boolean)true, 1, Integer.MAX_VALUE / this.getCurrentTables().size(), orderbys, pms, cls);
    }

    @Override
    public List<POJO> getPageList(int curPage, int pageSize, Set<Param> pms, LinkedHashSet<OrderBy> orderbys, String ... cls) {
        return this.getRztPos((Boolean)true, curPage, pageSize, orderbys, pms, cls);
    }

    @Override
    public List<POJO> getPageListFromMaster(int curPage, int pageSize, Set<Param> pms, LinkedHashSet<OrderBy> orderbys, String ... cls) {
        return this.getRztPos((Boolean)false, curPage, pageSize, orderbys, pms, cls);
    }

    @Override
    public PageData<POJO> getPageInfoFromMaster(Set<Param> pms, int curPage, int pageSize, String ... cls) {
        return this.getListFromNotSorted(false, curPage, pageSize, pms, cls);
    }

    @Override
    public PageData<POJO> getPageInfo(int curPage, int pageSize, Set<Param> pms, String ... cls) {
        return this.getListFromNotSorted(true, curPage, pageSize, pms, cls);
    }

    @Override
    public List<POJO> getPageListFromMaster(int curPage, int pageSize, Set<Param> pms, String ... cls) {
        return this.getListFromNotSorted(false, curPage, pageSize, pms, cls).getDataList();
    }

    @Override
    public List<POJO> getPageList(int curPage, int pageSize, Set<Param> pms, String ... cls) {
        return this.getListFromNotSorted(true, curPage, pageSize, pms, cls).getDataList();
    }

    @Override
    public PageData<Object[]> getGroupPageInfo(int curPage, int pageSize, Set<Param> pms, LinkedHashSet<OrderBy> orderbys, LinkedHashMap<String, String> funs, String ... groupby) {
        Long groupbyCount;
        if (pms == null) {
            pms = new HashSet<Param>();
        }
        if ((groupbyCount = this.getGroupbyCount(new HashSet<Param>(pms), groupby)) > 0L) {
            return new PageData<Object[]>(curPage, pageSize, groupbyCount, this.getGroupPageList(curPage, pageSize, pms, orderbys, funs, groupby));
        }
        return new PageData<Object[]>(curPage, pageSize, groupbyCount, new ArrayList(0));
    }

    @Override
    public Long getGroupbyCount(Set<Param> pms, String ... groupby) {
        return this.groupcount(true, pms, groupby);
    }

    @Override
    public Long getGroupbyCountFromMaster(Set<Param> pms, String ... groupby) {
        return this.groupcount(false, pms, groupby);
    }

    private Set<String> getobfp(Set<Param> pms) {
        if (pms != null) {
            HashSet<String> pps = new HashSet<String>(pms.size());
            for (Param p : pms) {
                if (p.getFunName() == null || !PmType.FUN.equals((Object)p.getCdType())) continue;
                pps.add(p.getPname());
                while (p.getOrParam() != null) {
                    if ((p = p.getOrParam()).getFunName() == null || !PmType.FUN.equals((Object)p.getCdType())) continue;
                    pps.add(p.getPname());
                }
            }
        }
        return Collections.emptySet();
    }

    private Long groupcount(boolean isRead, Set<Param> pms, String ... groupby) {
        if (groupby == null || groupby.length == 0 || this.getCurrentTables().size() < 1) {
            return 0L;
        }
        try {
            Long l;
            ResultSet rs;
            if (pms != null) {
                pms = new HashSet<Param>(pms);
            }
            Set<String> getobfp = this.getobfp(pms);
            Set<String> tbns = this.getTableNamesByParams(pms);
            Set<Param> hvcs = this.gethvconditions(pms);
            String whereSqlByParam = this.getWhereSqlByParam(pms);
            StringBuilder sqlsb = new StringBuilder("SELECT COUNT(1) FROM  (SELECT count(");
            for (PropInfo prop : this.getPropInfos()) {
                if (!prop.getPname().equals(groupby[0].trim())) continue;
                sqlsb.append(prop.getCname());
                break;
            }
            sqlsb.append(")  FROM (");
            Iterator<String> tnite = tbns.iterator();
            while (tnite.hasNext()) {
                String tn = tnite.next();
                sqlsb.append(this.getPreSelectSql(false, this.getGSelect(groupby, getobfp))).append(tn).append(whereSqlByParam);
                if (!tnite.hasNext()) continue;
                sqlsb.append(KSentences.UNION_ALL.getValue());
            }
            String havingSql = this.getHavingSql(hvcs);
            sqlsb.append(")  gdtc  ").append(KSentences.GROUPBY.getValue()).append(this.groupbysql(groupby)).append(havingSql).append(")  ccfd ");
            String sql = sqlsb.toString();
            PreparedStatement statement = this.getStatementBySql(isRead, sql);
            int ix = 1;
            for (String tn : tbns) {
                ix = this.setWhereSqlParamValue(pms, statement, ix);
            }
            this.setWhereSqlParamValue(hvcs, statement, ix);
            if (this.isShowSql) {
                log.error(statement.toString());
            }
            if ((rs = statement.executeQuery()).next()) {
                l = rs.getObject(1, Long.class);
                return l;
            }
            l = 0L;
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private String groupbysql(String[] groupby) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < groupby.length; ++i) {
            String g = groupby[i];
            for (PropInfo p : this.getPropInfos()) {
                if (!p.getPname().equals(g)) continue;
                sb.append(p.getCname());
            }
            if (i >= groupby.length - 1) continue;
            sb.append(KSentences.COMMA.getValue());
        }
        return sb.toString();
    }

    @Override
    public List<Object[]> getGroupPageList(int curPage, int pageSize, Set<Param> pms, LinkedHashSet<OrderBy> orderbys, LinkedHashMap<String, String> funs, String ... groupby) {
        return this.grouplist(true, curPage, pageSize, orderbys, pms, funs, groupby);
    }

    @Override
    public List<Object[]> getGroupPageListFromMaster(int curPage, int pageSize, Set<Param> pms, LinkedHashSet<OrderBy> orderbys, LinkedHashMap<String, String> funs, String ... groupby) {
        return this.grouplist(false, curPage, pageSize, orderbys, pms, funs, groupby);
    }

    private List<Object[]> grouplist(boolean readOnly, int curPage, int pageSize, LinkedHashSet<OrderBy> orderbys, Set<Param> pms, LinkedHashMap<String, String> funs, String ... groupby) {
        try {
            if (curPage < 1 || pageSize < 1 || groupby == null || groupby.length == 0 || this.getCurrentTables().size() < 1) {
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>(0);
                return arrayList;
            }
            if (pms != null) {
                pms = new HashSet<Param>(pms);
            }
            Set<Param> hvcs = this.gethvconditions(pms);
            String whereSqlByParam = this.getWhereSqlByParam(pms);
            StringBuilder grpsql = new StringBuilder(KSentences.SELECT.getValue());
            Set<PropInfo> propInfos = this.getPropInfos();
            if (funs != null && funs.size() > 0) {
                block6: for (Map.Entry<String, String> entry : funs.entrySet()) {
                    for (PropInfo p : propInfos) {
                        if (!p.getPname().equals(entry.getValue())) continue;
                        grpsql.append(entry.getKey().trim().toUpperCase()).append("(").append(p.getCname().trim()).append(")").append(KSentences.COMMA.getValue());
                        continue block6;
                    }
                }
            }
            for (int i = 0; i < groupby.length; ++i) {
                for (PropInfo p : propInfos) {
                    if (!groupby[i].equals(p.getPname())) continue;
                    grpsql.append(p.getCname());
                    break;
                }
                if (i >= groupby.length - 1) continue;
                grpsql.append(KSentences.COMMA.getValue());
            }
            grpsql.append(KSentences.FROM.getValue()).append("(");
            Set<String> tbns = this.getTableNamesByParams(pms);
            String string = this.getPreSelectSql(false, this.getGSelect(groupby, funs != null ? funs.values() : null));
            Iterator<String> tnite = tbns.iterator();
            while (tnite.hasNext()) {
                String tn = tnite.next();
                grpsql.append(string).append(tn).append(whereSqlByParam);
                if (!tnite.hasNext()) continue;
                grpsql.append(KSentences.UNION_ALL.getValue());
            }
            grpsql.append(")  gdt ").append(KSentences.GROUPBY.getValue()).append(this.groupbysql(groupby)).append(this.getHavingSql(hvcs));
            if (orderbys != null && orderbys.size() > 0) {
                grpsql.append(KSentences.ORDERBY.getValue());
                Iterator obite = orderbys.iterator();
                block11: while (obite.hasNext()) {
                    OrderBy ob;
                    block26: {
                        ob = (OrderBy)obite.next();
                        if (ob.getFunName() != null) {
                            Set<Map.Entry<String, String>> ens = funs.entrySet();
                            Iterator<Map.Entry<String, String>> iterator = ens.iterator();
                            while (iterator.hasNext()) {
                                String[] en = iterator.next();
                                if (!en.getValue().equals(ob.getPropertyName())) continue;
                                Optional<PropInfo> propInfoOptional = propInfos.stream().filter(arg_0 -> MyDataSupport.lambda$grouplist$9((Map.Entry)en, arg_0)).findFirst();
                                if (propInfoOptional.isPresent()) {
                                    grpsql.append(((String)en.getKey()).trim().toUpperCase()).append("(").append(propInfoOptional.get().getCname()).append(")");
                                    continue;
                                }
                                throw new IllegalArgumentException(String.format("In %s ,Can not find field %s", this.domainClazz.getSimpleName(), en.getValue()));
                            }
                        } else {
                            for (PropInfo propInfo : this.getPropInfos()) {
                                if (!propInfo.getPname().equals(ob.getPropertyName())) continue;
                                for (String g : groupby) {
                                    if (!g.trim().equals(propInfo.getPname())) continue;
                                    grpsql.append(propInfo.getCname().trim());
                                    break block26;
                                }
                                continue block11;
                            }
                        }
                    }
                    if (ob.getIsDesc().booleanValue()) {
                        grpsql.append(KSentences.DESC.getValue());
                    }
                    if (!obite.hasNext()) continue;
                    grpsql.append(KSentences.COMMA.getValue());
                }
                if (grpsql.lastIndexOf(KSentences.COMMA.getValue()) == grpsql.length() - 1) {
                    grpsql.deleteCharAt(grpsql.length() - 1);
                }
            }
            String selectPagingSql = this.getSingleTableSelectPagingSql(grpsql.toString(), curPage, pageSize);
            PreparedStatement statement = this.getStatementBySql(readOnly, selectPagingSql);
            int ix = 1;
            for (String tn : tbns) {
                ix = this.setWhereSqlParamValue(pms, statement, ix);
            }
            this.setWhereSqlParamValue(hvcs, statement, ix);
            if (this.isShowSql) {
                log.error(statement.toString());
            }
            ResultSet resultSet = statement.executeQuery();
            List<Object[]> list = this.getObjectList(resultSet);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private PreparedStatement getStatementBySql(boolean readOnly, String selectPagingSql) throws SQLException {
        PreparedStatement statement = this.getConnectionManager().getConnection(readOnly).prepareStatement(selectPagingSql);
        statement.setQueryTimeout(360);
        return statement;
    }

    private String getHavingSql(Set<Param> hvcs) {
        if (hvcs.size() > 0) {
            StringBuilder sb = new StringBuilder(KSentences.HAVING.getValue());
            this.geneConditionSql(hvcs, sb);
            return sb.toString();
        }
        return "";
    }

    private Set<Param> gethvconditions(Set<Param> pms) {
        HashSet<Param> hvcs = new HashSet<Param>();
        if (pms != null && pms.size() > 0) {
            Iterator<Param> pmite = pms.iterator();
            while (pmite.hasNext()) {
                Param pm = pmite.next();
                if (pm.getFunName() == null || pm.getFunName().length() <= 0) continue;
                for (PropInfo p : this.getPropInfos()) {
                    if (!p.getPname().equals(pm.getPname())) continue;
                    hvcs.add(pm);
                    pmite.remove();
                }
            }
        }
        return hvcs;
    }

    @Override
    public List<POJO> getAllOrderBy(LinkedHashSet<OrderBy> orderbys, String ... cls) {
        if (this.getCurrentTables().size() < 1) {
            return new ArrayList(0);
        }
        return this.getRztPos((Boolean)true, 1, Integer.MAX_VALUE / this.getCurrentTables().size(), orderbys, null, cls);
    }

    @Override
    public List<POJO> getListByIdsIn(List<Serializable> ids, String ... strings) {
        if (ids != null && ids.size() > 0) {
            Set<PropInfo> pis = this.getPropInfos();
            for (PropInfo fd : pis) {
                if (!fd.getIsPrimarykey().booleanValue()) continue;
                return this.getRztPos(false, true, Param.getParams(new Param(fd.getPname(), ids)), strings);
            }
        }
        return new ArrayList(0);
    }

    @Override
    public List<POJO> getListByParamIn(String propertyName, List<Serializable> vls, String ... cls) {
        if (vls != null && vls.size() > 0) {
            Set<PropInfo> pis = this.getPropInfos();
            for (PropInfo fd : pis) {
                if (!fd.getPname().equals(propertyName)) continue;
                return this.getRztPos(false, true, Param.getParams(new Param(fd.getPname(), vls)), cls);
            }
        }
        return new ArrayList(0);
    }

    private String getPrimaryKeyPname() {
        for (PropInfo fd : this.getPropInfos()) {
            if (!fd.getIsPrimarykey().booleanValue()) continue;
            return fd.getPname();
        }
        String tableName = ConnectionManager.getTbinfo(this.domainClazz).entrySet().iterator().next().getKey();
        String err = String.format("%s not has primary key ; %s \u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e ;", tableName, tableName);
        throw new IllegalStateException(err);
    }

    @Override
    public POJO getById(Serializable id, String ... strings) {
        return this.getObjByid(true, id, strings);
    }

    @Override
    public POJO getByIdFromMaster(Serializable id, String ... strings) {
        return this.getObjByid(false, id, strings);
    }

    protected POJO getObjByid(Boolean isRead, Serializable id, String ... strings) {
        if (id != null) {
            try {
                Map.Entry<String, LinkedHashSet<PropInfo>> tbimp = ConnectionManager.getTbinfo(this.domainClazz).entrySet().iterator().next();
                for (PropInfo fd : tbimp.getValue()) {
                    if (!fd.getIsPrimarykey().booleanValue()) continue;
                    ColumnRule cr = fd.getColumnRule();
                    Set<Param> pms = Param.getParams(new Param(fd.getPname(), Operate.EQ, (Object)id));
                    if (cr != null) {
                        List<POJO> rzlist = this.getSingleObj(isRead, id, tbimp, fd, cr, pms, strings);
                        if (rzlist.size() == 1) {
                            POJO POJO = rzlist.get(0);
                            return POJO;
                        }
                    } else {
                        List<POJO> rzlist = this.getRztPos(false, isRead, pms, strings);
                        if (rzlist.size() == 1) {
                            POJO POJO = rzlist.get(0);
                            return POJO;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
            finally {
                this.closeConnection();
            }
        }
        return null;
    }

    private List<POJO> getSingleObj(Boolean isRead, Serializable id, Map.Entry<String, LinkedHashSet<PropInfo>> tbimp, PropInfo fd, ColumnRule cr, Set<Param> pms, String ... strings) throws SQLException {
        String tableName = MyDataSupport.getTableName(this.getTableMaxIdx(id, fd.getType(), cr), tbimp.getKey());
        if (!this.isContainsTable(tableName)) {
            return new ArrayList(0);
        }
        StringBuilder sb = this.getSelectSql(tableName, strings);
        sb.append(this.getWhereSqlByParam(pms));
        String sql = sb.toString();
        PreparedStatement prepare = this.getStatementBySql(isRead, sql);
        this.setWhereSqlParamValue(pms, prepare);
        if (this.isShowSql) {
            log.error(prepare.toString());
        }
        ResultSet rs = prepare.executeQuery();
        return this.getRztObject(rs, strings);
    }

    @Override
    public POJO getOne(String propertyName, Serializable value, String ... cls) {
        return this.getObj(true, propertyName, value, cls);
    }

    @Override
    public POJO getOneByMaster(String propertyName, Serializable value, String ... cls) {
        return this.getObj(false, propertyName, value, cls);
    }

    private POJO getObj(Boolean isRead, String propertyName, Serializable value, String ... cls) {
        try {
            Map.Entry<String, LinkedHashSet<PropInfo>> tbimp = ConnectionManager.getTbinfo(this.domainClazz).entrySet().iterator().next();
            for (PropInfo fd : tbimp.getValue()) {
                if (!fd.getPname().equals(propertyName)) continue;
                Set<Param> pms = Param.getParams(new Param(fd.getPname(), Operate.EQ, (Object)value));
                if (value != null && fd.getColumnRule() != null) {
                    List<POJO> rzlist = this.getSingleObj(isRead, value, tbimp, fd, fd.getColumnRule(), pms, cls);
                    if (rzlist.size() == 1) {
                        POJO POJO = rzlist.get(0);
                        return POJO;
                    }
                } else {
                    List<POJO> rzlist = this.getRztPos(false, isRead, pms, cls);
                    if (rzlist.size() == 1) {
                        POJO POJO = rzlist.get(0);
                        return POJO;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    @Override
    public POJO getOne(Set<Param> pms, String ... cls) {
        List<POJO> rzlist = this.getRztPos(false, true, pms, cls);
        if (rzlist.size() == 1) {
            return rzlist.get(0);
        }
        return null;
    }

    @Override
    public Integer saveList(List<POJO> pojos) {
        int i = 0;
        if (pojos != null) {
            boolean istransaction = this.getConnectionManager().isTransactioning();
            try {
                if (!istransaction) {
                    this.getConnectionManager().beginTransaction(this.getConnectionManager().isTransReadOnly());
                }
                for (POJO po : pojos) {
                    i += this.persist(po);
                }
                if (!istransaction) {
                    this.getConnectionManager().commitTransaction();
                }
            }
            catch (Throwable e) {
                if (!istransaction) {
                    this.getConnectionManager().rollbackTransaction();
                }
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
            finally {
                this.closeConnection();
            }
        }
        return i;
    }

    @Override
    public Integer save(POJO pojo) {
        int rzc = 0;
        if (pojo != null) {
            try {
                rzc = this.persist(pojo);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
            finally {
                this.closeConnection();
            }
        }
        return rzc;
    }

    protected int persist(POJO pojo) throws IllegalAccessException, SQLException {
        ResultSet rs;
        Field[] fields = this.domainClazz.getDeclaredFields();
        Map.Entry<String, LinkedHashSet<PropInfo>> tbe = ConnectionManager.getTbinfo(this.domainClazz).entrySet().iterator().next();
        Field idkey = this.checkPrimarykey(fields, tbe);
        StringBuilder sb = new StringBuilder(KSentences.INSERT.getValue());
        String tableSharding = this.tableSharding(pojo, fields, tbe.getKey());
        sb.append(tableSharding);
        sb.append("(");
        Iterator clite = tbe.getValue().iterator();
        while (clite.hasNext()) {
            sb.append("`").append(((PropInfo)clite.next()).getCname()).append("`");
            if (!clite.hasNext()) continue;
            sb.append(KSentences.COMMA.getValue());
        }
        sb.append(")  VALUES(");
        for (int i = 0; i < tbe.getValue().size(); ++i) {
            sb.append(KSentences.POSITION_PLACEHOLDER.getValue());
            if (i >= tbe.getValue().size() - 1) continue;
            sb.append(KSentences.COMMA.getValue());
        }
        sb.append(")");
        String insertSql = sb.toString();
        boolean autoincrement = this.isAutoIncrement();
        Connection connection = this.getConnectionManager().getConnection();
        PreparedStatement statement = autoincrement ? connection.prepareStatement(insertSql, 1) : connection.prepareStatement(insertSql);
        this.setParamVal(pojo, fields, (Set<PropInfo>)tbe.getValue(), statement, this.getConnectionManager().getConnection());
        if (this.isShowSql) {
            log.error(statement.toString());
        }
        int cc = statement.executeUpdate();
        if (autoincrement && (rs = statement.getGeneratedKeys()).next()) {
            idkey.setAccessible(true);
            idkey.set(pojo, rs.getLong(1));
        }
        return cc;
    }

    private boolean isAutoIncrement() {
        if ("MySQL".equalsIgnoreCase(this.dataBaseTypeName)) {
            return this.getPropInfos().stream().anyMatch(p -> GenerationType.IDENTITY.equals((Object)p.getGeneratorValueAnnoStrategyVal()) || GenerationType.AUTO.equals((Object)p.getGeneratorValueAnnoStrategyVal()));
        }
        return false;
    }

    private ColumnRule getColumnRule() {
        Field[] fds;
        for (Field fd : fds = this.domainClazz.getDeclaredFields()) {
            ColumnRule crn = fd.getAnnotation(ColumnRule.class);
            if (crn == null) continue;
            return crn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tableSharding(POJO pojo, Field[] fds, String name) throws IllegalAccessException, SQLException {
        for (Field field : fds) {
            ColumnRule columnRule = field.getAnnotation(ColumnRule.class);
            if (columnRule == null) continue;
            field.setAccessible(true);
            if (field.get(pojo) == null) {
                for (PropInfo propInfo : this.getPropInfos()) {
                    Long nextId;
                    if (!MyDataSupport.fieldPropertiesPaired(propInfo, field)) continue;
                    if (!propInfo.getIsPrimarykey().booleanValue()) break;
                    if (GenerationType.TABLE.equals((Object)propInfo.getGeneratorValueAnnoStrategyVal()) && "MySQL".equalsIgnoreCase(this.dataBaseTypeName)) {
                        nextId = this.getNextIdFromIdTable(this.getConnectionManager().getConnection());
                        field.set(pojo, nextId);
                        continue;
                    }
                    if (!this.autoNextVal(propInfo) || !"Oracle".equalsIgnoreCase(this.dataBaseTypeName)) break;
                    nextId = this.getNextVal(this.getConnectionManager().getConnection());
                    field.set(pojo, nextId);
                }
                if (field.get(pojo) == null) {
                    String err = String.format("%s split flag field not be null ; %s \u5207\u5206\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a ;", field.getName(), field.getName());
                    throw new IllegalArgumentException(err);
                }
            }
            long max = this.getTableMaxIdx(field.get(pojo), field.getType(), columnRule);
            Set<String> currentTables = this.getCurrentTables();
            if (currentTables.size() >= this.maxTableCount) {
                String err = String.format("out of range for split table max num %s ; \u8d85\u51fa\u4e86\u8868\u62c6\u5206\u6700\u5927\u6570\u91cf , \u6700\u591a\u53ea\u80fd\u62c6\u5206%s\u4e2a\u8868", this.maxTableCount, this.maxTableCount);
                throw new IllegalStateException(err);
            }
            String ctbname = MyDataSupport.getTableName(max, name);
            if (!this.isExistTable(ctbname)) {
                Object object = FIRST_TABLECREATE;
                synchronized (object) {
                    this.reFreshTables();
                    if (!this.isExistTable(ctbname)) {
                        this.executeCreate(name, ctbname);
                        for (int i = 1; i < this.getMaxIdleTablecount(columnRule); ++i) {
                            this.executeCreate(name, MyDataSupport.getTableName(max + (long)i, name));
                        }
                    }
                }
            }
            return ctbname;
        }
        return name;
    }

    private long getTableMaxIdx(Object fieldObject, Class<?> fieldType, ColumnRule cr) {
        long max = 0L;
        if (fieldType == Long.class) {
            max = MyDataSupport.getTbIdx(Long.valueOf(fieldObject.toString()), cr);
        } else if (fieldType == Integer.class) {
            max = cr.ruleType().equals((Object)RuleType.RANGE) ? (long)Integer.valueOf(fieldObject.toString()).intValue() / cr.value() : (long)Integer.valueOf(fieldObject.toString()).intValue() % cr.value();
        } else if (fieldType == String.class) {
            max = cr.ruleType().equals((Object)RuleType.RANGE) ? (long)Math.abs(fieldObject.toString().hashCode()) / cr.value() : (long)Math.abs(fieldObject.toString().hashCode()) % cr.value();
        } else if (fieldType == Date.class) {
            Date date = (Date)fieldObject;
            if (fieldObject.getClass() != fieldType) {
                date = new Date(date.getTime());
            }
            max = MyDataSupport.getTbIdx(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().toEpochDay(), cr);
        } else if (fieldType == Timestamp.class) {
            Timestamp dt = (Timestamp)fieldObject;
            max = MyDataSupport.getTbIdx(dt.toLocalDateTime().toLocalDate().toEpochDay(), cr);
        } else if (fieldType == LocalDate.class) {
            LocalDate dt = (LocalDate)fieldObject;
            max = MyDataSupport.getTbIdx(dt.toEpochDay(), cr);
        } else if (fieldType == LocalDateTime.class) {
            LocalDateTime dt = (LocalDateTime)fieldObject;
            max = MyDataSupport.getTbIdx(dt.toLocalDate().toEpochDay(), cr);
        } else {
            String err = String.format("%s not support for split , must be int long string or date type ; %s\u7c7b\u578b\u4e0d\u80fd\u7528\u6765\u5bf9\u6570\u636e\u8fdb\u884c\u5207\u5206\uff0c\u8bf7\u4f7f\u7528int\u3001long\u3001string\u3001date\u7c7b\u578b\u7684\u5b57\u6bb5", fieldType, fieldType);
            throw new IllegalStateException(err);
        }
        return max;
    }

    private static long getTbIdx(long tv, ColumnRule crn) {
        if (crn.ruleType().equals((Object)RuleType.RANGE)) {
            return tv / crn.value();
        }
        return tv % crn.value();
    }

    private void executeCreate(String name, String ctbname) throws SQLException {
        this.reFreshTables();
        if (!this.isExistTable(ctbname)) {
            boolean create;
            if ("MySQL".equalsIgnoreCase(this.dataBaseTypeName)) {
                String sql = KSentences.CREATE_TABLE.getValue() + ctbname + (Object)((Object)KSentences.LIKE) + name;
                this.getConnectionManager().getConnection().prepareStatement(sql).executeUpdate();
                if (this.isShowSql) {
                    log.info(sql);
                }
                this.getCurrentTables().add(ctbname);
            } else if ("Oracle".equalsIgnoreCase(this.dataBaseTypeName) && (create = this.createTableBySql(ctbname))) {
                this.getCurrentTables().add(ctbname);
            }
        }
    }

    private Field checkPrimarykey(Field[] fields, Map.Entry<String, LinkedHashSet<PropInfo>> tbe) {
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            return field;
        }
        String table = tbe.getKey();
        String err = String.format("%s not has primary key field ; %s \u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e ;", table, table);
        throw new IllegalStateException(err);
    }

    private int setUpdateNewValues(Map<String, Object> newValues, PreparedStatement statement) throws SQLException {
        Iterator<Map.Entry<String, Object>> ite = newValues.entrySet().iterator();
        int i = 1;
        while (ite.hasNext()) {
            Map.Entry<String, Object> next = ite.next();
            statement.setObject(i++, this.getParamSqlValue(next.getValue(), next.getKey()));
        }
        return i;
    }

    private int deleteByCondition(Set<Param> pms) {
        if (this.getCurrentTables().size() < 1) {
            return 0;
        }
        try {
            Set<String> tbns = this.getTableNamesByParams(pms);
            String whereSqlByParam = this.getWhereSqlByParam(pms);
            int ttc = 0;
            for (String tn : tbns) {
                String sql = KSentences.DELETE_FROM.getValue() + tn + whereSqlByParam;
                PreparedStatement statement = this.getStatementBySql(false, sql);
                this.setWhereSqlParamValue(pms, statement);
                if (this.isShowSql) {
                    log.error(statement.toString());
                }
                ttc += statement.executeUpdate();
            }
            int n = ttc;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private static boolean fieldPropertiesPaired(PropInfo propInfo, Field field) {
        Column clm = field.getAnnotation(Column.class);
        return clm == null || clm.name().trim().length() < 1 ? propInfo.getCname().equalsIgnoreCase(field.getName()) : clm.name().equalsIgnoreCase(propInfo.getCname());
    }

    private void setParamVal(POJO pojo, Field[] fds, Set<PropInfo> clset, PreparedStatement statement, Connection conn) throws SQLException, IllegalAccessException {
        int idx = 0;
        block0: for (PropInfo zd : clset) {
            ++idx;
            for (Field fd : fds) {
                if (!MyDataSupport.fieldPropertiesPaired(zd, fd)) continue;
                this.setParameter(pojo, statement, conn, idx, zd, fd);
                continue block0;
            }
        }
    }

    private void setParameter(POJO pojo, PreparedStatement statement, Connection conn, int index, PropInfo propInfo, Field field) throws IllegalAccessException, SQLException {
        Object vl = this.getPropValue(pojo, field);
        if (field.getType().isEnum()) {
            if (vl == null) {
                statement.setObject(index, null);
            } else {
                Class<?> cls = field.getType();
                if (field.isAnnotationPresent(Enumerated.class) && field.getAnnotation(Enumerated.class).value() == EnumType.STRING) {
                    statement.setObject(index, vl.toString());
                } else {
                    statement.setObject(index, ((Enum)Enum.valueOf(cls, vl.toString())).ordinal());
                }
            }
        } else if (vl == null && propInfo.getIsPrimarykey().booleanValue()) {
            if (GenerationType.TABLE.equals((Object)propInfo.getGeneratorValueAnnoStrategyVal()) && "MySQL".equalsIgnoreCase(this.dataBaseTypeName)) {
                Long nextId = this.getNextIdFromIdTable(conn);
                statement.setObject(index, nextId);
                field.set(pojo, nextId);
            } else if (this.autoNextVal(propInfo) && "Oracle".equalsIgnoreCase(this.dataBaseTypeName)) {
                Long nextId = this.getNextVal(conn);
                statement.setObject(index, nextId);
                field.set(pojo, nextId);
            } else {
                statement.setObject(index, vl);
            }
        } else if (vl != null && "Oracle".equalsIgnoreCase(this.dataBaseTypeName) && (propInfo.getType() == Date.class || propInfo.getType().getSuperclass() == Date.class)) {
            Date dt = (Date)vl;
            statement.setTimestamp(index, new Timestamp(dt.getTime()));
        } else {
            if (propInfo.getVersion().booleanValue() && vl == null) {
                vl = 1L;
                try {
                    field.setAccessible(true);
                    field.set(pojo, vl);
                }
                catch (Exception e) {
                    String error = "set new value to @Version type error";
                    throw new IllegalArgumentException(error);
                }
            }
            statement.setObject(index, vl);
        }
    }

    private Object getPropValue(POJO pojo, Field fd) {
        try {
            fd.setAccessible(true);
            Object vl = fd.get(pojo);
            return vl;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    private Long getNextVal(Connection conn) throws SQLException {
        String seqName = this.getSequenceName(this.firstTableName);
        ResultSet rs = conn.prepareStatement(String.format("SELECT  %s.%s   FROM  dual", seqName, "nextval")).executeQuery();
        if (rs.next()) {
            return rs.getLong(1);
        }
        return null;
    }

    private Long getNextIdFromIdTable(Connection conn) throws SQLException {
        String idTableName = this.getIdTableName(this.firstTableName);
        String insertIdtable = this.genInsertIdTableSql(idTableName, "NULL");
        PreparedStatement idstatement = conn.prepareStatement(insertIdtable, 1);
        idstatement.executeUpdate();
        ResultSet rs = idstatement.getGeneratedKeys();
        if (rs.next()) {
            return rs.getLong(1);
        }
        return null;
    }

    @Override
    public List<Object> getVList(String property, Set<Param> params) {
        return this.getRztPos(property, params, true, false);
    }

    @Override
    public List<Object> getVListFromMaster(String property, Set<Param> params) {
        return this.getRztPos(property, params, false, false);
    }

    @Override
    public List<Object> getVList(String property, Set<Param> params, boolean isDistinct) {
        return this.getRztPos(property, params, true, isDistinct);
    }

    @Override
    public List<Object> getVListFromMaster(String property, Set<Param> params, boolean isDistinct) {
        return this.getRztPos(property, params, false, isDistinct);
    }

    private List<Object> getRztPos(String property, Set<Param> params, boolean isRead, boolean isDistinct) {
        if (this.getCurrentTables().size() < 1) {
            return new ArrayList<Object>(0);
        }
        try {
            List<Object> querylist;
            String selectpre = this.getPreSelectSql(isDistinct, property);
            String whereSqlByParam = this.getWhereSqlByParam(params);
            Set<String> tbns = this.getTableNamesByParams(params);
            if (tbns.size() == 1) {
                List<Object> list = this.getSingleObject(isRead, selectpre + tbns.iterator().next() + whereSqlByParam, params);
                return list;
            }
            List<QueryVo<PreparedStatement>> pss = this.getqvs(isRead, params, selectpre, whereSqlByParam, tbns);
            List<Object> list = querylist = this.querylist(pss);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private List<POJO> getRztPos(boolean isDistinct, boolean isRead, Set<Param> params, String ... strings) {
        if (this.getCurrentTables().size() < 1) {
            return new ArrayList(0);
        }
        try {
            List<POJO> querylist;
            String selectpre = this.getPreSelectSql(isDistinct, strings);
            String whereSqlByParam = this.getWhereSqlByParam(params);
            Set<String> tbns = this.getTableNamesByParams(params);
            if (tbns.size() == 1) {
                List<POJO> list = this.getSingleObject(isRead, params, selectpre + tbns.iterator().next() + whereSqlByParam, strings);
                return list;
            }
            List<QueryVo<PreparedStatement>> pss = this.getqvs(isRead, params, selectpre, whereSqlByParam, tbns);
            List<POJO> list = querylist = this.querylist(pss, strings);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private List<QueryVo<PreparedStatement>> getqvs(boolean isRead, Set<Param> params, String selectpre, String whereSqlByParam, Set<String> tbns) throws SQLException {
        ArrayList<QueryVo<PreparedStatement>> pss = new ArrayList<QueryVo<PreparedStatement>>();
        for (String tn : tbns) {
            String sql = selectpre + tn + whereSqlByParam;
            PreparedStatement statement = this.getStatementBySql(isRead, sql);
            this.setWhereSqlParamValue(params, statement);
            if (this.isShowSql) {
                log.error(statement.toString());
            }
            pss.add(new QueryVo<PreparedStatement>(tn, statement));
        }
        return pss;
    }

    @Override
    public PageData<POJO> getPageInfo(int curPage, int pageSize, Set<Param> params, LinkedHashSet<OrderBy> orderbys, String ... strings) {
        Long count = this.getCount(params, new String[0]);
        if (count > 0L) {
            return new PageData<POJO>(curPage, pageSize, count, this.getRztPos((Boolean)true, curPage, pageSize, orderbys, params, strings));
        }
        return new PageData(curPage, pageSize, count, new ArrayList(0));
    }

    @Override
    public PageData<POJO> getPageInfoFromMaster(int curPage, int pageSize, Set<Param> params, LinkedHashSet<OrderBy> orderbys, String ... strings) {
        Long count = this.getCountFromMaster(params, new String[0]);
        if (count > 0L) {
            return new PageData<POJO>(curPage, pageSize, count, this.getRztPos((Boolean)false, curPage, pageSize, orderbys, params, strings));
        }
        return new PageData(curPage, pageSize, count, new ArrayList(0));
    }

    private String getSelectPagingSql(String sql, int curPage, int pageSize) {
        if (this.dataBaseTypeName.equalsIgnoreCase("MySQL")) {
            return sql + this.getPagingSql(curPage, pageSize);
        }
        if (this.dataBaseTypeName.equalsIgnoreCase("Oracle")) {
            StringBuilder sb = new StringBuilder("select  row_.*,   rownum  rownum_      from (");
            sb.append(sql);
            sb.append(")  row_  where    rownum <=");
            sb.append(curPage * pageSize);
            return sb.toString();
        }
        String err = String.format("current page router not support %s database ; \u5f53\u524d\u67e5\u8be2\u5206\u9875\u8def\u7531\u4e0d\u652f\u6301%s\u6570\u636e\u5e93\u7cfb\u7edf ;", this.dataBaseTypeName, this.dataBaseTypeName);
        throw new IllegalStateException(err);
    }

    private String getSingleTableSelectPagingSql(String sql, int curPage, int pageSize) {
        if (this.dataBaseTypeName.equalsIgnoreCase("MySQL")) {
            return sql + this.getSingleTablePagingSql(curPage, pageSize);
        }
        if (this.dataBaseTypeName.equalsIgnoreCase("Oracle")) {
            return this.oraclepageselect(sql, curPage, pageSize);
        }
        String err = String.format("current page router not support %s database ; \u5f53\u524d\u67e5\u8be2\u5206\u9875\u8def\u7531\u4e0d\u652f\u6301%s\u6570\u636e\u5e93\u7cfb\u7edf ;", this.dataBaseTypeName, this.dataBaseTypeName);
        throw new IllegalStateException(err);
    }

    private String getSingleTableSelectPagingSqlByStartIndex(int start, String sql, int pageSize) {
        if (this.dataBaseTypeName.equalsIgnoreCase("MySQL")) {
            return sql + this.getSinglePagingSql(start, pageSize);
        }
        if (this.dataBaseTypeName.equalsIgnoreCase("Oracle")) {
            return this.getoracleSinglepagingSelectsql(start, sql, pageSize);
        }
        String err = String.format("current page router not support %s database ; \u5f53\u524d\u67e5\u8be2\u5206\u9875\u8def\u7531\u4e0d\u652f\u6301%s\u6570\u636e\u5e93\u7cfb\u7edf ;", this.dataBaseTypeName, this.dataBaseTypeName);
        throw new IllegalStateException(err);
    }

    private String oraclepageselect(String sql, int curPage, int pageSize) {
        StringBuilder sb = new StringBuilder("SELECT * FROM ( select row_.*, rownum rownum_ from (");
        sb.append(sql);
        sb.append(") row_ where rownum <=");
        sb.append(curPage * pageSize);
        sb.append(" ) WHERE rownum_ > ").append((curPage - 1) * pageSize);
        return sb.toString();
    }

    private String getoracleSinglepagingSelectsql(int start, String sql, int pageSize) {
        if (start < 0 || pageSize < 1) {
            throw new IllegalArgumentException("start can not lt 0 , page size can not lt 1 ; \u5f00\u59cb\u4f4d\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0,\u9875\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e1 ;");
        }
        StringBuilder sb = new StringBuilder("SELECT * FROM ( select  row_.*, rownum rownum_ from (");
        sb.append(sql);
        sb.append(") row_ where rownum <=");
        sb.append(start + pageSize);
        sb.append(" ) WHERE rownum_ > ").append(start);
        return sb.toString();
    }

    private List<POJO> getRztPos(Boolean isRead, int curPage, int pageSize, LinkedHashSet<OrderBy> orderbys, Set<Param> params, String ... strings) {
        if (curPage < 1 || pageSize < 1 || this.getCurrentTables().size() < 1) {
            return new ArrayList(0);
        }
        Set<String> tbns = this.getTableNamesByParams(params);
        if (tbns.size() > 1 && (orderbys == null || orderbys.isEmpty())) {
            return this.getListFromNotSorted(isRead, curPage, pageSize, params, strings).getDataList();
        }
        try {
            List<POJO> list;
            String selectpre = this.getPreSelectSql(false, strings);
            String whereSqlByParam = this.getWhereSqlByParam(params);
            String orderBySql = this.getOrderBySql(orderbys);
            if (tbns.size() == 1) {
                String sql = this.getSingleTableSelectPagingSql(selectpre + tbns.iterator().next() + whereSqlByParam + orderBySql, curPage, pageSize);
                List<POJO> list2 = this.getSingleObject(isRead, params, sql, strings);
                return list2;
            }
            ArrayList<QueryVo<PreparedStatement>> pss = new ArrayList<QueryVo<PreparedStatement>>();
            for (String tn : tbns) {
                String sql = this.getSelectPagingSql(selectpre + tn + whereSqlByParam + orderBySql, curPage, pageSize);
                PreparedStatement statement = this.getStatementBySql(isRead, sql);
                this.setWhereSqlParamValue(params, statement);
                pss.add(new QueryVo<PreparedStatement>(tn, statement));
            }
            List<POJO> querylist = this.querylist(pss, strings);
            if (querylist.size() > 1) {
                list = this.getOrderbyPagelist(curPage, pageSize, querylist, this.addsortinfo(orderbys, strings));
                return list;
            }
            list = querylist;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private List<Object> getSingleObject(Boolean isRead, String sql, Set<Param> params) throws SQLException {
        PreparedStatement statement = this.getStatementBySql(isRead, sql);
        this.setWhereSqlParamValue(params, statement);
        if (this.isShowSql) {
            log.error(statement.toString());
        }
        return this.getRztObject(statement.executeQuery());
    }

    private List<POJO> getSingleObject(Boolean isRead, Set<Param> params, String sql, String ... strings) throws SQLException {
        PreparedStatement statement = this.getStatementBySql(isRead, sql);
        this.setWhereSqlParamValue(params, statement);
        if (this.isShowSql) {
            log.error(statement.toString());
        }
        return this.getRztObject(statement.executeQuery(), strings);
    }

    private PageData<POJO> getListFromNotSorted(Boolean isRead, int curPage, int pageSize, Set<Param> params, String ... strings) {
        try {
            String selectpre = this.getPreSelectSql(false, strings);
            String whereSqlByParam = this.getWhereSqlByParam(params);
            ArrayList<QueryVo<PreparedStatement>> pss = new ArrayList<QueryVo<PreparedStatement>>();
            Set<String> tbs = this.getTableNamesByParams(params);
            List<QueryVo<Long>> qvs = this.getMultiTableCount(isRead, params, tbs);
            long totalCount = qvs.stream().mapToLong(QueryVo::getOv).sum();
            if (totalCount < 1L) {
                PageData pageData = new PageData(curPage, pageSize, totalCount, new ArrayList(0));
                return pageData;
            }
            int start = this.getPageStartIndex(curPage, pageSize);
            int csum = 0;
            int rdsum = 0;
            for (QueryVo<Long> q : qvs) {
                int step;
                int initSize;
                csum = (int)((long)csum + q.getOv());
                if (rdsum >= pageSize) break;
                if (csum <= start) continue;
                int startindex = 0;
                int left = pageSize - rdsum;
                int n = initSize = q.getOv().intValue() > left ? left : q.getOv().intValue();
                if (start > 0 && (step = csum - start) < q.getOv().intValue()) {
                    startindex = q.getOv().intValue() - step;
                    if (step < pageSize) {
                        initSize = step;
                    }
                }
                rdsum += initSize;
                String sql = this.getSingleTableSelectPagingSqlByStartIndex(startindex, selectpre + q.getTbn() + whereSqlByParam, initSize);
                PreparedStatement statement = this.getStatementBySql(isRead, sql);
                this.setWhereSqlParamValue(params, statement);
                pss.add(new QueryVo<PreparedStatement>(q.getTbn(), statement));
            }
            PageData<POJO> pageData = new PageData<POJO>(curPage, pageSize, totalCount, this.querylist(pss, strings));
            return pageData;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private int getPageStartIndex(int curPage, int pageSize) {
        int start = (curPage - 1) * pageSize;
        return start;
    }

    private LinkedHashSet<SortInfo> addsortinfo(LinkedHashSet<OrderBy> orderbys, String ... strings) {
        LinkedHashSet<SortInfo> sts = new LinkedHashSet<SortInfo>();
        if (orderbys != null && orderbys.size() > 0) {
            List<String> asList = Arrays.asList(strings);
            for (OrderBy ob : orderbys) {
                if (strings != null && strings.length > 0 && asList.contains(ob.getPropertyName())) {
                    sts.add(new SortInfo(ob.getPropertyName(), ob.getIsDesc()));
                    continue;
                }
                sts.add(new SortInfo(ob.getPropertyName(), ob.getIsDesc()));
            }
        }
        return sts;
    }

    private static boolean isArrayEffective(String ... distincts) {
        return distincts != null && distincts.length > 0 && distincts[0].trim().length() > 0;
    }

    private Long getCountPerTable(Boolean isRead, Set<Param> params, String ... distincts) {
        try {
            Long l;
            ResultSet rs;
            Set<String> tbs = this.getTableNamesByParams(params);
            if (tbs.size() > 1) {
                if (MyDataSupport.isArrayEffective(distincts)) {
                    Long l2 = this.groupcount(isRead, params, distincts);
                    return l2;
                }
                Long l3 = this.getQvcSum(this.getMultiTableCount(isRead, params, tbs));
                return l3;
            }
            StringBuilder sb = new StringBuilder(KSentences.SELECT.getValue());
            sb.append(KSentences.COUNT.getValue());
            sb.append(KSentences.LEFT_BRACKETS.getValue());
            if (MyDataSupport.isArrayEffective(distincts)) {
                sb.append(KSentences.DISTINCT.getValue());
                for (int i = 0; i < distincts.length; ++i) {
                    String ps = distincts[i];
                    for (PropInfo p : this.getPropInfos()) {
                        if (!p.getPname().equals(ps.trim())) continue;
                        sb.append(p.getCname());
                        break;
                    }
                    if (i >= distincts.length - 1) continue;
                    sb.append(KSentences.COMMA.getValue());
                }
            } else {
                sb.append("*");
            }
            sb.append(KSentences.RIGHT_BRACKETS.getValue()).append(KSentences.FROM.getValue()).append(tbs.iterator().next());
            sb.append(this.getWhereSqlByParam(params));
            String sql = sb.toString();
            PreparedStatement statement = this.getPreParedStatement(isRead, params, sql);
            if (this.isShowSql) {
                log.error(statement.toString());
            }
            if ((rs = statement.executeQuery()).next()) {
                l = rs.getLong(1);
                return l;
            }
            l = 0L;
            return l;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void update(POJO po) {
        String primaryKeyName = this.getPrimaryKeyPname();
        Set<PropInfo> propInfos = this.getPropInfos();
        HashSet<Param> pms = new HashSet<Param>(1);
        HashMap<String, Object> newValues = new HashMap<String, Object>(propInfos.size());
        Field[] fds = this.domainClazz.getDeclaredFields();
        Object id = null;
        boolean version = false;
        String versionPname = null;
        Long oldVersion = null;
        for (PropInfo propInfo : propInfos) {
            for (Field field : fds) {
                if (!MyDataSupport.fieldPropertiesPaired(propInfo, field)) continue;
                Object propValue = this.getPropValue(po, field);
                if (propInfo.getPname().equals(primaryKeyName)) {
                    if (propValue != null) {
                        id = propValue;
                        pms.add(new Param(propInfo.getPname(), Operate.EQ, id));
                        continue;
                    }
                    throw new IllegalArgumentException("primary key not null ; \u4e3b\u952e\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a ;");
                }
                if (propInfo.getVersion().booleanValue()) {
                    version = true;
                    versionPname = propInfo.getPname();
                    pms.add(new Param(versionPname, Operate.EQ, propValue));
                    oldVersion = Long.parseLong(propValue.toString());
                    if (oldVersion == null) {
                        oldVersion = 0L;
                    }
                    Long newVersion = oldVersion + 1L;
                    newValues.put(versionPname, newVersion);
                    try {
                        field.setAccessible(true);
                        field.set(po, newVersion);
                        continue;
                    }
                    catch (Exception e) {
                        String error = "set new value to @Version type error";
                        throw new IllegalArgumentException(error);
                    }
                }
                newValues.put(propInfo.getPname(), propValue);
            }
        }
        try {
            if (newValues != null && newValues.size() > 0) {
                POJO pojo;
                Set<String> tableNames = this.getTableNamesByParams(pms);
                Set<PropInfo> pps = this.getPropInfos();
                int ttc = 0;
                boolean isShowSqled = false;
                for (String tableName : tableNames) {
                    StringBuilder buf = new StringBuilder(KSentences.UPDATE.getValue());
                    buf.append(tableName).append(KSentences.SET.getValue());
                    Iterator it = newValues.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        for (PropInfo p : pps) {
                            if (!p.getPname().equals(entry.getKey())) continue;
                            buf.append("`").append(p.getCname()).append("`").append(KSentences.EQ.getValue()).append(KSentences.POSITION_PLACEHOLDER.getValue());
                            if (!it.hasNext()) continue;
                            buf.append(KSentences.COMMA.getValue());
                        }
                    }
                    buf.append(this.getWhereSqlByParam(pms));
                    String sql = buf.toString();
                    PreparedStatement statement = this.getStatementBySql(false, sql);
                    int i = this.setUpdateNewValues(newValues, statement);
                    this.setWhereSqlParamValue(pms, statement, i);
                    if (this.isShowSql) {
                        log.error(statement.toString());
                    }
                    ttc += statement.executeUpdate();
                }
                if (version && ttc == 0 && (pojo = this.getById((Serializable)id, primaryKeyName, versionPname)) != null) {
                    Field nowVersionField = pojo.getClass().getDeclaredField(versionPname);
                    nowVersionField.setAccessible(true);
                    Long nowVersion = Long.parseLong(nowVersionField.get(pojo).toString());
                    if (!oldVersion.equals(nowVersion)) {
                        String errorMsg = "Current Version Is " + oldVersion + ",But The New Version Is " + nowVersion + ",So Changes Cannot Be Performed In Different Versions.";
                        throw new ObjectOptimisticLockingFailureException(errorMsg);
                    }
                }
            }
        }
        catch (ObjectOptimisticLockingFailureException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    private List<QueryVo<Long>> getMultiTableCount(Boolean isRead, Set<Param> params, Set<String> tbs) throws SQLException, InterruptedException, ExecutionException {
        ArrayList<QueryVo<Long>> qvs = new ArrayList<QueryVo<Long>>();
        List<Future<QueryVo<ResultSet>>> rzts = this.invokeall(isRead, params, KSentences.SELECT_COUNT.getValue(), tbs);
        for (Future<QueryVo<ResultSet>> f : rzts) {
            long cc;
            ResultSet rs = f.get().getOv();
            if (!rs.next() || (cc = rs.getLong(1)) <= 0L) continue;
            qvs.add(new QueryVo<Long>(f.get().getTbn(), cc));
        }
        if (qvs.size() > 1) {
            qvs.sort(new Comparator<QueryVo<Long>>(){

                @Override
                public int compare(QueryVo<Long> o1, QueryVo<Long> o2) {
                    return o2.getTbn().compareTo(o1.getTbn());
                }
            });
        }
        return qvs;
    }

    private <T> List<T> getOrderbyPagelist(int curPage, int pageSize, List<T> querylist, LinkedHashSet<SortInfo> sts) {
        int fromIndex;
        int toIndex;
        if (sts != null && sts.size() > 0) {
            querylist.sort(new SortComparator(sts));
        }
        if ((toIndex = (fromIndex = this.getPageStartIndex(curPage, pageSize)) + pageSize) > querylist.size()) {
            toIndex = querylist.size();
        }
        if (fromIndex >= toIndex) {
            return new ArrayList(0);
        }
        return querylist.subList(fromIndex, toIndex);
    }

    private String getOrderBySql(LinkedHashSet<OrderBy> orderbys) {
        StringBuilder sb = new StringBuilder();
        if (orderbys != null && orderbys.size() > 0) {
            sb.append(KSentences.ORDERBY.getValue());
            Iterator ite = orderbys.iterator();
            while (ite.hasNext()) {
                OrderBy ob = (OrderBy)ite.next();
                for (PropInfo p : this.getPropInfos()) {
                    if (!p.getPname().equals(ob.getPropertyName().trim())) continue;
                    if (ob.getFunName() != null && ob.getFunName().trim().length() > 0) {
                        sb.append(ob.getFunName());
                        sb.append("(");
                        sb.append(p.getCname());
                        sb.append(")");
                    } else {
                        sb.append("`").append(p.getCname()).append("`");
                    }
                    if (ob.getIsDesc().booleanValue()) {
                        sb.append(KSentences.DESC.getValue());
                    }
                    if (!ite.hasNext()) continue;
                    sb.append(KSentences.COMMA.getValue());
                }
            }
        }
        return sb.toString();
    }

    private String getPagingSql(int curPage, int pageSize) {
        if (curPage < 1 || pageSize < 1) {
            throw new IllegalArgumentException("current page num and view num not lt 0 ; \u5f53\u524d\u9875\u548c\u9875\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e0 ;");
        }
        StringBuilder sb = new StringBuilder(KSentences.LIMIT.getValue());
        sb.append(curPage * pageSize);
        return sb.toString();
    }

    private String getSingleTablePagingSql(int curPage, int pageSize) {
        if (curPage < 1 || pageSize < 1) {
            throw new IllegalArgumentException("current page num and view num not lt 0 ; \u5f53\u524d\u9875\u548c\u9875\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e0 ;");
        }
        StringBuilder sb = new StringBuilder(KSentences.LIMIT.getValue());
        sb.append((curPage - 1) * pageSize);
        sb.append(KSentences.COMMA.getValue()).append(pageSize);
        return sb.toString();
    }

    private String getSinglePagingSql(int start, int pageSize) {
        if (start < 0 || pageSize < 1) {
            throw new IllegalArgumentException("start can not lt 0 , page size can not lt 1 ; \u5f00\u59cb\u4f4d\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0,\u9875\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e1 ;");
        }
        StringBuilder sb = new StringBuilder(KSentences.LIMIT.getValue());
        sb.append(start);
        sb.append(KSentences.COMMA.getValue()).append(pageSize);
        return sb.toString();
    }

    private List<Object> querylist(List<QueryVo<PreparedStatement>> pss) throws InterruptedException, ExecutionException {
        if (pss != null && pss.size() > 0) {
            List<Future<QueryVo<ResultSet>>> rzs = this.invokeQueryAll(pss);
            ArrayList<Object> pos = new ArrayList<Object>();
            for (Future<QueryVo<ResultSet>> f : rzs) {
                pos.addAll(this.getRztObject(f.get().getOv()));
            }
            return pos;
        }
        return new ArrayList<Object>(0);
    }

    private List<POJO> querylist(List<QueryVo<PreparedStatement>> pss, String ... strings) throws InterruptedException, ExecutionException {
        if (pss != null && pss.size() > 0) {
            List<Future<QueryVo<ResultSet>>> rzs = this.invokeQueryAll(pss);
            ArrayList<POJO> pos = new ArrayList<POJO>();
            for (Future<QueryVo<ResultSet>> f : rzs) {
                try {
                    pos.addAll(this.getRztObject(f.get().getOv(), strings));
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return pos;
        }
        return new ArrayList(0);
    }

    private List<Object[]> getObjectList(ResultSet resultSet) throws SQLException {
        ArrayList<Object[]> objs = new ArrayList<Object[]>();
        while (resultSet.next()) {
            int columnCount = resultSet.getMetaData().getColumnCount();
            Object[] os = new Object[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                os[i - 1] = resultSet.getObject(i);
            }
            objs.add(os);
        }
        return objs;
    }

    private List<Future<QueryVo<ResultSet>>> invokeQueryAll(List<QueryVo<PreparedStatement>> pss) {
        ArrayList<QueryCallable> qcs = new ArrayList<QueryCallable>();
        for (QueryVo<PreparedStatement> ps : pss) {
            PreparedStatement preparedStatement = ps.getOv();
            if (this.isShowSql) {
                log.error(preparedStatement.toString());
            }
            qcs.add(new QueryCallable(preparedStatement, ps.getTbn()));
        }
        try {
            return NEW_FIXED_THREAD_POOL.invokeAll(qcs);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    private List<Object> getRztObject(ResultSet rs) {
        try {
            ArrayList<Object> ts = new ArrayList<Object>();
            while (rs.next()) {
                ts.add(rs.getObject(1));
            }
            return ts;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    protected List<POJO> getRztObject(ResultSet rs, String ... strings) {
        ArrayList<POJO> pos = new ArrayList<POJO>();
        try {
            Set<PropInfo> pis = this.getPropInfos();
            while (rs.next()) {
                Field fd;
                int i;
                POJO po = this.domainClazz.newInstance();
                if (strings != null && strings.length > 0) {
                    block3: for (i = 0; i < strings.length; ++i) {
                        for (PropInfo pi : pis) {
                            if (!pi.getPname().equals(strings[i])) continue;
                            fd = this.domainClazz.getDeclaredField(strings[i]);
                            this.setPoValue(rs, po, i, fd);
                            continue block3;
                        }
                    }
                } else {
                    block5: for (i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                        for (PropInfo pi : pis) {
                            if (!pi.getCname().equalsIgnoreCase(rs.getMetaData().getColumnName(i + 1))) continue;
                            fd = this.domainClazz.getDeclaredField(pi.getPname());
                            this.setPoValue(rs, po, i, fd);
                            continue block5;
                        }
                    }
                }
                pos.add(po);
            }
            return pos;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    private void setPoValue(ResultSet rs, POJO po, int i, Field fd) throws SQLException, IllegalAccessException {
        Object objectv = this.getRzVl(rs, i, fd);
        MyObjectUtils.setObjectValue(fd, objectv, po);
    }

    private Object getRzVl(ResultSet rs, int i, Field fd) throws SQLException {
        Object objectv = fd.getType() == Date.class || fd.getType().getSuperclass() == Date.class ? rs.getTimestamp(i + 1) : rs.getObject(i + 1);
        return objectv;
    }

    protected String getWhereSqlByParam(Set<Param> pms) {
        StringBuilder sb = new StringBuilder();
        if (pms != null && pms.size() > 0) {
            sb.append(KSentences.WHERE.getValue());
            this.geneConditionSql(pms, sb);
        }
        return sb.toString();
    }

    private void geneConditionSql(Set<Param> pms, StringBuilder sb) {
        Iterator<Param> pmsite = pms.iterator();
        while (pmsite.hasNext()) {
            boolean isor;
            Param pm = pmsite.next();
            if (pm.getPname() == null || pm.getPname().trim().length() <= 0) continue;
            boolean bl = isor = pm.getOrParam() != null;
            if (isor) {
                sb.append("(");
            }
            do {
                for (PropInfo p : this.getPropInfos()) {
                    if (!p.getPname().equals(pm.getPname())) continue;
                    if (pm.getCdType().equals((Object)PmType.OG)) {
                        this.setogcds(sb, pm, p);
                        continue;
                    }
                    this.setvlcds(sb, pm, p);
                }
                if ((pm = pm.getOrParam()) == null) continue;
                sb.append(KSentences.OR.getValue());
            } while (pm != null);
            if (isor) {
                sb.append(")");
            }
            if (!pmsite.hasNext()) continue;
            sb.append(KSentences.AND.getValue());
        }
    }

    private void setogcds(StringBuilder sb, Param pm, PropInfo p) {
        this.setcName(sb, pm, p);
        if (pm.getOperators().equals((Object)Operate.BETWEEN)) {
            sb.append(pm.getOperators().getValue());
            sb.append(pm.getFirstValue());
            sb.append((Object)KSentences.AND);
            sb.append(pm.getValue());
        } else if (pm.getOperators().equals((Object)Operate.IN) || pm.getOperators().equals((Object)Operate.NOT_IN) && pm.getInValue() != null) {
            sb.append(pm.getOperators().getValue());
            sb.append("(");
            sb.append(pm.getValue());
            sb.append(")");
        } else if (pm.getValue() != null && !pm.getValue().toString().trim().equals("")) {
            sb.append(pm.getOperators().getValue()).append(pm.getValue());
        } else {
            throw new IllegalArgumentException("CdType.OG type param can not bank ; \u975e\u6cd5\u7684\u6761\u4ef6\u67e5\u8be2,CdType.OG\u7c7b\u578b\u7684\u6761\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a ;");
        }
    }

    private void setvlcds(StringBuilder sb, Param pm, PropInfo p) {
        if (pm.getOperators().equals((Object)Operate.BETWEEN)) {
            if (pm.getFirstValue() == null || pm.getValue() == null) {
                throw new IllegalArgumentException(String.format("%s BETWEEN param value is not null  ! ", pm.getPname()));
            }
            this.setcName(sb, pm, p);
            sb.append(pm.getOperators().getValue());
            sb.append((Object)KSentences.POSITION_PLACEHOLDER);
            sb.append((Object)KSentences.AND);
            sb.append((Object)KSentences.POSITION_PLACEHOLDER);
        } else if (pm.getOperators().equals((Object)Operate.IN) || pm.getOperators().equals((Object)Operate.NOT_IN)) {
            if (pm.getInValue() == null || pm.getInValue().size() < 1) {
                throw new IllegalArgumentException(String.format("%s IN param list value size is not zero or null! ", pm.getPname()));
            }
            this.setcName(sb, pm, p);
            sb.append(pm.getOperators().getValue());
            sb.append("(");
            for (int i = 0; i < pm.getInValue().size(); ++i) {
                sb.append((Object)KSentences.POSITION_PLACEHOLDER);
                if (i >= pm.getInValue().size() - 1) continue;
                sb.append(KSentences.COMMA.getValue());
            }
            sb.append(")");
        } else if (pm.getValue() != null && !pm.getValue().toString().trim().equals("")) {
            this.setcName(sb, pm, p);
            if (pm.getOperators().name().startsWith("C_")) {
                sb.append(pm.getOperators().getValue()).append("`").append(pm.getValue()).append("`");
            } else {
                sb.append(pm.getOperators().getValue()).append(KSentences.POSITION_PLACEHOLDER.getValue());
            }
        } else if (pm.getOperators().equals((Object)Operate.EQ) || pm.getOperators().equals((Object)Operate.NOT_EQ)) {
            if (this.getPmsType(pm) == String.class) {
                sb.append("(");
                this.setcName(sb, pm, p);
                sb.append(pm.getOperators().getValue()).append("''");
                if (pm.getOperators().equals((Object)Operate.EQ)) {
                    sb.append(KSentences.OR.getValue());
                } else {
                    sb.append(KSentences.AND.getValue());
                }
            }
            if (pm.getOperators().equals((Object)Operate.EQ)) {
                this.setcName(sb, pm, p);
                sb.append(KSentences.IS_NULL.getValue());
            } else {
                this.setcName(sb, pm, p);
                sb.append(KSentences.IS_NOT_NULL.getValue());
            }
            if (this.getPmsType(pm) == String.class) {
                sb.append(")");
            }
        } else {
            throw new IllegalArgumentException(String.format("%s %s  param  value  is not null ! ", this.domainClazz.getSimpleName(), pm.getPname()));
        }
    }

    private Class<?> getPmsType(Param pm) {
        for (PropInfo p : this.getPropInfos()) {
            if (!p.getPname().equals(pm.getPname())) continue;
            return p.getType();
        }
        throw new IllegalArgumentException(String.format("% field not definition ; %s\u5b57\u6bb5\u6ca1\u6709\u5b9a\u4e49 ;", pm.getPname(), pm.getPname()));
    }

    private void setcName(StringBuilder sb, Param pm, PropInfo p) {
        if (!pm.getCdType().equals((Object)PmType.FUN)) {
            sb.append("`").append(p.getCname()).append("`");
        } else {
            sb.append(pm.getFunName()).append("(");
            sb.append(p.getCname());
            sb.append(")");
        }
    }

    protected int setWhereSqlParamValue(Set<Param> pms, PreparedStatement statement, int ix) {
        if (pms != null && pms.size() > 0) {
            for (Param pm : pms) {
                if (pm.getOperators().name().startsWith("C_") || pm.getPname() == null || pm.getPname().trim().length() <= 0) continue;
                do {
                    try {
                        if (pm.getCdType().equals((Object)PmType.OG)) continue;
                        if (pm.getOperators().equals((Object)Operate.BETWEEN)) {
                            statement.setObject(ix++, this.getParamSqlValue(pm.getFirstValue(), pm.getPname()));
                            statement.setObject(ix++, this.getParamSqlValue(pm.getValue(), pm.getPname()));
                            continue;
                        }
                        if (pm.getOperators().equals((Object)Operate.IN) || pm.getOperators().equals((Object)Operate.NOT_IN) && pm.getInValue() != null) {
                            for (Object se : pm.getInValue()) {
                                statement.setObject(ix++, this.getParamSqlValue(se, pm.getPname()));
                            }
                            continue;
                        }
                        if (pm.getValue() == null || pm.getValue().toString().trim().equals("")) continue;
                        statement.setObject(ix++, this.getParamSqlValue(pm.getValue(), pm.getPname()));
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        throw new IllegalArgumentException(e);
                    }
                } while ((pm = pm.getOrParam()) != null);
            }
        }
        return ix;
    }

    private Object getParamSqlValue(Object o, String pname) {
        if (o != null && !(o instanceof String) && !(o instanceof Number)) {
            PropInfo pp = this.getPropInfoByPName(pname);
            if (o.getClass().isEnum() && pp.getType().isEnum()) {
                EnumType et = pp.getEnumType();
                if (et.equals((Object)EnumType.STRING)) {
                    return o.toString();
                }
                Class<?> cls = pp.getType();
                return ((Enum)Enum.valueOf(cls, o.toString())).ordinal();
            }
            if (pp.getSqlTypes() != null && pp.getSqlTypes().equals(91)) {
                Date dt = (Date)o;
                Date ddd = Date.from(dt.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant());
                return ddd;
            }
        }
        return o;
    }

    protected PropInfo getPropInfoByPName(String pname) {
        if (pname != null && pname.trim().length() > 0) {
            Set<PropInfo> pps = this.getPropInfos();
            for (PropInfo pp : pps) {
                if (!pp.getPname().equals(pname)) continue;
                return pp;
            }
        }
        return null;
    }

    protected void setWhereSqlParamValue(Set<Param> pms, PreparedStatement statement) {
        this.setWhereSqlParamValue(pms, statement, 1);
    }

    protected Set<String> getTableNamesByParams(Set<Param> pms) {
        if (pms != null && pms.size() > 0) {
            Map.Entry<String, LinkedHashSet<PropInfo>> tbimp = ConnectionManager.getTbinfo(this.domainClazz).entrySet().iterator().next();
            for (Param pm : pms) {
                if (pm.getPname() == null || pm.getPname().trim().length() <= 0) continue;
                for (PropInfo p : tbimp.getValue()) {
                    long st;
                    if (p.getColumnRule() == null || !pm.getPname().equals(p.getPname()) || pm.getOrParam() != null) continue;
                    if (pm.getOperators().equals((Object)Operate.EQ) && pm.getValue() != null) {
                        String tableName = this.gettbName(tbimp, pm, p);
                        if (!this.isContainsTable(tableName)) continue;
                        return new HashSet<String>(Arrays.asList(tableName));
                    }
                    if (pm.getOperators().equals((Object)Operate.IN) && pm.getInValue() != null && pm.getInValue().size() > 0) {
                        HashSet<String> tbns = new HashSet<String>();
                        for (Object sid : pm.getInValue()) {
                            String tableName;
                            if (sid == null || !this.isContainsTable(tableName = MyDataSupport.getTableName(this.getTableMaxIdx(sid, p.getType(), p.getColumnRule()), tbimp.getKey()))) continue;
                            tbns.add(tableName);
                        }
                        if (tbns.size() <= 0) continue;
                        return tbns;
                    }
                    if (p.getColumnRule().ruleType().equals((Object)RuleType.RANGE) && pm.getOperators().equals((Object)Operate.BETWEEN) && pm.getValue() != null && pm.getFirstValue() != null) {
                        long ed;
                        long st2 = this.getTableMaxIdx(pm.getFirstValue(), p.getType(), p.getColumnRule());
                        Set<String> nms = this.gettbs(tbimp, st2, ed = this.getTableMaxIdx(pm.getValue(), p.getType(), p.getColumnRule()));
                        if (nms.size() <= 0) continue;
                        return nms;
                    }
                    if (!p.getColumnRule().ruleType().equals((Object)RuleType.RANGE) || !pm.getOperators().equals((Object)Operate.GE) || pm.getValue() == null || (st = this.getTableMaxIdx(pm.getValue(), p.getType(), p.getColumnRule())) <= 0L) continue;
                    int len = MyDataSupport.getTableName(st, tbimp.getKey()).split(KSentences.SHARDING_SPLT.getValue()).length;
                    long ed = this.getCurrentTables().stream().mapToLong(n -> {
                        String[] arr = n.split(KSentences.SHARDING_SPLT.getValue());
                        if (arr.length == len) {
                            return Long.valueOf(arr[arr.length - 1]);
                        }
                        return 0L;
                    }).max().getAsLong();
                    Set<String> nms = this.gettbs(tbimp, st, ed);
                    if (nms.size() <= 0) continue;
                    return nms;
                }
            }
        }
        return this.getCurrentTables();
    }

    private Set<String> gettbs(Map.Entry<String, LinkedHashSet<PropInfo>> tbimp, long st, long ed) {
        HashSet<String> nms = new HashSet<String>();
        for (long i = st; i <= ed; ++i) {
            String tableName = MyDataSupport.getTableName(i, tbimp.getKey());
            if (!this.isContainsTable(tableName)) continue;
            nms.add(tableName);
        }
        return nms;
    }

    private String gettbName(Map.Entry<String, LinkedHashSet<PropInfo>> tbimp, Param pm, PropInfo p) {
        return MyDataSupport.getTableName(this.getTableMaxIdx(pm.getValue(), p.getType(), p.getColumnRule()), tbimp.getKey());
    }

    private boolean isContainsTable(String tbname) {
        for (String tn : this.getCurrentTables()) {
            if (!tn.trim().equalsIgnoreCase(tbname.trim())) continue;
            return true;
        }
        return false;
    }

    private StringBuilder getSelectSql(String tableName, String ... strings) {
        StringBuilder sb = new StringBuilder(this.getPreSelectSql(false, strings));
        sb.append(tableName);
        return sb;
    }

    private String getPreSelectSql(boolean isDistinct, String ... strings) {
        StringBuilder sb = new StringBuilder(KSentences.SELECT.getValue());
        if (strings != null && strings.length > 0) {
            if (isDistinct) {
                sb.append(KSentences.DISTINCT.getValue());
            }
            for (int i = 0; i < strings.length; ++i) {
                for (PropInfo pi : this.getPropInfos()) {
                    if (!strings[i].equals(pi.getPname())) continue;
                    sb.append(pi.getCname());
                    break;
                }
                if (i >= strings.length - 1) continue;
                sb.append(KSentences.COMMA.getValue());
            }
        } else {
            sb.append((Object)KSentences.SELECT_ALL);
        }
        sb.append(KSentences.FROM.getValue());
        return sb.toString();
    }

    private String[] getGSelect(String[] gbs, Collection<String> vvs) {
        LinkedHashSet<String> rz = new LinkedHashSet<String>();
        for (String g : gbs) {
            rz.add(g.trim());
        }
        if (vvs != null) {
            for (String v : vvs) {
                rz.add(v.trim());
            }
        }
        return rz.toArray(new String[0]);
    }

    private boolean isExistTable(String tblname) {
        Set<String> tbns = this.getCurrentTables();
        for (String tn : tbns) {
            if (tn.trim().equalsIgnoreCase(tblname.trim())) {
                return true;
            }
            if (!tn.trim().contains(".") || !tn.trim().split("[.]")[1].equalsIgnoreCase(tblname.trim())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void refreshCurrentTables() {
        this.reFreshTables();
    }

    private boolean autoNextVal(PropInfo p) {
        return GenerationType.AUTO.equals((Object)p.getGeneratorValueAnnoStrategyVal()) || GenerationType.SEQUENCE.equals((Object)p.getGeneratorValueAnnoStrategyVal());
    }

    private List<PropInfo> getDbProps(String tableName, Connection connection) throws SQLException {
        ResultSet crs = connection.getMetaData().getColumns(connection.getCatalog(), null, tableName, null);
        ArrayList<PropInfo> cnames = new ArrayList<PropInfo>();
        while (crs.next()) {
            PropInfo p = new PropInfo(crs.getString("COLUMN_NAME"), crs.getInt("DATA_TYPE"));
            p.setLength(crs.getInt("COLUMN_SIZE"));
            cnames.add(p);
        }
        return cnames;
    }

    private String getPrecisionDatatype(String className) {
        if ("MySQL".equalsIgnoreCase(this.dataBaseTypeName)) {
            return className;
        }
        if ("Oracle".equalsIgnoreCase(this.dataBaseTypeName)) {
            if ("double".equalsIgnoreCase(className)) {
                return "float";
            }
            return className;
        }
        throw new IllegalArgumentException("not support database");
    }

    private boolean sequenceExists(Connection connection, String seqName) throws SQLException {
        PreparedStatement prepare = connection.prepareStatement(SEQUENCE_QUERY);
        prepare.setString(1, seqName);
        boolean isSeqExists = prepare.executeQuery().next();
        return isSeqExists;
    }

    private String getSequenceName(String tableName) {
        String seqName = String.format("%s_%s", tableName, "SEQ").toUpperCase();
        return seqName;
    }

    private void changeToString(PropInfo pi) throws SQLException {
        for (String t : this.getCurrentTables()) {
            String altertablesql = String.format(ALTER_TABLE_MODIFY_COLUMN, t, pi.getCname(), this.getVarchar(pi));
            if (this.getConnectionManager().isShowSql()) {
                log.info(altertablesql);
            }
            this.getConnectionManager().getConnection().prepareStatement(altertablesql).executeUpdate();
        }
    }

    private String getVarchar(PropInfo pi) {
        if ("MySQL".equalsIgnoreCase(this.dataBaseTypeName)) {
            return "VARCHAR(" + pi.getLength() + ")";
        }
        if ("Oracle".equalsIgnoreCase(this.dataBaseTypeName)) {
            return "VARCHAR2(" + pi.getLength() + " char)";
        }
        throw new IllegalArgumentException("not support database");
    }

    private String getIndexColumns(PropInfo p) {
        StringBuilder sbd = new StringBuilder();
        sbd.append(p.getCname());
        if (p.getType() == String.class && p.getLength() > p.getIndex().length() && "MySQL".equalsIgnoreCase(this.dataBaseTypeName)) {
            sbd.append("(").append(p.getIndex().length()).append(")");
        }
        if (p.getIndex().otherPropName() != null && !"".equals(p.getIndex().otherPropName().trim())) {
            String[] pNames;
            for (String pName : pNames = p.getIndex().otherPropName().split(",")) {
                PropInfo propInfo = this.getPropInfoByPName(pName);
                sbd.append(KSentences.COMMA.getValue()).append(propInfo.getCname());
                if (propInfo == null || propInfo.getType() != String.class || !"MySQL".equalsIgnoreCase(this.dataBaseTypeName)) continue;
                sbd.append("(").append(p.getIndex().length()).append(")");
            }
        }
        return sbd.toString();
    }

    private static ResultSet getTableMeta(Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        ResultSet rs = metaData.getTables(conn.getCatalog(), null, null, new String[]{"TABLE"});
        return rs;
    }

    protected void setMaxTableCount(int maxTableCount) {
        this.maxTableCount = maxTableCount;
    }

    private static /* synthetic */ boolean lambda$grouplist$9(Map.Entry en, PropInfo p) {
        return p.getPname().equals(((String)en.getValue()).trim());
    }
}

