/*
 * Decompiled with CFR 0.152.
 */
package run.mydata.manager;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.mydata.annotation.MyTransaction;
import run.mydata.manager.IConnectionManager;

@Aspect
public class TransManager {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Resource
    private IConnectionManager connectionManager;
    private Map<String, IConnectionManager> connectionManagers = new HashMap<String, IConnectionManager>();

    @Around(value="@annotation(run.mydata.annotation.MyTransaction)")
    public Object transactional(ProceedingJoinPoint pjp) throws Throwable {
        MyTransaction transaction = this.getTransaction(pjp);
        IConnectionManager ccm = this.getCurrentConnectionManager(transaction);
        log.debug("currentconnectionmanager  is {}", (Object)ccm.toString());
        try {
            boolean readOnly = false;
            if (transaction != null) {
                readOnly = transaction.readOnly();
            }
            log.debug("begin transaction  {}", (Object)Thread.currentThread().getName());
            boolean b = ccm.beginTransaction(readOnly);
            Object rz = pjp.proceed();
            if (b) {
                log.debug("commit transaction  {}", (Object)Thread.currentThread().getName());
                ccm.commitTransaction();
            }
            return rz;
        }
        catch (Throwable e) {
            log.debug("rollback transaction  {}", (Object)Thread.currentThread().getName());
            ccm.rollbackTransaction();
            throw e;
        }
    }

    private IConnectionManager getCurrentConnectionManager(MyTransaction transaction) {
        log.debug("connectionmanager is {}", (Object)this.connectionManager.toString());
        if (transaction != null && transaction.connectionManager() != null && transaction.connectionManager().trim().length() > 0) {
            log.debug(transaction.connectionManager());
            return this.connectionManagers.getOrDefault(transaction.connectionManager().trim(), this.connectionManager);
        }
        return this.connectionManager;
    }

    private MyTransaction getTransaction(ProceedingJoinPoint pjp) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        MyTransaction myAnnotation = method.getAnnotation(MyTransaction.class);
        if (myAnnotation != null) {
            log.debug("proxyTargetClass:{}", (Object)true);
            return myAnnotation;
        }
        try {
            Method tgmethod = pjp.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
            if (tgmethod != null) {
                myAnnotation = tgmethod.getAnnotation(MyTransaction.class);
                log.debug("proxyTargetClass:{}", (Object)false);
                return myAnnotation;
            }
            log.error("target method  is null ");
            return null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setConnectionManager(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public TransManager(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setConnectionManagers(Map<String, IConnectionManager> connectionManagers) {
        this.connectionManagers = connectionManagers;
    }

    public Map<String, IConnectionManager> put(String name, IConnectionManager connectionManager) {
        this.connectionManagers.put(name.trim(), connectionManager);
        return this.connectionManagers;
    }

    public TransManager() {
    }
}

