/*
 * Decompiled with CFR 0.152.
 */
package run.mydata.config;

import java.util.Arrays;
import javax.sql.DataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import run.mydata.config.MyDataProperties;
import run.mydata.manager.ConnectionManager;
import run.mydata.manager.IConnectionManager;
import run.mydata.manager.TransManager;
import run.mydata.manager.TransManagerDefault;

public class MyDataConfig {
    @Bean
    @ConfigurationProperties(prefix="mydata", ignoreUnknownFields=true)
    public MyDataProperties myDataProperties() {
        MyDataProperties myDataProperties = new MyDataProperties();
        return myDataProperties;
    }

    @Bean
    public IConnectionManager connectionManager(DataSource dataSource, MyDataProperties properties) {
        ConnectionManager connectionManager = new ConnectionManager();
        connectionManager.setDdl(properties.getDdl());
        connectionManager.setShowSql(properties.getShowSql());
        connectionManager.setConnectStr("set  names  utf8");
        connectionManager.setDataSource(dataSource);
        connectionManager.setReadDataSources(Arrays.asList(dataSource));
        return connectionManager;
    }

    @Bean
    public TransManagerDefault transManagerDefault(IConnectionManager connectionManager) {
        TransManagerDefault trans = new TransManagerDefault();
        trans.setConnectionManager(connectionManager);
        return trans;
    }

    @Bean
    public TransManager transManager(IConnectionManager connectionManager) {
        TransManager trans = new TransManager();
        trans.setConnectionManager(connectionManager);
        return trans;
    }
}

