/*
 * Decompiled with CFR 0.152.
 */
package ru.livemaster.longtowords;

import java.util.Locale;
import java.util.ResourceBundle;

public class LongToWords {
    private static final String ZERO = "zero";
    private static final String ONE = "one";
    private static final String TWO = "two";
    private static final String NUM = "num";
    private static final String THOUSAND = "thousand";
    private static final String MILLION = "million";
    private static final String BILLION = "billion";
    private static final String TRILLION = "trillion";
    private static final String QUADRILLION = "quadrillion";
    private static final String MINUS = "minus";
    private String[] mOne;
    private String[] mTwo;
    private String[] mThousand;
    private String[] mMillion;
    private String[] mBillion;
    private String[] mTrillion;
    private String[] mQuadrillion;
    private ResourceBundle mBundle = ResourceBundle.getBundle("number_names", Locale.getDefault());

    public LongToWords() {
        this.mOne = this.mBundle.getString(ONE).split(",");
        this.mTwo = this.mBundle.getString(TWO).split(",");
        this.mThousand = this.mBundle.getString(THOUSAND).split(",");
        this.mMillion = this.mBundle.getString(MILLION).split(",");
        this.mBillion = this.mBundle.getString(BILLION).split(",");
        this.mTrillion = this.mBundle.getString(TRILLION).split(",");
        this.mQuadrillion = this.mBundle.getString(QUADRILLION).split(",");
    }

    private String getName(int index, int type) {
        switch (type) {
            case 1: {
                return this.mThousand[index];
            }
            case 2: {
                return this.mMillion[index];
            }
            case 3: {
                return this.mBillion[index];
            }
            case 4: {
                return this.mTrillion[index];
            }
            case 5: {
                return this.mQuadrillion[index];
            }
        }
        return "";
    }

    private String convertUnit(int unit, int type) {
        String result = "";
        if (unit == 1) {
            result = type == 1 ? this.mOne[1] : this.mOne[0];
        } else if (unit == 2) {
            result = type == 1 ? this.mTwo[1] : this.mTwo[0];
        }
        return result;
    }

    private String convertPartToWords(int value, int type) {
        if ((long)value == 0L) {
            return "";
        }
        int hundreds = value / 100 * 100;
        int tens = value % 100;
        String result = "";
        int endIndex = 0;
        if (hundreds > 0) {
            result = this.mBundle.getString(NUM + hundreds) + " ";
            endIndex = 2;
        }
        if (tens < 20 && tens > 2) {
            result = result + this.mBundle.getString(NUM + tens) + " ";
            endIndex = tens <= 4 ? 1 : 2;
        } else if (tens >= 20) {
            int units = tens % 10;
            result = result + this.mBundle.getString(NUM + tens / 10 * 10) + " ";
            if (units > 2) {
                result = result + this.mBundle.getString(NUM + units) + " ";
            } else if (units > 0) {
                result = result + this.convertUnit(units, type) + " ";
            }
            endIndex = (long)units == 1L ? 0 : (units > 0 && units <= 4 ? 1 : 2);
        } else if (tens > 0) {
            result = result + this.convertUnit(tens, type) + " ";
            if ((long)tens == 1L) {
                endIndex = 0;
            } else if ((long)tens == 2L) {
                endIndex = 1;
            }
        }
        return result + this.getName(endIndex, type);
    }

    public String convertLongToWords(long value) {
        boolean isNegative;
        if (value == 0L) {
            return this.mBundle.getString(ZERO);
        }
        int type = 0;
        long currentNumber = value;
        String result = "";
        boolean bl = isNegative = value < 0L;
        if (isNegative) {
            currentNumber *= -1L;
        }
        while (currentNumber != 0L) {
            int remainder = (int)(currentNumber % 1000L);
            if (remainder > 0) {
                result = this.convertPartToWords(remainder, type) + " " + result;
            }
            ++type;
            currentNumber /= 1000L;
        }
        if (isNegative) {
            result = this.mBundle.getString(MINUS) + " " + result;
        }
        return result;
    }
}

