/*
 * Decompiled with CFR 0.152.
 */
package ru.livemaster.longtowords;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import ru.livemaster.longtowords.LongToWords;

public class Main {
    private static final String APP_STRINGS_RES = "app_strings";
    private static final String OPEN_FILE_ERROR = "open_file_error";
    private static final String ENTER_INPUT_FILE = "enter_input_file";
    private static final String NOT_NUMBER = "not_number";
    private static final String OUT_OF_RANGE = "out_of_range";
    private static final String OUT_FILE = "out.txt";
    private static final long MAX_VALUE = 999999999999999999L;
    private static final long MIN_VALUE = -999999999999999999L;

    private static List<String> readFile(String fileName) throws IOException {
        ArrayList<String> records = new ArrayList<String>();
        try (FileReader fileReader = new FileReader(fileName);){
            String line;
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                records.add(line);
            }
        }
        catch (Exception e) {
            throw new IOException();
        }
        return records;
    }

    private static boolean isNumeric(String str) {
        return str.matches("[+-]?\\d*(\\d+)?");
    }

    public static void main(String[] args) {
        String fileName;
        ResourceBundle bundle = ResourceBundle.getBundle(APP_STRINGS_RES);
        String openFileError = bundle.getString(OPEN_FILE_ERROR);
        String enterNewInputFile = bundle.getString(ENTER_INPUT_FILE);
        String notNumber = bundle.getString(NOT_NUMBER);
        String outOfRange = bundle.getString(OUT_OF_RANGE);
        LongToWords longToWords = new LongToWords();
        if (args.length > 0) {
            fileName = args[0];
        } else {
            System.out.println(enterNewInputFile);
            fileName = System.console().readLine();
        }
        try (FileWriter fileWriter = new FileWriter(OUT_FILE);){
            BufferedWriter writer = new BufferedWriter(fileWriter);
            List<String> records = Main.readFile(fileName);
            for (String value : records) {
                block22: {
                    if (Main.isNumeric(value)) {
                        try {
                            long number = Long.parseLong(value);
                            if (number >= -999999999999999999L && number <= 999999999999999999L) {
                                writer.write(longToWords.convertLongToWords(number));
                                break block22;
                            }
                            writer.write(outOfRange);
                        }
                        catch (NumberFormatException e) {
                            writer.write(outOfRange);
                        }
                    } else {
                        writer.write(notNumber);
                    }
                }
                writer.newLine();
            }
            writer.flush();
        }
        catch (Exception e) {
            System.out.println(openFileError);
        }
    }
}

