package com.starstudio.frame.lib_tools;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.DialogInterface.OnClickListener;
import android.content.DialogInterface.OnKeyListener;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;


public class Utils_Alert {


    public static void showListDialog(Context context, int title, boolean cancleable, CharSequence[] listitems, OnClickListener onClickListener) {
        if (context == null)
            return;

        if (context instanceof Activity) {
            UtilsLog.v("is Instance Activity");
            if (((Activity) context).isFinishing()) {
                return;
            }
        }
        if (context.isRestricted()) {
            return;
        }

        try {
            AlertDialog.Builder alertDialogbuilder = null;
            alertDialogbuilder = new AlertDialog.Builder(context);
            if (title != 0)
                alertDialogbuilder.setTitle(title);
            alertDialogbuilder.setCancelable(cancleable);
            if (listitems != null && listitems.length != 0) {
                alertDialogbuilder.setItems(listitems, onClickListener);
                alertDialogbuilder.create().show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    public static AlertDialog.Builder getDialogBuilder(Context context, int title, int message, boolean cancleable, int positive, OnClickListener positive_ls, int negtive, OnClickListener negtive_ls) {

        if (context instanceof Activity) {
            UtilsLog.v("is Instance Activity");
        } else if (context instanceof Application) {
            UtilsLog.v("is Instance Application");
        }
        if (context == null)
            return null;
        AlertDialog.Builder alertDialogbuilder = null;
        alertDialogbuilder = new AlertDialog.Builder(context);
        if (title != 0)
            alertDialogbuilder.setTitle(title);
        if (message != 0)
            alertDialogbuilder.setMessage(message);
        alertDialogbuilder.setCancelable(cancleable);
        if (positive != 0)
            alertDialogbuilder.setPositiveButton(positive, positive_ls);
        if (negtive != 0)
            alertDialogbuilder.setNegativeButton(negtive, negtive_ls);
        return alertDialogbuilder;
    }

    public static void showAlertDialog(Context context, int message, int positive) {
        showAlertDialog(context, 0, message, true, positive, null, 0, null, null);
    }


    public static void showAlertDialog(Context context, int message, boolean cancleable, int positive, OnClickListener positive_ls) {
        showAlertDialog(context, 0, message, cancleable, positive, positive_ls, 0, null, null);
    }

    public static void showAlertDialog(Context context, int title, int message, boolean cancleable, int positive, OnClickListener positive_ls) {
        showAlertDialog(context, title, message, cancleable, positive, positive_ls, 0, null, null);
    }

    public static void showAlertDialog_ad(Context context, int title, int message, boolean cancleable, int positive, OnClickListener positive_ls, int negtive, OnClickListener negtive_ls, OnKeyListener onKeyListener) {

        if (context == null)
            return;

        if (context instanceof Activity) {
            UtilsLog.v("is Instance Activity");
            if (((Activity) context).isFinishing()) {
                return;
            }
        }
        if (context.isRestricted()) {
            return;
        }


        try {
            AlertDialog.Builder alertDialogbuilder = null;
            alertDialogbuilder = new AlertDialog.Builder(context);
            if (title != 0)
                alertDialogbuilder.setTitle(title);
            if (message != 0)
                alertDialogbuilder.setMessage(message);
            alertDialogbuilder.setCancelable(cancleable);
            if (positive != 0)
                alertDialogbuilder.setPositiveButton(positive, positive_ls);
            if (negtive != 0)
                alertDialogbuilder.setNegativeButton(negtive, negtive_ls);
            if (onKeyListener != null)
                alertDialogbuilder.setOnKeyListener(onKeyListener);
            alertDialogbuilder.show();
        } catch (Exception e) {
            e.printStackTrace();
        }


    }


    public static void showAlertDialog(Context context, int title, int message, boolean cancleable, int positive, OnClickListener positive_ls, int negtive, OnClickListener negtive_ls, OnKeyListener onKeyListener) {
        if (context == null)
            return;

        if (context instanceof Activity) {
            UtilsLog.v("is Instance Activity");
            if (((Activity) context).isFinishing()) {
                return;
            }
        }
        if (context.isRestricted()) {
            return;
        }


        try {
            AlertDialog.Builder alertDialogbuilder = null;
            alertDialogbuilder = new AlertDialog.Builder(context);
            if (title != 0)
                alertDialogbuilder.setTitle(title);
            if (message != 0)
                alertDialogbuilder.setMessage(message);
            alertDialogbuilder.setCancelable(cancleable);
            if (positive != 0)
                alertDialogbuilder.setPositiveButton(positive, positive_ls);
            if (negtive != 0)
                alertDialogbuilder.setNegativeButton(negtive, negtive_ls);
            if (onKeyListener != null)
                alertDialogbuilder.setOnKeyListener(onKeyListener);
            alertDialogbuilder.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showAlertDialog(Context context, String title, int message, boolean cancleable, int positive, OnClickListener positive_ls, int negtive, OnClickListener negtive_ls, OnKeyListener onKeyListener) {
        if (context == null)
            return;

        if (context instanceof Activity) {
            UtilsLog.v("is Instance Activity");
            if (((Activity) context).isFinishing()) {
                return;
            }
        }
        if (context.isRestricted()) {
            return;
        }


        try {
            AlertDialog.Builder alertDialogbuilder = null;
            alertDialogbuilder = new AlertDialog.Builder(context);
            if (!TextUtils.isEmpty(title))
                alertDialogbuilder.setTitle(title);
            if (message != 0)
                alertDialogbuilder.setMessage(message);
            alertDialogbuilder.setCancelable(cancleable);
            if (positive != 0)
                alertDialogbuilder.setPositiveButton(positive, positive_ls);
            if (negtive != 0)
                alertDialogbuilder.setNegativeButton(negtive, negtive_ls);
            if (onKeyListener != null)
                alertDialogbuilder.setOnKeyListener(onKeyListener);
            alertDialogbuilder.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showAlertDialog(Context context, int title, String message, boolean cancleable, int positive, OnClickListener positive_ls, int negtive, OnClickListener negtive_ls, OnKeyListener onKeyListener) {
        if (context == null)
            return;

        if (context instanceof Activity) {
            if (((Activity) context).isFinishing()) {
                return;
            }
        }
        if (context.isRestricted()) {
            return;
        }


        try {
            AlertDialog.Builder alertDialogbuilder = null;
            alertDialogbuilder = new AlertDialog.Builder(context);
            if (title != 0)
                alertDialogbuilder.setTitle(title);
            if (!TextUtils.isEmpty(message))
                alertDialogbuilder.setMessage(message);
            alertDialogbuilder.setCancelable(cancleable);
            if (positive != 0)
                alertDialogbuilder.setPositiveButton(positive, positive_ls);
            if (negtive != 0)
                alertDialogbuilder.setNegativeButton(negtive, negtive_ls);
            if (onKeyListener != null)
                alertDialogbuilder.setOnKeyListener(onKeyListener);
            alertDialogbuilder.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
