package com.starstudio.frame.lib_tools;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Pair;
import android.view.View;
import android.widget.TextView;

import java.util.ArrayList;

/**
 * Created by Hongsec on 2016-08-24.
 */
public class TextEmptyUtils {

    public TextEmptyUtils() {
    }

    private ArrayList<TextView> editTexts = new ArrayList<>();
    private ArrayList<Pair<String, View>> visiableView = new ArrayList<>();
    private ArrayList<CustomView> customs = new ArrayList<>();


    class CustomView {
        public TextView textView;
        public boolean setEnableonEqual;
        public String compareStr;
    }

    public TextEmptyUtils addView(TextView editText) {
        editTexts.add(editText);
        editText.addTextChangedListener(textWatcher);
        return this;
    }

    public TextEmptyUtils addVisibleView(View view, boolean isSetEnableOnVisible) {
        Pair<String, View> stringViewPair = new Pair<>(isSetEnableOnVisible ? "1" : "0", view);
        visiableView.add(stringViewPair);
        view.setOnSystemUiVisibilityChangeListener(visibilityChangeListener);

        return this;
    }


    public TextEmptyUtils addCustom(TextView view, boolean setEnableonEqual, String compareStr) {
        CustomView customView = new CustomView();
        customView.textView = view;
        customView.setEnableonEqual = setEnableonEqual;
        customView.compareStr = compareStr;
        customs.add(customView);
        customView.textView.addTextChangedListener(textWatcher);

        return this;
    }


    private onButtonEnableListener listener = null;

    public onButtonEnableListener getListener() {
        return listener;
    }

    public TextEmptyUtils setListener(onButtonEnableListener listener) {
        this.listener = listener;
        return this;
    }

    public void startCheck() {
        check();
    }


    View.OnSystemUiVisibilityChangeListener visibilityChangeListener = new View.OnSystemUiVisibilityChangeListener() {
        @Override
        public void onSystemUiVisibilityChange(int visibility) {

            check();
        }
    };

    TextWatcher textWatcher = new TextWatcher() {
        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {

        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {

        }

        @Override
        public void afterTextChanged(Editable s) {

            check();


        }
    };

    private void check() {
        boolean result = true;
        for (TextView editText : editTexts) {

            if (editText != null) {
                if (TextUtils.isEmpty(editText.getText().toString())) {
                    result = false;
                    break;
                }
            }
        }

        for (Pair<String, View> stringViewPair : visiableView) {

            int enable = 0;

            if (stringViewPair.first.equalsIgnoreCase("1")) {
                enable = 0; // 보일때 response enable
            } else {
                enable = 1; // 안보일때 response enable
            }

            if (enable == 0) {
                if (stringViewPair.second.getVisibility() != View.VISIBLE) {
                    // 안보임
                    result = false;
                    break;
                }
            } else {
                if (stringViewPair.second.getVisibility() == View.VISIBLE) {
                    // 보임
                    result = false;
                    break;
                }
            }
        }


        for (CustomView customView : customs) {


            if(customView.setEnableonEqual){
                if(!customView.compareStr.equalsIgnoreCase(customView.textView.getText().toString())){
                    result = false;
                    break;
                }
            }else{
                if(customView.compareStr.equalsIgnoreCase(customView.textView.getText().toString())){
                    result = false;
                    break;
                }
            }
        }


        if (listener != null) {

            if (result) {
                listener.onEnable();
            } else {
                listener.onDisable();
            }
        }
    }


}
