package com.starstudio.frame.lib_tools;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;

import java.util.ArrayList;

/**
 * Created by hongsec on 17. 6. 26.
 */

public class PermissionUtils {


    /**
     * 권한체크여부  쇼미는 무조건 권한체크함. 기타 6.0이상만 함<br/>
     * boolean result = false;<br/>
     * result |= Build.VERSION.SDK_INT >= Build.VERSION_CODES.M;<br/>
     * // in xiaomi  should return true must<br/>
     * result |= "xiaomi".equalsIgnoreCase(Build.MANUFACTURER.toLowerCase());<br/>
     * return result;<br/>
     *
     * @return
     */
    public boolean check_device() {
        boolean result = false;
        result |= Build.VERSION.SDK_INT >= Build.VERSION_CODES.M;
        // in xiaomi should return true must
        result |= "xiaomi".equalsIgnoreCase(Build.MANUFACTURER.toLowerCase());
        return result;
    }

    private boolean enable= true;

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    /**
     * Only  23API ,권한체크 <br>
     * 원래는 6.0 이상만 체크하였지만 쇼미때문에 모두 체크하게됨
     *
     * @param manifests
     * @param requestCode
     * @return true means  need request permission
     */
    public boolean CheckPermission_request(Activity activity, String[] manifests, int requestCode) {

        if (!check_device()&&isEnable()) {
            return false;
        }

        String[] requestmanifests = null;
        ArrayList<String> requestmanifests_list = new ArrayList<String>();

        boolean result = false;
        boolean temp = true;
        for (String manifest : manifests) {
            temp = isPermissioned(activity,manifest);

            if (!temp) {
                requestmanifests_list.add(manifest);
                result = true;
            }
        }

        if (result) {

            requestmanifests = new String[requestmanifests_list.size()];
            for (int i = 0; i < requestmanifests_list.size(); i++) {
                requestmanifests[i] = requestmanifests_list.get(i);
            }

            ActivityCompat.requestPermissions(activity, requestmanifests, requestCode);
        }

        return result;
    }


    /**
     * 권한부여 여부
     *
     * @param manifest_permission
     * @return
     */
    public boolean isPermissioned(Activity activity,String manifest_permission) {

        try {
            return ActivityCompat.checkSelfPermission(activity, manifest_permission) == PackageManager.PERMISSION_GRANTED;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return  true;
    }


}
