/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el;

import com.sun.el.lang.ELSupport;
import com.sun.el.lang.EvaluationContext;
import com.sun.el.lang.ExpressionBuilder;
import com.sun.el.parser.AstLiteralExpression;
import com.sun.el.parser.Node;
import com.sun.el.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;

public final class ValueExpressionImpl
extends ValueExpression
implements Externalizable {
    private Class expectedType;
    private String expr;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private transient Node node;

    public ValueExpressionImpl() {
    }

    public ValueExpressionImpl(String string, Node node, FunctionMapper functionMapper, VariableMapper variableMapper, Class clazz) {
        this.expr = string;
        this.node = node;
        this.fnMapper = functionMapper;
        this.varMapper = variableMapper;
        this.expectedType = clazz;
    }

    public boolean equals(Object object) {
        if (object instanceof ValueExpressionImpl) {
            ValueExpressionImpl valueExpressionImpl = (ValueExpressionImpl)object;
            return ((Object)this.getNode()).equals(valueExpressionImpl.getNode());
        }
        return false;
    }

    public Class getExpectedType() {
        return this.expectedType;
    }

    public String getExpressionString() {
        return this.expr;
    }

    private Node getNode() throws ELException {
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expr);
        }
        return this.node;
    }

    public Class getType(ELContext eLContext) throws PropertyNotFoundException, ELException {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        return this.getNode().getType(evaluationContext);
    }

    public Object getValue(ELContext eLContext) throws PropertyNotFoundException, ELException {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        Object object = this.getNode().getValue(evaluationContext);
        if (this.expectedType != null) {
            try {
                object = ELSupport.coerceToType(object, this.expectedType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ELException((Throwable)illegalArgumentException);
            }
        }
        return object;
    }

    public int hashCode() {
        return ((Object)this.getNode()).hashCode();
    }

    public boolean isLiteralText() {
        try {
            return this.getNode() instanceof AstLiteralExpression;
        }
        catch (ELException eLException) {
            return false;
        }
    }

    public boolean isReadOnly(ELContext eLContext) throws PropertyNotFoundException, ELException {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        return this.getNode().isReadOnly(evaluationContext);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.expr = objectInput.readUTF();
        String string = objectInput.readUTF();
        if (!"".equals(string)) {
            this.expectedType = ReflectionUtil.forName(string);
        }
        this.fnMapper = (FunctionMapper)objectInput.readObject();
        this.varMapper = (VariableMapper)objectInput.readObject();
    }

    public void setValue(ELContext eLContext, Object object) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        this.getNode().setValue(evaluationContext, object);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.expr);
        objectOutput.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        objectOutput.writeObject(this.fnMapper);
        objectOutput.writeObject(this.varMapper);
    }

    public String toString() {
        return "ValueExpression[" + this.expr + "]";
    }
}

