/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el;

import com.sun.el.lang.EvaluationContext;
import com.sun.el.lang.ExpressionBuilder;
import com.sun.el.parser.Node;
import com.sun.el.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.VariableMapper;

public final class MethodExpressionImpl
extends MethodExpression
implements Externalizable {
    private Class expectedType;
    private String expr;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private transient Node node;
    private Class[] paramTypes;

    public MethodExpressionImpl() {
    }

    public MethodExpressionImpl(String string, Node node, FunctionMapper functionMapper, VariableMapper variableMapper, Class clazz, Class[] classArray) {
        this.expr = string;
        this.node = node;
        this.fnMapper = functionMapper;
        this.varMapper = variableMapper;
        this.expectedType = clazz;
        this.paramTypes = classArray;
    }

    public boolean equals(Object object) {
        if (object instanceof MethodExpressionImpl) {
            MethodExpressionImpl methodExpressionImpl = (MethodExpressionImpl)object;
            return ((Object)this.getNode()).equals(methodExpressionImpl.getNode());
        }
        return false;
    }

    public String getExpressionString() {
        return this.expr;
    }

    public MethodInfo getMethodInfo(ELContext eLContext) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        Node node = this.getNode();
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        return node.getMethodInfo(evaluationContext, this.paramTypes);
    }

    private Node getNode() throws ELException {
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expr);
        }
        return this.node;
    }

    public int hashCode() {
        return ((Object)this.getNode()).hashCode();
    }

    public Object invoke(ELContext eLContext, Object[] objectArray) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        return this.getNode().invoke(evaluationContext, this.paramTypes, objectArray);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.expr = objectInput.readUTF();
        String string = objectInput.readUTF();
        if (!"".equals(string)) {
            this.expectedType = ReflectionUtil.forName(string);
        }
        this.paramTypes = ReflectionUtil.toTypeArray((String[])objectInput.readObject());
        this.fnMapper = (FunctionMapper)objectInput.readObject();
        this.varMapper = (VariableMapper)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.expr);
        objectOutput.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        objectOutput.writeObject(ReflectionUtil.toTypeNameArray(this.paramTypes));
        objectOutput.writeObject(this.fnMapper);
        objectOutput.writeObject(this.varMapper);
    }

    public boolean isLiteralText() {
        return false;
    }
}

