(ns leiningen.new.reagent-project
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "reagent-project"))

(defn reagent-project
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data 
             ["src/{{ns-name}}.cljs" (render "my_reagent_test.cljs" data)]
             ["project.clj" (render "project.clj" data)]
             ["index.html" (render "index.html" data)])))
