(ns racehub.couchdb
  "CouchDB integration."
                                       
  (:require [racehub.schema :as ps]
            [schema.core :as s :include-macros true])
       
                                       
                                     
                                               
                                                    
                                          
                                      
                                        
                                             )

;; ## Schemas

(s/defschema Document
  "Guts of a CouchDB document, not meant to include CouchFields."
  {(s/either s/Keyword s/Str) s/Any})

(def ID
  (s/named s/Str "ID of the CouchDoc"))

(s/defschema Stub
  "CouchDB attachment stub."
  {s/Any s/Any})

(s/defschema CouchFields
  "Fields that we include in every CouchDB Document."
  {:_id ID
   :_rev s/Str
   (s/optional-key :created-at) ps/Timestamp
   (s/optional-key :updated-at) ps/Timestamp
   (s/optional-key :_conflicts) (s/named [s/Str] "Array of revision IDs")
   (s/optional-key :_deleted_conflicts) (s/named [s/Str] "Array of revision IDs")
   (s/optional-key :_attachments) {s/Keyword Stub}
   (s/optional-key :*) (s/named s/Str "Kill this!")})

(s/defschema CouchDoc
  "A CouchDB Database Document."
  (merge Document CouchFields))

(s/defschema UpdateFailure
  "Failed update return map."
  {:id ID
   :error s/Str
   :reason s/Str})

(s/defschema UpdateSuccess
  "Successful update return map."
  {(s/optional-key :ok) (s/named boolean "Doesn't show up on Cloudant, only locally.")
   :id ID
   :rev s/Str})

(s/defschema UpdateResult
  (s/either UpdateFailure UpdateSuccess))

(def DesignDoc
  (s/named s/Str "Design document name."))

(def ViewName
  (s/named s/Str "Name of a view in a CouchDB design doc."))

(def CasedViewName
  (s/both s/Str (s/pred (fn [^String s] (.startsWith s "downcased-")))))

(s/defschema ViewEntry
  "One result of a CouchDB view call, with :include-docs option."
  {(s/optional-key :id) ID
   :key s/Any
   :value s/Any
   :doc CouchDoc})

(s/defschema FatView
  "Schema for a CouchDB view result with :include-docs set to true."
  [ViewEntry])

(s/defschema SlimView
  "Schema for CouchDB view results with :include-docs set to false."
  [(dissoc ViewEntry :doc)])

(s/defschema View
  (s/either SlimView FatView))

(s/defn uncouchify :- Document
  "Dissoces all CouchDB specific fields from the document."
  [m :- CouchDoc]
  (dissoc m :_id :_rev :created-at :updated-at :* :_conflicts :_deleted_conflicts
          :_attachments :type))

     
   
                            

                      
                      

                    
           
                               
                   
                           
                                 

                                    
                                                     
                           
                                                                

                                                        

                      
                              
      
                                                       
                                        
                                 

                      
                                          
           
                                         
                                                    

                          
                             
                         
                                        
                                                      
                                                            
                                                          
                                                                               

               
                                   
                            
                                 
              
                                                                  

                                
                                   
                  
                
           

                                   
                                         
              
                                               
                               

                       
                                                                       
                                                                  
                                                                      
                       

                                                                     
                                                                    
                                        
                     
                 
                                      
                     
                
                                                  
                                
                                     
                      
                                       
                                   
                          

                                         
                                                                  
                                                                 
                                                 
                             
                               
                
                                       
                                     
                                                       
                                                  
                                 

                                                    
                                        
                                                  
                               
                
                                                                    

                                                  
                                      
                                               
                               
                                                  

                          
                                                                  
                                                                     
         
                    
                                                      
                 

               
                                                                
                                            
                
                             
                                
                                     
                     
                                           
                                 

               
                                                        
              
                                        

               
                                                  

                      
                                                

                                                                    
            
                     
                                     
                                                                     

               

                      
                                                    
                   
                                            

                       
                                                                    
                                     
                     
                                                            
                                                          
                          
                                        
                                                         

                          
                                                                                       
                     
                                        
                   
                                                                   
                                  

                           
                
                                                                       
                           
         
                                             
                       
                             
                                           
                                         
          

                                       
                                                                     
                                                      
          
                                       
                                       
                                                   
                                                   
                                    
                                             

                                       
                     
                               

                    
                                                                
                                                                
          
          
                                                        

                       

                           
                                                    
                                  
                                 
                              
                                     
                        
                                          
                    

                              

                                                                  
                   
                   
                                                                               
                                                                               
                                                                      
                 
                                        
                                                     
                       
                       
                                
                                                                                     
                                                      
                  

                          
                        
                                                                       
                                       

                                               
                                           
                        
                                                  

                                                    
      
               
                                   

                                  
      
                                  
                                           

;;;;;;;;;;;; This file autogenerated from src/cljx/racehub/couchdb.cljx
