(ns stripe.token
  (:require [schema.core :as s]
                                     
            [stripe.schema :as ss]
            [stripe.util :as u]))

;; ## Schema

(def CardToken
  (s/named s/Str "Token returned by a call to Stripe.js."))

(def BankToken
  (s/named s/Str "Token representing a user's bank account."))

(def ExpMonth
  (-> (s/both s/Int (s/pred (u/between 1 13)))
      (s/named "Two digit number representing the card's expiration month.")))

(def ExpYear
  (-> (s/both s/Int (s/pred (some-fn
                             (u/between 1 13)
                             (u/between 2000 10000))))
      (s/named
       "Two digit number representing the card's expiration year.")))

(def CardNumber
  (s/named s/Str "Credit card # with no separators."))

(def CVC
  (s/named s/Str "Card security code. HIGHLY recommended."))

(def FullName
  (s/named s/Str "The cardholder's full name."))

(def CardMap
  {:number CardNumber
   :exp_month ExpMonth
   :exp_year ExpYear
   (s/optional-key :cvc) CVC
   (s/optional-key :name) FullName
   (s/optional-key :address_line1) s/Str
   (s/optional-key :address_city) s/Str
   (s/optional-key :address_zip) s/Str
   (s/optional-key :address_state) s/Str
   (s/optional-key :address_country) s/Str})

(def Card
  (s/either CardToken CardMap))

(def BankMap
  {:account_number (s/named s/Str "Checking account number.")
   :routing_number
   (s/named s/Str "Bank routing number. ACH, not wire.")})

;; ## Bank and Card Tokens

     
   
                                            

                                         
                                                                        
                                                                  
                                          
                     
                                        
                                         

                                         
                                                                       
                                                               
                                       

                                                                 
                       
                        
                                        
                                                       
                                                             

                                 
                                                                    
                                             
                                       

;;;;;;;;;;;; This file autogenerated from src/cljx/stripe/token.cljx
