/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.utils.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

public final class TypeBuilder {
    private TypeBuilder() {
    }

    public static Type from(Class<?> rawType, Type ... typeParameters) {
        Objects.requireNonNull(rawType, "Raw type cannot be null");
        Objects.requireNonNull(typeParameters, "Type parameters cannot be null");
        if (rawType.getTypeParameters().length != typeParameters.length) {
            throw new IllegalArgumentException(String.format("Tried to pass %d type parameters to type %s (%d type parameters)", typeParameters.length, rawType.getCanonicalName(), rawType.getTypeParameters().length));
        }
        if (typeParameters.length > 0) {
            for (Type type : typeParameters) {
                Objects.requireNonNull(type, "Type parameters cannot be null");
            }
            return new ConstructedParameterizedType(rawType, typeParameters);
        }
        return rawType;
    }

    private static class ConstructedParameterizedType
    implements ParameterizedType {
        private final Type[] actualTypeArguments;
        private final Class<?> rawType;
        private final Type ownerType;

        ConstructedParameterizedType(Class<?> rawType, Type[] actualTypeArguments) {
            this.actualTypeArguments = actualTypeArguments;
            this.rawType = rawType;
            this.ownerType = rawType.getDeclaringClass();
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object o) {
            if (o instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)o;
                if (this == type) {
                    return true;
                }
                Type ownerType = type.getOwnerType();
                Type rawType = type.getRawType();
                return Objects.equals(this.ownerType, ownerType) && Objects.equals(this.rawType, rawType) && Arrays.equals(this.actualTypeArguments, type.getActualTypeArguments());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.ownerType != null) {
                if (this.ownerType instanceof Class) {
                    sb.append(((Class)this.ownerType).getName());
                } else {
                    sb.append(this.ownerType.toString());
                }
                sb.append(".");
                sb.append(this.rawType.getName());
            } else {
                sb.append(this.rawType.getName());
            }
            if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
                sb.append("<");
                boolean var2 = true;
                for (Type typeArgument : this.actualTypeArguments) {
                    if (!var2) {
                        sb.append(", ");
                    }
                    sb.append(typeArgument.getTypeName());
                    var2 = false;
                }
                sb.append(">");
            }
            return sb.toString();
        }
    }
}

