/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.utils;

import java.util.HashMap;
import java.util.Map;

public final class Primitives
extends Enum<Primitives> {
    public static final /* enum */ Primitives BYTE;
    public static final /* enum */ Primitives SHORT;
    public static final /* enum */ Primitives INTEGER;
    public static final /* enum */ Primitives LONG;
    public static final /* enum */ Primitives FLOAT;
    public static final /* enum */ Primitives DOUBLE;
    public static final /* enum */ Primitives BOOLEAN;
    public static final /* enum */ Primitives CHAR;
    public static final /* enum */ Primitives VOID;
    private static final Map<Class, Class> UNWRAPPED_TO_WRAPPED;
    private static final Map<Class, Class> WRAPPED_TO_UNWRAPPED;
    private final Class unwrapped;
    private final Class wrapped;
    private final char jvmName;
    private static final /* synthetic */ Primitives[] $VALUES;

    public static Primitives[] values() {
        return (Primitives[])$VALUES.clone();
    }

    public static Primitives valueOf(String name) {
        return Enum.valueOf(Primitives.class, name);
    }

    private <T> Primitives(Class<T> unwrapped, Class<T> wrapped, char jvmName) {
        this.unwrapped = unwrapped;
        this.wrapped = wrapped;
        this.jvmName = jvmName;
    }

    public Class unwrapped() {
        return this.unwrapped;
    }

    public Class wrapped() {
        return this.wrapped;
    }

    public char jvmName() {
        return this.jvmName;
    }

    public static <T> Class<T> wrap(Class<T> unwrapped) {
        Class<T> wrapped = UNWRAPPED_TO_WRAPPED.get(unwrapped);
        return wrapped != null ? wrapped : unwrapped;
    }

    public static <T> Class<T> unwrap(Class<T> wrapped) {
        Class<T> unwrapped = WRAPPED_TO_UNWRAPPED.get(wrapped);
        return unwrapped != null ? unwrapped : wrapped;
    }

    public static char jvmName(Class<?> unwrapped) {
        if (unwrapped.isPrimitive()) {
            for (Primitives p : Primitives.values()) {
                if (p.unwrapped != unwrapped) continue;
                return p.jvmName;
            }
        }
        throw new IllegalArgumentException("Class " + unwrapped.getCanonicalName() + " is not a primitive");
    }

    static {
        Primitives[] values;
        BYTE = new Primitives(Byte.TYPE, Byte.class, 'B');
        SHORT = new Primitives(Short.TYPE, Short.class, 'S');
        INTEGER = new Primitives(Integer.TYPE, Integer.class, 'I');
        LONG = new Primitives(Long.TYPE, Long.class, 'J');
        FLOAT = new Primitives(Float.TYPE, Float.class, 'F');
        DOUBLE = new Primitives(Double.TYPE, Double.class, 'D');
        BOOLEAN = new Primitives(Boolean.TYPE, Boolean.class, 'Z');
        CHAR = new Primitives(Character.TYPE, Character.class, 'C');
        VOID = new Primitives(Void.TYPE, Void.TYPE, 'V');
        $VALUES = new Primitives[]{BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE, BOOLEAN, CHAR, VOID};
        UNWRAPPED_TO_WRAPPED = new HashMap<Class, Class>();
        WRAPPED_TO_UNWRAPPED = new HashMap<Class, Class>();
        for (int i = 0; i < (values = Primitives.values()).length; ++i) {
            Primitives primitive = values[i];
            UNWRAPPED_TO_WRAPPED.put(primitive.unwrapped, primitive.wrapped);
            WRAPPED_TO_UNWRAPPED.put(primitive.wrapped, primitive.unwrapped);
        }
    }
}

