/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.utils;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import pw.stamina.mandate.internal.utils.Primitives;

public final class PrimitiveArrays {
    private static final Map<Class, Class> UNWRAPPED_TO_WRAPPED_CACHE = new HashMap<Class, Class>();
    private static final Map<Class, Class> WRAPPED_TO_UNWRAPPED_CACHE = new HashMap<Class, Class>();

    private PrimitiveArrays() {
    }

    public static Class wrap(Class unwrapped) {
        return UNWRAPPED_TO_WRAPPED_CACHE.computeIfAbsent(Primitives.wrap(PrimitiveArrays.getBaseComponentType(PrimitiveArrays.validateIsArray(unwrapped))), componentType -> Array.newInstance(componentType, PrimitiveArrays.getDimensions(unwrapped)).getClass());
    }

    public static Class unwrap(Class wrapped) {
        return WRAPPED_TO_UNWRAPPED_CACHE.computeIfAbsent(Primitives.unwrap(PrimitiveArrays.getBaseComponentType(PrimitiveArrays.validateIsArray(wrapped))), componentType -> Array.newInstance(componentType, PrimitiveArrays.getDimensions(wrapped)).getClass());
    }

    private static <T> Class<T> validateIsArray(Class<T> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("Class \"" + arrayClass.getSimpleName() + "\" is not an array type");
        }
        return arrayClass;
    }

    public static Class getBaseComponentType(Class arrayClass) {
        while (arrayClass.isArray()) {
            arrayClass = arrayClass.getComponentType();
        }
        return arrayClass;
    }

    public static int[] getDimensions(Class arrayClass) {
        int dim = 0;
        while (arrayClass.isArray()) {
            arrayClass = arrayClass.getComponentType();
            ++dim;
        }
        return new int[dim];
    }
}

