/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.syntax.component;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pw.stamina.mandate.execution.executable.CommandExecutable;
import pw.stamina.mandate.syntax.SyntaxComponent;

public class ImmutableSyntaxComponentDecorator
implements SyntaxComponent {
    private final SyntaxComponent backingComponent;

    public ImmutableSyntaxComponentDecorator(SyntaxComponent backingComponent) {
        this.backingComponent = backingComponent;
    }

    @Override
    public String getSyntax() {
        return this.backingComponent.getSyntax();
    }

    @Override
    public Optional<SyntaxComponent> findChild(String syntax) {
        return this.backingComponent.findChild(syntax).map(ImmutableSyntaxComponentDecorator::new);
    }

    @Override
    public void addChild(SyntaxComponent component) {
        throw new UnsupportedOperationException("Syntax components cannot be manually added to an existing syntax root");
    }

    @Override
    public Optional<Set<SyntaxComponent>> findChildren() {
        return this.backingComponent.findChildren().map(children -> children.stream().map(ImmutableSyntaxComponentDecorator::new).collect(Collectors.toSet()));
    }

    @Override
    public void addExecutable(CommandExecutable executable) {
        throw new UnsupportedOperationException("Executable components cannot be manually added to an existing syntax root");
    }

    @Override
    public Optional<Set<CommandExecutable>> findExecutables() {
        return this.backingComponent.findExecutables();
    }
}

