/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.syntax;

import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import pw.stamina.mandate.execution.ExecutionContext;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.syntax.CommandRegistry;
import pw.stamina.mandate.syntax.ExecutableLookup;
import pw.stamina.mandate.syntax.SyntaxComponent;

public class ForkedCommandRegistry
implements CommandRegistry {
    private final CommandRegistry forkedRegistry;
    private final CommandRegistry thisRegistry;

    public ForkedCommandRegistry(CommandRegistry forkedRegistry, CommandRegistry thisRegistry) {
        this.forkedRegistry = forkedRegistry;
        this.thisRegistry = thisRegistry;
    }

    @Override
    public Set<SyntaxComponent> getCommands() {
        HashSet<SyntaxComponent> componentSet = new HashSet<SyntaxComponent>();
        componentSet.addAll(this.thisRegistry.getCommands());
        componentSet.addAll(this.forkedRegistry.getCommands());
        return componentSet;
    }

    @Override
    public void addCommand(SyntaxComponent component) {
        this.thisRegistry.addCommand(component);
    }

    @Override
    public ExecutableLookup findExecutable(Deque<CommandArgument> syntaxComponents, ExecutionContext executionContext) {
        ExecutableLookup lookup = this.thisRegistry.findExecutable(syntaxComponents, executionContext);
        return lookup.wasSuccessful() ? lookup : this.forkedRegistry.findExecutable(syntaxComponents, executionContext);
    }

    @Override
    public boolean commandPresent(String command) {
        return this.thisRegistry.commandPresent(command) || this.forkedRegistry.commandPresent(command);
    }
}

