/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.parsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import pw.stamina.mandate.annotations.Implicit;
import pw.stamina.mandate.annotations.flag.AutoFlag;
import pw.stamina.mandate.annotations.flag.UserFlag;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.ExecutionContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.internal.utils.reflect.TypeBuilder;
import pw.stamina.mandate.parsing.ArgumentReificationException;
import pw.stamina.mandate.parsing.ArgumentReificationStrategy;

public enum DefaultArgumentReifier implements ArgumentReificationStrategy
{
    INSTANCE;


    @Override
    public Object[] parse(Deque<CommandArgument> arguments, List<CommandParameter> parameters, ExecutionContext executionContext, CommandContext commandContext) throws ArgumentReificationException {
        ArrayList<Object> parsedArgs = new ArrayList<Object>(parameters.size());
        HashSet<String> excludedFlags = new HashSet<String>();
        for (CommandParameter parameter : parameters) {
            if (parameter.getAnnotation(Implicit.class) == null) {
                String def;
                Optional<String> conflictingFlagLookup;
                CommandArgument present;
                ArgumentHandler<?> argumentHandler = commandContext.getArgumentHandlers().findArgumentHandler(parameter.getType()).orElseThrow(() -> new ArgumentReificationException(String.format("No argument handler exists for argument parameter type '%s'", parameter.getType().getCanonicalName())));
                AutoFlag autoFlag = parameter.getAnnotation(AutoFlag.class);
                if (autoFlag != null) {
                    present = DefaultArgumentReifier.popFlagIfPresent(arguments, autoFlag.flag());
                    if (present != null && (conflictingFlagLookup = DefaultArgumentReifier.findConflictingFlag(autoFlag.flag(), autoFlag.xor(), excludedFlags)).isPresent()) {
                        throw new ArgumentReificationException(String.format("Provided flag '%s' conflicts with exclusive flag '%s'", present.getRaw(), conflictingFlagLookup.get()));
                    }
                    String string = parameter.getType() == Boolean.class || parameter.getType() == Boolean.TYPE ? (present != null ? "true" : "false") : (def = present != null ? autoFlag.ifdef() : autoFlag.elsedef());
                    if (!parameter.isOptional()) {
                        parsedArgs.add(!def.isEmpty() ? (Object)argumentHandler.parse(commandContext.getCommandConfiguration().getArgumentCreationStrategy().newArgument(def), parameter, commandContext) : null);
                        continue;
                    }
                    parsedArgs.add(!def.isEmpty() ? Optional.of(argumentHandler.parse(commandContext.getCommandConfiguration().getArgumentCreationStrategy().newArgument(def), parameter, commandContext)) : Optional.empty());
                    continue;
                }
                UserFlag userFlag = parameter.getAnnotation(UserFlag.class);
                if (userFlag != null) {
                    present = DefaultArgumentReifier.popFlagAndOperandIfPresent(arguments, userFlag.flag());
                    if (present != null && (conflictingFlagLookup = DefaultArgumentReifier.findConflictingFlag(userFlag.flag(), userFlag.xor(), excludedFlags)).isPresent()) {
                        throw new ArgumentReificationException(String.format("Provided flag '%s' conflicts with exclusive flag '%s'", present.getRaw(), conflictingFlagLookup.get()));
                    }
                    String string = def = present != null ? present.getRaw() : userFlag.elsedef();
                    if (!parameter.isOptional()) {
                        parsedArgs.add(!def.isEmpty() ? (Object)argumentHandler.parse(commandContext.getCommandConfiguration().getArgumentCreationStrategy().newArgument(def), parameter, commandContext) : null);
                        continue;
                    }
                    parsedArgs.add(!def.isEmpty() ? Optional.of(argumentHandler.parse(commandContext.getCommandConfiguration().getArgumentCreationStrategy().newArgument(def), parameter, commandContext)) : Optional.empty());
                    continue;
                }
                if (!parameter.isOptional()) {
                    parsedArgs.add(argumentHandler.parse(arguments.poll(), parameter, commandContext));
                    continue;
                }
                parsedArgs.add(!arguments.isEmpty() ? Optional.of(argumentHandler.parse(arguments.poll(), parameter, commandContext)) : Optional.empty());
                continue;
            }
            Object implicitLookup = executionContext.getProvidedValue(TypeBuilder.from(parameter.getType(), parameter.getTypeParameters()));
            if (implicitLookup != null) {
                parsedArgs.add(implicitLookup);
                continue;
            }
            throw new ArgumentReificationException(String.format("No mapped instance present for implicit parameters of type %s", parameter.getType()));
        }
        if (!arguments.isEmpty()) {
            throw new ArgumentReificationException(String.format("Passed %d invalid or previously present argument(s): %s", arguments.size(), arguments.toString()));
        }
        return parsedArgs.toArray();
    }

    private static CommandArgument popFlagIfPresent(Deque<CommandArgument> arguments, String[] possibilities) {
        Iterator<CommandArgument> it = arguments.iterator();
        while (it.hasNext()) {
            CommandArgument arg = it.next();
            for (String option : possibilities) {
                if (!arg.getRaw().equals("-" + option)) continue;
                it.remove();
                return arg;
            }
        }
        return null;
    }

    private static CommandArgument popFlagAndOperandIfPresent(Deque<CommandArgument> arguments, String[] possibilities) {
        Iterator<CommandArgument> it = arguments.iterator();
        while (it.hasNext()) {
            CommandArgument arg = it.next();
            for (String option : possibilities) {
                if (!arg.getRaw().equals("-" + option) || !it.hasNext()) continue;
                it.remove();
                CommandArgument operand = it.next();
                it.remove();
                return operand;
            }
        }
        return null;
    }

    private static Optional<String> findConflictingFlag(String[] flags, String[] exclusives, Set<String> excluded) {
        Optional<String> result = Optional.empty();
        for (String s : exclusives) {
            if (!excluded.contains(s)) continue;
            result = Optional.of(s);
            break;
        }
        excluded.addAll(Arrays.asList(flags));
        if (exclusives.length > 0) {
            excluded.addAll(Arrays.asList(exclusives));
        }
        return result;
    }

    public static DefaultArgumentReifier getInstance() {
        return INSTANCE;
    }
}

