/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.result;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import pw.stamina.mandate.execution.ExecutionContext;
import pw.stamina.mandate.execution.result.Execution;
import pw.stamina.mandate.execution.result.ExitCode;
import pw.stamina.mandate.internal.execution.executable.invoker.CommandInvoker;

public class AsynchronousInvokerExecution
implements Execution {
    private static final ExecutorService COMMAND_EXECUTOR = Executors.newCachedThreadPool();
    private final ExecutionContext executionContext;
    private final Future<ExitCode> pendingComputation = COMMAND_EXECUTOR.submit(() -> invoker.invoke(args));

    public AsynchronousInvokerExecution(CommandInvoker invoker, ExecutionContext executionContext, Object[] args) {
        this.executionContext = executionContext;
    }

    @Override
    public ExitCode result() {
        try {
            return this.pendingComputation.get();
        }
        catch (Exception e) {
            this.executionContext.getIODescriptor().err().write(String.format("Exception while executing command: %s", e));
            return ExitCode.TERMINATED;
        }
    }

    @Override
    public ExitCode result(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return this.pendingComputation.get(timeout, unit);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            this.executionContext.getIODescriptor().err().write(String.format("Exception while executing command: %s", e));
            return ExitCode.TERMINATED;
        }
    }

    @Override
    public boolean kill() {
        return this.pendingComputation.cancel(true);
    }

    @Override
    public boolean completed() {
        return this.pendingComputation.isDone();
    }
}

