/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.executable;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import pw.stamina.mandate.annotations.Executes;
import pw.stamina.mandate.annotations.flag.AutoFlag;
import pw.stamina.mandate.annotations.flag.UserFlag;
import pw.stamina.mandate.annotations.meta.Description;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.ExecutionContext;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.executable.CommandExecutable;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.execution.result.Execution;
import pw.stamina.mandate.execution.result.ExitCode;
import pw.stamina.mandate.internal.execution.executable.MalformedCommandException;
import pw.stamina.mandate.internal.execution.executable.invoker.CommandInvoker;
import pw.stamina.mandate.internal.execution.executable.invoker.InvokerFactory;
import pw.stamina.mandate.internal.execution.result.ExecutionFactory;
import pw.stamina.mandate.parsing.ArgumentReificationException;
import pw.stamina.mandate.parsing.InputParsingException;

class SimpleExecutable
implements CommandExecutable {
    private final String executableName;
    private final Description executableDescription;
    private final CommandInvoker commandInvoker;
    private final CommandContext commandContext;
    private final List<CommandParameter> parameters;
    private final boolean parallel;

    SimpleExecutable(Method backingMethod, Object methodParent, CommandContext commandContext) throws MalformedCommandException {
        if (backingMethod.getReturnType() != ExitCode.class) {
            throw new MalformedCommandException("Annotated method '" + backingMethod.getName() + "' does have a return type of " + ExitCode.class.getCanonicalName());
        }
        this.commandContext = commandContext;
        this.parameters = this.commandContext.getCommandConfiguration().getParameterCreationStrategy().generateCommandParameters(backingMethod, commandContext);
        this.executableName = backingMethod.getName();
        this.executableDescription = backingMethod.getDeclaredAnnotation(Description.class);
        this.commandInvoker = InvokerFactory.makeInvoker(backingMethod, methodParent);
        this.parallel = backingMethod.getDeclaredAnnotation(Executes.class).async();
    }

    @Override
    public Execution execute(Deque<CommandArgument> arguments, ExecutionContext executionContext) throws ArgumentReificationException {
        Object[] parsedArgs = this.commandContext.getCommandConfiguration().getArgumentReificationStrategy().parse(arguments, this.parameters, executionContext, this.commandContext);
        return ExecutionFactory.makeExecution(this.commandInvoker, executionContext, parsedArgs, this.parallel);
    }

    @Override
    public List<CommandParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public String getDescription() {
        return this.executableDescription != null ? String.join((CharSequence)System.lineSeparator(), this.executableDescription.value()) : "";
    }

    @Override
    public int minimumArguments() {
        return (int)this.parameters.stream().filter(param -> param.getAnnotation(AutoFlag.class) == null && param.getAnnotation(UserFlag.class) == null).filter(param -> !param.isOptional() && !param.isImplicit()).count();
    }

    @Override
    public int maximumArguments() {
        int baseParameterCount = (int)this.parameters.stream().filter(param -> !param.isImplicit()).count();
        return baseParameterCount + (int)this.parameters.stream().filter(param -> param.getAnnotation(UserFlag.class) != null).count();
    }

    @Override
    public void validate(Deque<CommandArgument> arguments, ExecutionContext executionContext) throws InputParsingException {
        this.commandContext.getCommandConfiguration().getArgumentReificationStrategy().parse(new ArrayDeque<CommandArgument>(arguments), this.parameters, executionContext, this.commandContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleExecutable that = (SimpleExecutable)o;
        return this.minimumArguments() == that.minimumArguments() && this.maximumArguments() == that.maximumArguments();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.minimumArguments();
        result = 31 * result + this.maximumArguments();
        return result;
    }

    public String toString() {
        return String.format("SimpleExecutable{name=%s, parameters=%s}", this.executableName, this.parameters);
    }
}

