/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.handlers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.internal.annotations.numeric.IntClamp;
import pw.stamina.mandate.internal.annotations.numeric.PreciseClamp;
import pw.stamina.mandate.internal.annotations.numeric.RealClamp;
import pw.stamina.mandate.internal.utils.Primitives;
import pw.stamina.mandate.parsing.InputParsingException;

public final class NumberArgumentHandler
implements ArgumentHandler<Number> {
    private static final Predicate<String> HEX_VALIDATOR_PREDICATE = Pattern.compile("^(-|\\+)?(0x|0X|#)[a-fA-F0-9]+$").asPredicate();
    private static final Predicate<String> OCTAL_VALIDATOR_PREDICATE = Pattern.compile("^(-|\\+)?0[1-7][0-7]*$").asPredicate();
    private static final Map<Class<? extends Number>, Function<String, ? extends Number>> NUMBER_DECODERS;
    private static final Map<Class<? extends Number>, Function<Number, Function<CommandParameter, Number>>> POST_PROCESSORS;

    @Override
    public final Number parse(CommandArgument input, CommandParameter parameter, CommandContext commandContext) throws InputParsingException {
        Class<?> numberClass = Primitives.wrap(parameter.getType());
        Object resultNumber = NumberArgumentHandler.parseNumber(input.getRaw(), numberClass);
        return POST_PROCESSORS.get(numberClass).apply((Number)resultNumber).apply(parameter);
    }

    @Override
    public final String getSyntax(CommandParameter parameter) {
        String suffix;
        Class<?> numberClass = Primitives.wrap(parameter.getType());
        String prefix = numberClass.getSimpleName();
        IntClamp intClamp = parameter.getAnnotation(IntClamp.class);
        if (intClamp == null) {
            RealClamp realClamp = parameter.getAnnotation(RealClamp.class);
            if (realClamp == null) {
                return parameter.getLabel() + " - " + prefix;
            }
            double min = Math.min(realClamp.min(), realClamp.max());
            double max = Math.max(realClamp.min(), realClamp.max());
            suffix = !Double.isNaN(min) && !Double.isNaN(max) ? String.format("%s-%s", min, max) : (!Double.isNaN(min) ? ">" + min : (!Double.isNaN(max) ? "<" + max : "?"));
        } else {
            long min = Math.min(intClamp.min(), intClamp.max());
            long max = Math.max(intClamp.min(), intClamp.max());
            suffix = Long.MIN_VALUE != min && Long.MAX_VALUE != max ? String.format("%s-%s", min, max) : (Long.MIN_VALUE != min ? ">" + min : (Long.MAX_VALUE != max ? "<" + max : "?"));
        }
        return parameter.getLabel() + " - " + String.format("%s[%s]", prefix, suffix);
    }

    @Override
    public Class[] getHandledTypes() {
        return new Class[]{Number.class};
    }

    private static <R extends Number> R parseNumber(String input, Class<R> numberClass) throws InputParsingException {
        try {
            Function<String, ? extends Number> decoder = NUMBER_DECODERS.get(numberClass);
            return (R)((Number)numberClass.cast(decoder.apply(input)));
        }
        catch (NumberFormatException e) {
            throw new InputParsingException(String.format("'%s' cannot be parsed to a(n) %s", input, numberClass.getCanonicalName()), e);
        }
    }

    private static Double decodeDouble(String input) throws NumberFormatException {
        return HEX_VALIDATOR_PREDICATE.test(input) || OCTAL_VALIDATOR_PREDICATE.test(input) ? Long.decode(input).doubleValue() : Double.valueOf(input).doubleValue();
    }

    private static Float decodeFloat(String input) throws NumberFormatException {
        return Float.valueOf(HEX_VALIDATOR_PREDICATE.test(input) || OCTAL_VALIDATOR_PREDICATE.test(input) ? Integer.decode(input).floatValue() : Float.valueOf(input).floatValue());
    }

    private static BigInteger decodeBigInteger(String input) throws NumberFormatException {
        return HEX_VALIDATOR_PREDICATE.test(input) ? new BigInteger(input.charAt(0) == '0' ? input.substring(2) : input.substring(1), 16) : new BigInteger(input, OCTAL_VALIDATOR_PREDICATE.test(input) ? 8 : 10);
    }

    private static BigDecimal decodeBigDecimal(String input) throws NumberFormatException {
        return HEX_VALIDATOR_PREDICATE.test(input) ? new BigDecimal(new BigInteger(input.charAt(0) == '0' ? input.substring(2) : input.substring(1), 16)) : (OCTAL_VALIDATOR_PREDICATE.test(input) ? new BigDecimal(new BigInteger(input, 8)) : new BigDecimal(input));
    }

    private static Number clampInteger(IntClamp intClamp, Number num, Function<Number, Number> castingFunction) {
        long min = Math.min(intClamp.min(), intClamp.max());
        if (num.longValue() < min) {
            return castingFunction.apply(min);
        }
        long max = Math.max(intClamp.min(), intClamp.max());
        if (num.longValue() > max) {
            return castingFunction.apply(max);
        }
        return num;
    }

    private static Number clampReal(RealClamp realClamp, Number num, Function<Number, Number> castingFunction) {
        double min = Math.min(realClamp.min(), realClamp.max());
        if (!Double.isNaN(min) && num.doubleValue() < min) {
            return castingFunction.apply(min);
        }
        double max = Math.max(realClamp.min(), realClamp.max());
        if (!Double.isNaN(max) && num.doubleValue() > max) {
            return castingFunction.apply(max);
        }
        return num;
    }

    private static BigInteger clampBigInteger(PreciseClamp preciseClamp, BigInteger num) {
        BigInteger max;
        BigInteger min = !preciseClamp.min().isEmpty() ? NumberArgumentHandler.decodeBigInteger(preciseClamp.min()) : null;
        BigInteger bigInteger = max = !preciseClamp.max().isEmpty() ? NumberArgumentHandler.decodeBigInteger(preciseClamp.max()) : null;
        if (min != null) {
            BigInteger absMin;
            BigInteger bigInteger2 = absMin = max != null ? min.min(max) : min;
            if (num.compareTo(absMin) < 0) {
                return absMin;
            }
        }
        if (max != null) {
            BigInteger absMax;
            BigInteger bigInteger3 = absMax = min != null ? max.max(min) : max;
            if (num.compareTo(absMax) > 0) {
                return absMax;
            }
        }
        return num;
    }

    private static BigDecimal clampBigDecimal(PreciseClamp preciseClamp, BigDecimal num) {
        BigDecimal max;
        BigDecimal min = !preciseClamp.min().isEmpty() ? NumberArgumentHandler.decodeBigDecimal(preciseClamp.min()) : null;
        BigDecimal bigDecimal = max = !preciseClamp.max().isEmpty() ? NumberArgumentHandler.decodeBigDecimal(preciseClamp.max()) : null;
        if (min != null) {
            BigDecimal absMin;
            BigDecimal bigDecimal2 = absMin = max != null ? min.min(max) : min;
            if (num.compareTo(absMin) < 0) {
                return absMin;
            }
        }
        if (max != null) {
            BigDecimal absMax;
            BigDecimal bigDecimal3 = absMax = min != null ? max.max(min) : max;
            if (num.compareTo(absMax) > 0) {
                return absMax;
            }
        }
        return num;
    }

    static {
        HashMap<Class, Function<String, Number>> decoders = new HashMap<Class, Function<String, Number>>();
        decoders.put(Byte.class, Byte::decode);
        decoders.put(Short.class, Short::decode);
        decoders.put(Integer.class, Integer::decode);
        decoders.put(Long.class, Long::decode);
        decoders.put(Double.class, NumberArgumentHandler::decodeDouble);
        decoders.put(Float.class, NumberArgumentHandler::decodeFloat);
        decoders.put(BigInteger.class, NumberArgumentHandler::decodeBigInteger);
        decoders.put(BigDecimal.class, NumberArgumentHandler::decodeBigDecimal);
        NUMBER_DECODERS = Collections.unmodifiableMap(decoders);
        Function<Function, Function> intProcessor = cast -> num -> param -> {
            IntClamp intClamp = param.getAnnotation(IntClamp.class);
            if (intClamp != null) {
                return NumberArgumentHandler.clampInteger(intClamp, num, cast);
            }
            RealClamp realClamp = param.getAnnotation(RealClamp.class);
            if (realClamp != null) {
                return NumberArgumentHandler.clampReal(realClamp, num, cast);
            }
            return num;
        };
        Function<Function, Function> realProcessor = cast -> num -> param -> {
            RealClamp realClamp = param.getAnnotation(RealClamp.class);
            if (realClamp != null) {
                return NumberArgumentHandler.clampReal(realClamp, num, cast);
            }
            IntClamp intClamp = param.getAnnotation(IntClamp.class);
            if (intClamp != null) {
                return NumberArgumentHandler.clampInteger(intClamp, num, cast);
            }
            return num;
        };
        HashMap<Class, Function<Number, Function>> processingStages = new HashMap<Class, Function<Number, Function>>();
        processingStages.put(Byte.class, intProcessor.apply(Number::byteValue));
        processingStages.put(Short.class, intProcessor.apply(Number::shortValue));
        processingStages.put(Integer.class, intProcessor.apply(Number::intValue));
        processingStages.put(Long.class, intProcessor.apply(Number::longValue));
        processingStages.put(Double.class, realProcessor.apply(Number::doubleValue));
        processingStages.put(Float.class, realProcessor.apply(Number::floatValue));
        processingStages.put(BigInteger.class, num -> param -> {
            PreciseClamp preciseClamp = param.getAnnotation(PreciseClamp.class);
            if (preciseClamp != null) {
                return NumberArgumentHandler.clampBigInteger(preciseClamp, (BigInteger)num);
            }
            return (Number)((Function)((Function)intProcessor.apply(Function.identity())).apply(num)).apply(param);
        });
        processingStages.put(BigDecimal.class, num -> param -> {
            PreciseClamp preciseClamp = param.getAnnotation(PreciseClamp.class);
            if (preciseClamp != null) {
                return NumberArgumentHandler.clampBigDecimal(preciseClamp, (BigDecimal)num);
            }
            return (Number)((Function)((Function)realProcessor.apply(Function.identity())).apply(num)).apply(param);
        });
        POST_PROCESSORS = Collections.unmodifiableMap(processingStages);
    }
}

