/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.handlers;

import java.util.Arrays;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.parsing.InputParsingException;

public final class EnumArgumentHandler
implements ArgumentHandler<Enum<?>> {
    @Override
    public Enum<?> parse(CommandArgument input, CommandParameter parameter, CommandContext commandContext) throws InputParsingException {
        String lookupString = input.getRaw().toLowerCase();
        for (Enum constant : (Enum[])parameter.getType().getEnumConstants()) {
            if (!constant.name().toLowerCase().equals(lookupString) && !constant.toString().equals(lookupString)) continue;
            return constant;
        }
        throw new InputParsingException(String.format("'%s' is not a valid constant in enumeration %s", input.getRaw(), parameter.getType().getCanonicalName()));
    }

    @Override
    public String getSyntax(CommandParameter parameter) {
        String constantsString = Arrays.toString(parameter.getType().getEnumConstants());
        return parameter.getLabel() + " - one of " + constantsString.substring(1, constantsString.length() - 1);
    }

    @Override
    public Class[] getHandledTypes() {
        return new Class[]{Enum.class};
    }
}

