/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.handlers;

import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.internal.annotations.Length;
import pw.stamina.mandate.internal.annotations.strings.Equals;
import pw.stamina.mandate.parsing.InputParsingException;

public class CharSequenceArgumentHandler
implements ArgumentHandler<CharSequence> {
    private static final Map<Class<?>, Function<String, ? extends CharSequence>> sequencers;

    @Override
    public CharSequence parse(CommandArgument input, CommandParameter parameter, CommandContext commandContext) throws InputParsingException {
        if (input.getRaw().isEmpty()) {
            return null;
        }
        Equals equals = parameter.getAnnotation(Equals.class);
        if (equals != null) {
            for (String string : equals.value()) {
                if (equals.regex()) {
                    if (!Pattern.compile(string).matcher(input.getRaw()).matches()) continue;
                } else if (!string.equalsIgnoreCase(input.getRaw())) continue;
                return CharSequenceArgumentHandler.formatSequence(input.getRaw(), parameter.getType());
            }
            throw new InputParsingException(String.format("'%s' doesn't match ['%s'] (regex=%s)", input.getRaw(), String.join((CharSequence)" / ", equals.value()), equals.regex()));
        }
        Length length = parameter.getAnnotation(Length.class);
        if (length != null) {
            int min = Math.min(length.min(), length.max());
            int max = Math.max(length.min(), length.max());
            if (input.getRaw().length() < min) {
                throw new InputParsingException(String.format("'%s' is too short: length can be between %d-%d characters", input.getRaw(), min, max));
            }
            if (input.getRaw().length() > max) {
                throw new InputParsingException(String.format("'%s' is too long: length can be between %d-%d characters", input.getRaw(), min, max));
            }
        }
        return CharSequenceArgumentHandler.formatSequence(input.getRaw(), parameter.getType());
    }

    @Override
    public String getSyntax(CommandParameter parameter) {
        Equals equals = parameter.getAnnotation(Equals.class);
        if (equals != null) {
            return parameter.getLabel() + " - " + String.format("%s['%s', regex=%s]", parameter.getType().getSimpleName(), String.join((CharSequence)" / ", equals.value()), equals.regex());
        }
        Length length = parameter.getAnnotation(Length.class);
        if (length != null) {
            return parameter.getLabel() + " - " + String.format("%s[%s-%s chars]", parameter.getType().getSimpleName(), Math.min(length.min(), length.max()), Math.max(length.min(), length.max()));
        }
        return parameter.getLabel() + " - String";
    }

    @Override
    public Class[] getHandledTypes() {
        return new Class[]{CharSequence.class};
    }

    private static CharSequence formatSequence(String input, Class<?> sequenceType) throws InputParsingException {
        return Optional.ofNullable(sequencers.get(sequenceType)).map(f -> (CharSequence)f.apply(input)).orElseThrow(() -> new InputParsingException(String.format("CharSequences of type %s are not supported at this time", sequenceType.getCanonicalName())));
    }

    static {
        HashMap seq = new HashMap();
        seq.put(String.class, Function.identity());
        seq.put(StringBuilder.class, StringBuilder::new);
        seq.put(StringBuffer.class, StringBuffer::new);
        seq.put(CharBuffer.class, CharBuffer::wrap);
        seq.put(Segment.class, s -> new Segment(s.toCharArray(), 0, s.length()));
        sequencers = seq;
    }
}

