/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.syntax.component;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import pw.stamina.mandate.annotations.Executes;
import pw.stamina.mandate.annotations.Syntax;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.executable.CommandExecutable;
import pw.stamina.mandate.internal.syntax.component.BaseSyntaxComponent;
import pw.stamina.mandate.internal.syntax.component.MissingSyntaxException;
import pw.stamina.mandate.syntax.SyntaxComponent;
import pw.stamina.mandate.syntax.SyntaxComponentCreationStrategy;

public enum DefaultSyntaxComponentFactory implements SyntaxComponentCreationStrategy
{
    INSTANCE;


    @Override
    public Set<SyntaxComponent> getComponents(Method backingMethod, Object container, CommandContext commandContext) {
        Syntax syntax = backingMethod.getDeclaredAnnotation(Syntax.class);
        if (syntax == null && (syntax = backingMethod.getDeclaringClass().getDeclaredAnnotation(Syntax.class)) == null) {
            throw new MissingSyntaxException("No syntax annotation found for method " + backingMethod.getName() + " annotated as executable.");
        }
        String[][] tree = DefaultSyntaxComponentFactory.treeifySubSyntax(backingMethod.getDeclaredAnnotation(Executes.class).tree());
        if (tree.length <= 0) {
            CommandExecutable executable = commandContext.getCommandConfiguration().getExecutableCreationStrategy().newExecutable(backingMethod, container, commandContext);
            return Arrays.stream(syntax.root()).map(s -> new BaseSyntaxComponent((String)s, executable)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        Set parents = Arrays.stream(syntax.root()).map(BaseSyntaxComponent::new).collect(Collectors.toCollection(LinkedHashSet::new));
        DefaultSyntaxComponentFactory.addSubSyntax(parents, tree, 0, commandContext.getCommandConfiguration().getExecutableCreationStrategy().newExecutable(backingMethod, container, commandContext));
        return parents;
    }

    private static void addSubSyntax(Collection<SyntaxComponent> syntaxComponents, String[][] syntaxTree, int index, CommandExecutable terminalOp) {
        for (SyntaxComponent component : syntaxComponents) {
            if (index < syntaxTree.length - 1) {
                Arrays.stream(syntaxTree[index]).map(BaseSyntaxComponent::new).forEach(component::addChild);
                DefaultSyntaxComponentFactory.addSubSyntax((Collection<SyntaxComponent>)component.findChildren().get(), syntaxTree, index + 1, terminalOp);
                continue;
            }
            Arrays.stream(syntaxTree[index]).map(s -> new BaseSyntaxComponent((String)s, terminalOp)).forEach(component::addChild);
        }
    }

    private static String[][] treeifySubSyntax(String[] commandSubSyntax) {
        return (String[][])Arrays.stream(commandSubSyntax).map(tree -> tree.split(Pattern.quote("|"))).toArray(x$0 -> new String[x$0][]);
    }

    public static DefaultSyntaxComponentFactory getInstance() {
        return INSTANCE;
    }
}

