/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.syntax.component;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import pw.stamina.mandate.execution.executable.CommandExecutable;
import pw.stamina.mandate.syntax.SyntaxComponent;

class BaseSyntaxComponent
implements SyntaxComponent {
    private Map<String, SyntaxComponent> childMap;
    private final String syntax;
    private Set<CommandExecutable> executables;

    BaseSyntaxComponent(String syntax) {
        this(syntax, new CommandExecutable[0]);
    }

    BaseSyntaxComponent(String syntax, CommandExecutable ... executables) {
        this.syntax = syntax;
        if (executables.length > 0) {
            this.executables = new HashSet<CommandExecutable>(Arrays.asList(executables));
        }
    }

    @Override
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public Optional<SyntaxComponent> findChild(String syntax) {
        return this.childMap != null ? Optional.ofNullable(this.childMap.get(syntax)) : Optional.empty();
    }

    @Override
    public void addChild(SyntaxComponent component) {
        if (this.childMap == null) {
            this.childMap = new LinkedHashMap<String, SyntaxComponent>();
        }
        this.childMap.put(component.getSyntax(), component);
    }

    @Override
    public Optional<Set<SyntaxComponent>> findChildren() {
        return Optional.ofNullable(this.childMap).map(children -> new HashSet(children.values())).map(Collections::unmodifiableSet);
    }

    @Override
    public void addExecutable(CommandExecutable executable) {
        if (this.executables == null) {
            this.executables = new HashSet<CommandExecutable>();
        }
        this.executables.add(executable);
    }

    @Override
    public Optional<Set<CommandExecutable>> findExecutables() {
        return Optional.ofNullable(this.executables);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseSyntaxComponent that = (BaseSyntaxComponent)o;
        return Objects.equals(this.syntax, that.syntax);
    }

    public int hashCode() {
        return Objects.hash(this.syntax);
    }

    public String toString() {
        return String.format("BaseSyntaxComponent{syntax=%s, children=%s, executables=%s}", this.syntax, this.childMap.values(), this.executables);
    }
}

