/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pw.stamina.mandate.execution.ExecutionContext;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.executable.CommandExecutable;
import pw.stamina.mandate.internal.syntax.SimpleExecutableLookup;
import pw.stamina.mandate.internal.syntax.component.ImmutableSyntaxComponentDecorator;
import pw.stamina.mandate.parsing.InputParsingException;
import pw.stamina.mandate.syntax.CommandRegistry;
import pw.stamina.mandate.syntax.ExecutableLookup;
import pw.stamina.mandate.syntax.SyntaxComponent;

public class SimpleCommandRegistry
implements CommandRegistry {
    private final Map<String, SyntaxComponent> registeredCommands = new HashMap<String, SyntaxComponent>();

    @Override
    public Set<SyntaxComponent> getCommands() {
        return Collections.unmodifiableSet(this.registeredCommands.values().stream().map(ImmutableSyntaxComponentDecorator::new).collect(Collectors.toSet()));
    }

    @Override
    public void addCommand(SyntaxComponent component) {
        SyntaxComponent old = this.registeredCommands.get(component.getSyntax());
        if (old == null) {
            this.registeredCommands.put(component.getSyntax(), component);
        } else {
            SimpleCommandRegistry.mergeSyntaxComponent(component, old);
        }
    }

    @Override
    public ExecutableLookup findExecutable(Deque<CommandArgument> arguments, ExecutionContext executionContext) {
        int depth = 0;
        ArrayList<CommandArgument> consumedArgs = new ArrayList<CommandArgument>();
        CommandArgument currentArgument = arguments.getFirst();
        SyntaxComponent currentComponent = this.registeredCommands.get(currentArgument.getRaw());
        if (currentComponent != null) {
            while ((currentArgument = arguments.poll()) != null) {
                Optional<SyntaxComponent> tokenLookup;
                consumedArgs.add(currentArgument);
                if (currentComponent.findExecutables().isPresent()) {
                    int lowestConsumed = Integer.MAX_VALUE;
                    InputParsingException lastException = null;
                    for (CommandExecutable executable : currentComponent.findExecutables().get()) {
                        if (arguments.size() >= executable.minimumArguments() && arguments.size() <= executable.maximumArguments()) {
                            try {
                                executable.validate(arguments, executionContext);
                                return new SimpleExecutableLookup(executable, null);
                            }
                            catch (InputParsingException e) {
                                lastException = e;
                                continue;
                            }
                        }
                        lowestConsumed = lowestConsumed > executable.minimumArguments() ? executable.minimumArguments() : lowestConsumed;
                    }
                    if (lastException != null) {
                        return new SimpleExecutableLookup(null, lastException);
                    }
                    if (lowestConsumed != Integer.MAX_VALUE) {
                        depth += lowestConsumed;
                    }
                }
                if (!arguments.isEmpty() && (tokenLookup = currentComponent.findChild(arguments.getFirst().getRaw())).isPresent()) {
                    ++depth;
                    currentComponent = tokenLookup.get();
                    continue;
                }
                consumedArgs.addAll(arguments);
                if (++depth <= consumedArgs.size()) {
                    return new SimpleExecutableLookup(null, new InputParsingException(String.format("Invalid argument(s) '%s' passed to command '%s'", consumedArgs.subList(depth, consumedArgs.size()), consumedArgs.subList(0, depth))));
                }
                return new SimpleExecutableLookup(null, new InputParsingException(String.format("Missing %d argument(s) for command '%s'", depth - consumedArgs.size(), consumedArgs)));
            }
            return new SimpleExecutableLookup(null, new IllegalStateException("No possible arguments available to parse"));
        }
        return new SimpleExecutableLookup(null, new InputParsingException(String.format("'%s' is not a valid command", currentArgument)));
    }

    @Override
    public boolean commandPresent(String command) {
        return this.registeredCommands.containsKey(command);
    }

    private static void mergeSyntaxComponent(SyntaxComponent newComponent, SyntaxComponent oldComponent) {
        newComponent.findExecutables().ifPresent(set -> set.forEach(oldComponent::addExecutable));
        if (newComponent.findChildren().isPresent()) {
            for (SyntaxComponent component : newComponent.findChildren().get()) {
                Optional<SyntaxComponent> lookup = oldComponent.findChild(component.getSyntax());
                if (lookup.isPresent()) {
                    SimpleCommandRegistry.mergeSyntaxComponent(component, lookup.get());
                    continue;
                }
                oldComponent.addChild(component);
            }
        }
    }
}

