/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.parsing;

import java.util.ArrayDeque;
import java.util.Deque;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.argument.CommandArgumentCreationStrategy;
import pw.stamina.mandate.parsing.InputTokenizationException;
import pw.stamina.mandate.parsing.InputTokenizationStrategy;

public enum DefaultInputTokenizer implements InputTokenizationStrategy
{
    INSTANCE;


    public static DefaultInputTokenizer getInstance() {
        return INSTANCE;
    }

    @Override
    public Deque<CommandArgument> parse(String input, CommandArgumentCreationStrategy argumentCreationStrategy) throws InputTokenizationException {
        ArrayDeque<CommandArgument> arguments = new ArrayDeque<CommandArgument>();
        StringBuilder content = new StringBuilder();
        boolean escaped = false;
        boolean quoted = false;
        int depth = 0;
        block7: for (char character : input.toCharArray()) {
            if (escaped) {
                content.append(character);
                escaped = false;
                continue;
            }
            switch (character) {
                case '\\': {
                    escaped = true;
                    continue block7;
                }
                case '\"': {
                    boolean bl = quoted = !quoted;
                    if (depth <= 0) continue block7;
                    content.append(character);
                    continue block7;
                }
                case ']': {
                    if (!quoted) {
                        --depth;
                    }
                    content.append(character);
                    continue block7;
                }
                case '[': {
                    if (!quoted) {
                        ++depth;
                    }
                    content.append(character);
                    continue block7;
                }
                case ' ': {
                    if (!quoted && depth == 0) {
                        if (content.length() <= 0) continue block7;
                        arguments.add(argumentCreationStrategy.newArgument(content.toString()));
                        content.setLength(0);
                        continue block7;
                    }
                }
                default: {
                    content.append(character);
                }
            }
        }
        if (depth > 0) {
            throw new InputTokenizationException("Found unterminated list in input: missing " + depth + " terminators");
        }
        if (depth < 0) {
            throw new InputTokenizationException("Found " + Math.abs(depth) + " too many list terminators in input");
        }
        if (content.length() > 0) {
            arguments.add(argumentCreationStrategy.newArgument(content.toString()));
            content.setLength(0);
        }
        return arguments;
    }
}

